/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ptree.bean;

import cgdp.recog.ptree.bean.data.DPoint;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class dgGraphics
implements Cloneable {
    public static Color hiliteColor = new Color(16, 240, 16);
    private static Color inverseColor = Color.white;
    protected double m_gXmin;
    protected double m_gYmax;
    protected DPoint m_gScale;
    protected Graphics m_g;
    protected int m_lineStyle;
    protected int m_atx;
    protected int m_aty;
    protected int m_rcLeft;
    protected int m_rcTop;
    protected int m_rcWidth;
    protected int m_rcHeight;
    protected boolean m_isMagnified = false;
    protected double m_magX = 1.0;
    protected double m_magY = 1.0;
    protected boolean m_isDimmed = false;
    protected Font m_fontItalic;

    public dgGraphics(Graphics graphics) {
        this.init();
        this.m_g = graphics;
    }

    public dgGraphics(dgGraphics dgGraphics2) {
        this.init();
        if (dgGraphics2 != null) {
            this.set(dgGraphics2);
        }
    }

    public void init() {
        this.m_lineStyle = 1;
        this.m_gScale = new DPoint(12.0, 12.0);
        this.m_aty = 0;
        this.m_atx = 0;
        this.m_fontItalic = new Font("Dialog", 2, 10);
    }

    public double getGrXmin() {
        return this.m_gXmin;
    }

    public double getGrYmax() {
        return this.m_gYmax;
    }

    public DPoint getDrawScale() {
        return new DPoint(this.m_gScale);
    }

    public Graphics getGraphics() {
        return this.m_g;
    }

    public final int getLineStyle() {
        return this.m_lineStyle;
    }

    public final int atX() {
        return this.m_atx;
    }

    public final int atY() {
        return this.m_aty;
    }

    public final Point atPoint() {
        return new Point(this.m_atx, this.m_aty);
    }

    public void getPen(Point point) {
        point.x = this.m_atx;
        point.y = this.m_aty;
    }

    public final int offsetX() {
        return this.m_rcLeft;
    }

    public final int offsetY() {
        return this.m_rcTop;
    }

    public final Point offset() {
        return new Point(this.m_rcLeft, this.m_rcTop);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.m_rcLeft, this.m_rcTop, this.m_rcWidth, this.m_rcHeight);
    }

    public boolean isMagnified() {
        return this.m_isMagnified;
    }

    public boolean isDimmed() {
        return this.m_isDimmed;
    }

    public void setGrXmin(double d) {
        this.m_gXmin = d;
    }

    public void setGrYmax(double d) {
        this.m_gYmax = d;
    }

    public void setDrawScale(DPoint dPoint) {
        this.m_gScale = new DPoint(dPoint);
    }

    public void setDrawScale(double d, double d2) {
        this.m_gScale = new DPoint(d, d2);
    }

    public void setGraphics(Graphics graphics) {
        this.m_g = graphics;
    }

    public final void setLineStyle(int n) {
        this.m_lineStyle = n;
    }

    public final void lineSolid() {
        this.setLineStyle(1);
    }

    public final void lineDark() {
        this.setLineStyle(2);
    }

    public final void lineMedium() {
        this.setLineStyle(3);
    }

    public final void lineLight() {
        this.setLineStyle(4);
    }

    public final void lineDotted() {
        this.setLineStyle(5);
    }

    public final void lineDashed() {
        this.setLineStyle(6);
    }

    public void set(dgGraphics dgGraphics2) {
        this.m_gXmin = dgGraphics2.getGrXmin();
        this.m_gYmax = dgGraphics2.getGrYmax();
        this.m_gScale = dgGraphics2.getDrawScale();
        this.m_atx = dgGraphics2.atX();
        this.m_aty = dgGraphics2.atY();
        this.m_rcLeft = dgGraphics2.getBounds().x;
        this.m_rcTop = dgGraphics2.getBounds().y;
        this.m_rcWidth = dgGraphics2.getBounds().width;
        this.m_rcHeight = dgGraphics2.getBounds().height;
        this.m_isMagnified = dgGraphics2.isMagnified();
        this.m_isDimmed = dgGraphics2.isDimmed();
        this.m_g = dgGraphics2.getGraphics();
    }

    public void drawString(String string, int n, int n2) {
        if (string != null) {
            int n3;
            if (string.startsWith("ccr") && (n3 = string.indexOf(40)) != -1) {
                String string2 = string.substring(0, n3);
                String string3 = string.substring(n3);
                Font font = this.m_g.getFont();
                this.m_g.setFont(this.m_fontItalic);
                FontMetrics fontMetrics = this.m_g.getFontMetrics();
                this.m_g.drawString(string2, n + this.m_rcLeft, n2 + this.m_rcTop);
                int n4 = fontMetrics.stringWidth(string2);
                this.m_g.setFont(font);
                this.m_g.drawString(string3, n + this.m_rcLeft + n4, n2 + this.m_rcTop);
            } else {
                this.m_g.drawString(string, n + this.m_rcLeft, n2 + this.m_rcTop);
            }
        }
    }

    public final void drawString(String string) {
        this.drawString(string, this.m_atx, this.m_aty);
    }

    public void drawStringJust(String string, Rectangle rectangle, char c) {
        if (string == null) {
            return;
        }
        FontMetrics fontMetrics = this.m_g.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        int n2 = this.m_rcLeft + rectangle.x;
        int n3 = this.m_rcTop + rectangle.y + rectangle.height - fontMetrics.getDescent();
        if (this.m_isMagnified) {
            n2 = (int)((double)n2 * this.m_magX);
            n3 = (int)((double)n3 * this.m_magY);
        }
        switch (c) {
            default: {
                this.m_g.drawString(string, n2, n3);
                break;
            }
            case 'c': {
                this.m_g.drawString(string, n2 += Math.max(0, (rectangle.width - n) / 2), n3);
                break;
            }
            case 'r': {
                this.m_g.drawString(string, n2 += Math.max(0, rectangle.width - n), n3);
            }
        }
    }

    public void drawChar(byte by, int n, int n2) {
        byte[] byArray = new byte[]{by};
        this.m_g.drawBytes(byArray, 0, 1, n + this.m_rcLeft, n2 + this.m_rcTop);
        this.m_atx = n;
        this.m_aty = n2;
    }

    public void drawChar(char c, int n, int n2) {
        char[] cArray = new char[]{c};
        this.m_g.drawChars(cArray, 0, 1, n + this.m_rcLeft, n2 + this.m_rcTop);
        this.m_atx = n;
        this.m_aty = n2;
    }

    public final void drawChar(byte by) {
        this.drawChar(by, this.m_atx, this.m_aty);
    }

    public final void drawChar(char c) {
        this.drawChar(c, this.m_atx, this.m_aty);
    }

    public void drawInverseChar(char c, int n, int n2) {
        FontMetrics fontMetrics = this.m_g.getFontMetrics();
        int n3 = fontMetrics.charWidth(c);
        this.m_g.fillRect(n + this.m_rcLeft, n2 + this.m_rcTop - fontMetrics.getAscent(), n3, fontMetrics.getHeight());
        Color color = this.m_g.getColor();
        this.m_g.setColor(inverseColor);
        this.drawChar(c, n, n2);
        this.m_g.setColor(color);
    }

    public final void drawInverseChar(char c) {
        this.drawInverseChar(c, this.m_atx, this.m_aty);
    }

    protected void line2(int n, int n2) {
        Color color = null;
        switch (this.m_lineStyle) {
            case 1: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 2: {
                color = this.m_g.getColor();
                this.m_g.setColor(Color.darkGray);
                break;
            }
            case 3: {
                color = this.m_g.getColor();
                this.m_g.setColor(Color.gray);
                break;
            }
            case 4: {
                color = this.m_g.getColor();
                this.m_g.setColor(Color.lightGray);
            }
        }
        this.m_g.drawLine(this.m_atx + this.m_rcLeft, this.m_aty + this.m_rcTop, n + this.m_rcLeft, n2 + this.m_rcTop);
        if (color != null) {
            this.m_g.setColor(color);
        }
        this.m_atx = n;
        this.m_aty = n2;
    }

    public final void lineto(int n, int n2) {
        if (this.m_isMagnified) {
            n = this.magx(n);
            n2 = this.magy(n2);
        }
        this.line2(n, n2);
    }

    public final void lineto(Point point) {
        this.lineto(point.x, point.y);
    }

    public final void line(int n, int n2) {
        if (this.m_isMagnified) {
            n = this.magx(n);
            n2 = this.magy(n2);
        }
        this.line2(n + this.m_atx, n2 + this.m_aty);
    }

    public final void line(Point point) {
        this.line(point.x, point.y);
    }

    public final void drawLine(int n, int n2, int n3, int n4) {
        this.moveto(n, n2);
        this.lineto(n3, n4);
    }

    public final void drawRectangle(int n, int n2, int n3, int n4) {
        this.moveto(n, n2);
        this.lineto(n + n3, n2);
        this.lineto(n + n3, n2 + n4);
        this.lineto(n, n2 + n4);
        this.lineto(n, n2);
    }

    public final void drawRectangle(Rectangle rectangle) {
        this.drawRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void moveto(int n, int n2) {
        if (this.m_isMagnified) {
            n = this.magx(n);
            n2 = this.magy(n2);
        }
        this.m_atx = n;
        this.m_aty = n2;
    }

    public final void moveto(Point point) {
        this.moveto(point.x, point.y);
    }

    public void move(int n, int n2) {
        if (this.m_isMagnified) {
            n = this.magx(n);
            n2 = this.magy(n2);
        }
        this.m_atx += n;
        this.m_aty += n2;
    }

    public final void move(Point point) {
        this.move(point.x, point.y);
    }

    public void setBounds(Rectangle rectangle) {
        this.m_rcLeft = rectangle.x;
        this.m_rcTop = rectangle.y;
        this.m_rcWidth = rectangle.width;
        this.m_rcHeight = rectangle.height;
    }

    public void setMagnified(boolean bl, double d, double d2) {
        this.m_isMagnified = bl;
        this.m_magX = d;
        this.m_magY = d2;
    }

    public void setDimmed(boolean bl) {
        this.m_isDimmed = bl;
    }

    public Point map2port(double d, double d2) {
        int n = (int)Math.round(this.m_gScale.x * (d - this.m_gXmin));
        int n2 = (int)Math.round(this.m_gScale.y * (this.m_gYmax - d2));
        return new Point(n, n2);
    }

    public DPoint map2world(int n, int n2) {
        double d = this.m_gXmin + (double)n / this.m_gScale.x;
        double d2 = this.m_gYmax - (double)n2 / this.m_gScale.y;
        return new DPoint(d, d2);
    }

    public static Point pinRect(Rectangle rectangle, Point point) {
        Point point2 = new Point(point.x, point.y);
        if (point2.x < rectangle.x) {
            point2.x = rectangle.x;
        } else {
            int n = rectangle.x + rectangle.width - 1;
            if (point2.x > n) {
                point2.x = n;
            }
        }
        if (point2.y < rectangle.y) {
            point2.y = rectangle.y;
        } else {
            int n = rectangle.y + rectangle.height - 1;
            if (point2.y > n) {
                point2.y = n;
            }
        }
        return point2;
    }

    public int magx(int n) {
        n = (int)((double)n * this.m_magX);
        return n;
    }

    public int magy(int n) {
        n = (int)((double)n * this.m_magY);
        return n;
    }
}

