/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.search;

import cgdp.recog.data.Cluster;
import cgdp.recog.search.KeywordSearchResult;
import cgdp.recog.util.StringTool;
import java.util.Comparator;

public class KeywordSearchResultComparator
implements Comparator {
    public int compare(Object object, Object object2) {
        KeywordSearchResult keywordSearchResult = (KeywordSearchResult)object;
        KeywordSearchResult keywordSearchResult2 = (KeywordSearchResult)object2;
        int n = this.compareFunctionCategory(keywordSearchResult.getCluster(), keywordSearchResult2.getCluster());
        if (n != 0) {
            return n;
        }
        return this.compareGene(keywordSearchResult, keywordSearchResult2);
    }

    private int compareGene(KeywordSearchResult keywordSearchResult, KeywordSearchResult keywordSearchResult2) {
        int n = keywordSearchResult.getOrganismCode().compareTo(keywordSearchResult2.getOrganismCode());
        if (n != 0) {
            return n;
        }
        return keywordSearchResult.getGeneInformation().getLocusTag().compareTo(keywordSearchResult2.getGeneInformation().getLocusTag());
    }

    private int compareFunctionCategory(Cluster cluster, Cluster cluster2) {
        if (cluster.getFunctionCategory() == null && cluster2.getFunctionCategory() == null) {
            return this.compareGeneName(cluster, cluster2);
        }
        if (cluster.getFunctionCategory() == null) {
            return -1;
        }
        if (cluster2.getFunctionCategory() == null) {
            return 1;
        }
        int n = cluster.getFunctionCategory().compareTo(cluster2.getFunctionCategory());
        if (n != 0) {
            return n;
        }
        return this.compareGeneName(cluster, cluster2);
    }

    private int compareGeneName(Cluster cluster, Cluster cluster2) {
        if (StringTool.isNull(cluster.getGeneName()) && StringTool.isNull(cluster2.getGeneName())) {
            return this.compareClusterId(cluster, cluster2);
        }
        if (StringTool.isNull(cluster.getGeneName())) {
            return 1;
        }
        if (StringTool.isNull(cluster2.getGeneName())) {
            return -1;
        }
        int n = cluster.getGeneName().compareTo(cluster2.getGeneName());
        if (n != 0) {
            return n;
        }
        return this.compareClusterId(cluster, cluster2);
    }

    private int compareClusterId(Cluster cluster, Cluster cluster2) {
        int n;
        int n2 = cluster.getClusterId();
        int n3 = n2 - (n = cluster2.getClusterId());
        if (n3 != 0) {
            return n3;
        }
        if (Cluster.isNoValue(cluster.getSubClusterId()) || Cluster.isNoValue(cluster2.getSubClusterId())) {
            return n3;
        }
        int n4 = cluster.getSubClusterId();
        int n5 = cluster2.getSubClusterId();
        return n4 - n5;
    }
}

