/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.cluster;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.controltree.ControlTitleNode;
import cgdp.recog.controltree.ControlTitleType;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.AbstractSetTreeController;
import cgdp.recog.set.SetElementAddItem;
import cgdp.recog.set.SetExportItem;
import cgdp.recog.set.SetTreeNode;
import cgdp.recog.set.cluster.ClusterDeleteItem;
import cgdp.recog.set.cluster.ClusterSet;
import cgdp.recog.set.cluster.ClusterSetDeleteItem;
import cgdp.recog.set.cluster.ClusterSetDownloadItem;
import cgdp.recog.set.cluster.ClusterSetEditItem;
import cgdp.recog.set.cluster.ClusterSetFacade;
import cgdp.recog.set.cluster.ClusterSetRegisterItem;
import cgdp.recog.set.cluster.ClusterSetUploadItem;
import cgdp.recog.set.cluster.ClusterTreeNode;
import cgdp.recog.set.color.SetFilerColorItem;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ClusterSetTreeController
extends AbstractSetTreeController {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterSetTreeController.class);
    private ClusterTbl clusterTbl;

    public ClusterSetTreeController(Frame frame, MediatorImpl mediatorImpl) {
        super(frame, mediatorImpl);
    }

    @Override
    public void createTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.clusterTbl == null) {
            return;
        }
        List list = ClusterSetFacade.getInstance().getClusterSetListCurrentProject();
        for (ClusterSet clusterSet : list) {
            if (!clusterSet.equalsDomClustId(this.clusterTbl.getClusterId())) continue;
            List list2 = ClusterSetFacade.getInstance().importElementList(clusterSet);
            SetTreeNode setTreeNode = new SetTreeNode(clusterSet);
            defaultMutableTreeNode.add(setTreeNode);
        }
    }

    @Override
    public JPopupMenu createPopupMenu(JTree jTree, ActionListener actionListener) {
        Set set;
        Object object;
        if (this.clusterTbl == null) {
            return null;
        }
        TreePath[] treePathArray = jTree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return null;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.isShowSetMenu(treePathArray)) {
            jPopupMenu.add(new ClusterSetRegisterItem(actionListener, this.mediator));
            jPopupMenu.add(new ClusterSetDownloadItem(actionListener, this.parent, this.mediator));
        }
        if (this.isShowSetTitleMenu(treePathArray)) {
            if (this.isShowFilterColorMenu(treePathArray)) {
                object = this.getClusterSetList(treePathArray);
                jPopupMenu.add(new SetFilerColorItem(actionListener, this.mediator, 2, (List)object));
            }
            object = this.getClusterSet(treePathArray);
            set = this.getElementSetSet(treePathArray);
            jPopupMenu.addSeparator();
            jPopupMenu.add(new SetExportItem(actionListener, this.mediator, (AbstractElementSet)object));
            jPopupMenu.add(new ClusterSetDownloadItem(actionListener, this.parent, this.mediator));
            jPopupMenu.add(new ClusterSetUploadItem(actionListener, this.parent, this.mediator, set));
            jPopupMenu.addSeparator();
            jPopupMenu.add(new SetElementAddItem(actionListener, this.mediator, (AbstractElementSet)object));
            jPopupMenu.add(new ClusterSetEditItem(actionListener, this.parent, this.mediator, this.clusterTbl, (ClusterSet)object));
            jPopupMenu.add(new ClusterSetDeleteItem(actionListener, this.mediator, set));
        }
        if (this.isShowElementMenu(treePathArray)) {
            object = this.getClusterSet(treePathArray);
            set = this.getElementSetSet(treePathArray);
            if (this.isShowDeleteElementMenu(treePathArray)) {
                Set set2 = this.getClusterC(treePathArray);
                jPopupMenu.add(new ClusterDeleteItem(actionListener, this.parent, this.mediator, (ClusterSet)object, set2));
                jPopupMenu.addSeparator();
            }
            jPopupMenu.add(new ClusterSetRegisterItem(actionListener, this.mediator));
            jPopupMenu.add(new ClusterSetEditItem(actionListener, this.parent, this.mediator, this.clusterTbl, (ClusterSet)object));
            jPopupMenu.add(new ClusterSetDeleteItem(actionListener, this.mediator, set));
        }
        return jPopupMenu;
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
    }

    private ClusterSet getClusterSet(TreePath[] treePathArray) {
        return (ClusterSet)this.getElementSet(treePathArray);
    }

    private List getClusterSetList(TreePath[] treePathArray) {
        ArrayList<AbstractElementSet> arrayList = new ArrayList<AbstractElementSet>();
        for (int i = 0; i < treePathArray.length; ++i) {
            AbstractElementSet abstractElementSet;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            if (!(defaultMutableTreeNode instanceof SetTreeNode) || !(abstractElementSet = ((SetTreeNode)defaultMutableTreeNode).getElementSet()).isClusterSet()) continue;
            arrayList.add(abstractElementSet);
        }
        return arrayList;
    }

    private Set getClusterC(TreePath[] treePathArray) {
        HashSet<Cluster> hashSet = new HashSet<Cluster>();
        for (int i = 0; i < treePathArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            if (!(defaultMutableTreeNode instanceof ClusterTreeNode)) continue;
            Cluster cluster = ((ClusterTreeNode)defaultMutableTreeNode).getCluster();
            hashSet.add(cluster);
        }
        return hashSet;
    }

    private boolean isShowSetMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() != 2) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(1);
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
        return ControlTitleType.isClusterSet(controlTitleNode.getControlTitleType());
    }

    private boolean isShowSetTitleMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() != 3) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(1);
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getPathComponent(2);
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        if (!(defaultMutableTreeNode2 instanceof SetTreeNode)) {
            return false;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
        SetTreeNode setTreeNode = (SetTreeNode)defaultMutableTreeNode2;
        if (!ControlTitleType.isClusterSet(controlTitleNode.getControlTitleType())) {
            return false;
        }
        return setTreeNode.getElementSet().isClusterSet();
    }

    private boolean isShowElementMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() != 4) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(1);
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getPathComponent(2);
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        if (!(defaultMutableTreeNode2 instanceof SetTreeNode)) {
            return false;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
        SetTreeNode setTreeNode = (SetTreeNode)defaultMutableTreeNode2;
        if (!ControlTitleType.isClusterSet(controlTitleNode.getControlTitleType())) {
            return false;
        }
        return setTreeNode.getElementSet().isClusterSet();
    }

    private boolean isShowFilterColorMenu(TreePath[] treePathArray) {
        for (int i = 0; i < treePathArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            if (defaultMutableTreeNode instanceof SetTreeNode) {
                AbstractElementSet abstractElementSet = ((SetTreeNode)defaultMutableTreeNode).getElementSet();
                if (abstractElementSet instanceof ClusterSet) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean isShowDeleteElementMenu(TreePath[] treePathArray) {
        for (int i = 0; i < treePathArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            if (defaultMutableTreeNode instanceof ClusterTreeNode) continue;
            return false;
        }
        return true;
    }

    public void actionAfterDoubleClick(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (!(defaultMutableTreeNode instanceof SetTreeNode)) {
            return;
        }
        SetTreeNode setTreeNode = (SetTreeNode)defaultMutableTreeNode;
        AbstractElementSet abstractElementSet = setTreeNode.getElementSet();
        if (!abstractElementSet.isClusterSet()) {
            return;
        }
        try {
            ClusterSetFacade.getInstance().editClusterSet(this.mediator, (ClusterSet)abstractElementSet, this.clusterTbl);
        }
        catch (Exception exception) {
            String string = "Fail to edit cluster set.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.parent, string);
        }
    }
}

