/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.cluster;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.process.ProcessImpl;
import cgdp.recog.process.ProgressDialog;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.AbstractElementSetFacade;
import cgdp.recog.set.ElementSetComparator;
import cgdp.recog.set.SetDeleteAfterRunnable;
import cgdp.recog.set.SetDeleteRequestExecuter;
import cgdp.recog.set.cluster.ClusterSetDownloadExecuter;
import cgdp.recog.set.cluster.ClusterSetFacade;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class ServerClusterSetDialog
extends AbstractApplyDialog {
    private static final String TITLE = "Cluster Set List";
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private JTable setTable;
    private JButton deleteButton;

    private ServerClusterSetDialog(Dialog dialog, MediatorImpl mediatorImpl) {
        super(dialog);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    private ServerClusterSetDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    public static ServerClusterSetDialog createInstance(Component component, MediatorImpl mediatorImpl) {
        ServerClusterSetDialog serverClusterSetDialog = null;
        if (component instanceof Dialog) {
            serverClusterSetDialog = new ServerClusterSetDialog((Dialog)component, mediatorImpl);
        } else if (component instanceof Frame) {
            serverClusterSetDialog = new ServerClusterSetDialog((Frame)component, mediatorImpl);
        }
        return serverClusterSetDialog;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setTable = new JTable(new SetListTableModel());
        this.setTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ServerClusterSetDialog.this.setEnabledButton();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.setTable, 20, 30);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.deleteButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.getButtonPanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setApplyButtonName("Download");
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 15, 10, 15), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 15, 15, 15), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setEnabledButton();
    }

    private void setEnabledButton() {
        boolean bl = this.setTable.getSelectedRowCount() != 0;
        this.deleteButton.setEnabled(bl);
        this.applyButton.setEnabled(bl);
    }

    public void updateValue(List list, ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
        ArrayList arrayList = new ArrayList(list);
        Collections.sort(arrayList, new ElementSetComparator());
        this.getSetListTableModel().setSetList(arrayList);
    }

    private SetListTableModel getSetListTableModel() {
        return (SetListTableModel)this.setTable.getModel();
    }

    public List getSelectedSetList() {
        List list = this.getSetListTableModel().getSetList();
        int[] nArray = this.setTable.getSelectedRows();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(list.get(nArray[i]));
        }
        return arrayList;
    }

    private void delete() {
        final List list = this.getSelectedSetList();
        Object[] objectArray = new String[]{"Delete the following sets?", AbstractElementSetFacade.createElementSetNameString(list)};
        if (!MessageManager.showConfirmMessage((Component)this, objectArray)) {
            return;
        }
        SetDeleteRequestExecuter setDeleteRequestExecuter = new SetDeleteRequestExecuter(this, list);
        setDeleteRequestExecuter.setAfterRunnable(new SetDeleteAfterRunnable(){

            @Override
            public void run() {
                HashSet hashSet = new HashSet(list);
                hashSet.removeAll(this.getUnableDeleteSetC());
                ServerClusterSetDialog.this.getSetListTableModel().removeAll(list);
            }
        });
        new ProgressDialog((Dialog)this, this.mediator, 1, "Delete cluster set...", false, (ProcessImpl)setDeleteRequestExecuter);
    }

    @Override
    protected boolean apply() {
        List list = this.getSelectedSetList();
        Object[] objectArray = new String[]{"Download the following cluster sets?", AbstractElementSetFacade.getElementSetNameString(list)};
        if (!MessageManager.showConfirmMessage((Component)this, objectArray)) {
            return false;
        }
        List list2 = ClusterSetFacade.convertServerToLocalSet(list);
        if (!AbstractElementSetFacade.validateSet(this, list2)) {
            return false;
        }
        Project project = ProjectAccesser.getSelectedProject();
        ClusterSetDownloadExecuter clusterSetDownloadExecuter = new ClusterSetDownloadExecuter(this, list2, this.clusterTbl, project);
        clusterSetDownloadExecuter.setAfterRunnable(new Runnable(){

            @Override
            public void run() {
                ServerClusterSetDialog.this.mediator.updateClusterSetTree();
            }
        });
        new ProgressDialog((Dialog)this, this.mediator, 1, "Download cluster set...", false, (ProcessImpl)clusterSetDownloadExecuter);
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.deleteButton) {
            this.delete();
        }
    }

    private class SetListTableModel
    extends AbstractTableModel {
        private final String[] COLUMN_NAMES = new String[]{"Name", "Count"};
        private List setList = new ArrayList();

        private SetListTableModel() {
        }

        public void setSetList(List list) {
            this.setList = list;
            this.fireTableDataChanged();
        }

        public List getSetList() {
            return this.setList;
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.setList.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            AbstractElementSet abstractElementSet = (AbstractElementSet)this.setList.get(n);
            if (n2 == 0) {
                return abstractElementSet.getName();
            }
            if (n2 == 1) {
                return new Integer(abstractElementSet.getElementSize());
            }
            return null;
        }

        public void removeAll(Collection collection) {
            this.setList.removeAll(collection);
            this.fireTableDataChanged();
        }
    }
}

