/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.gene;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.filefilter.FileFilterFactory;
import cgdp.recog.info.LocationComboBox;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoTableModel;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.set.gene.GeneInfoOrganismLocusTagComparator;
import cgdp.recog.set.gene.GeneSet;
import cgdp.recog.set.gene.GeneSetFacade;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumn;

public class GeneSetEditDialog
extends AbstractApplyDialog {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneSetEditDialog.class);
    private static final String TITLE = "Edit gene set";
    private static GeneSetEditDialog GENE_SET_EDIT_DIALLG;
    private static final FileFilter FILE_FITER_GENE_SET;
    private static final Dimension TABLE_SIZE;
    private MediatorImpl mediator;
    private FocusTextField nameTextField;
    private LocationComboBox locationComboBox;
    private JTable geneTable;
    private JButton exportButton;
    private JButton deleteButton;
    private JFileChooser chooser;
    private GeneSet baseGeneSet;

    private GeneSetEditDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    public static void createInstance(Frame frame, MediatorImpl mediatorImpl) {
        if (GENE_SET_EDIT_DIALLG != null) {
            return;
        }
        GENE_SET_EDIT_DIALLG = new GeneSetEditDialog(frame, mediatorImpl);
    }

    static GeneSetEditDialog getInstance() {
        return GENE_SET_EDIT_DIALLG;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(true);
        this.createFileChooser();
        JLabel jLabel = new JLabel("Name");
        this.nameTextField = new FocusTextField();
        JLabel jLabel2 = new JLabel("Location");
        this.locationComboBox = new LocationComboBox();
        JLabel jLabel3 = new JLabel("Genes");
        this.geneTable = new JTable(new GeneInfoTableModel(this.getGeneInfoTitleList()));
        TableColumn tableColumn = this.geneTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(80);
        TableColumn tableColumn2 = this.geneTable.getColumnModel().getColumn(1);
        tableColumn2.setPreferredWidth(100);
        TableColumn tableColumn3 = this.geneTable.getColumnModel().getColumn(2);
        tableColumn3.setPreferredWidth(220);
        JScrollPane jScrollPane = new JScrollPane(this.geneTable, 20, 30);
        jScrollPane.getViewport().setPreferredSize(TABLE_SIZE);
        this.exportButton = new JButton("Export...");
        this.exportButton.addActionListener(this);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.exportButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.deleteButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.nameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 10), 0, 0));
        this.getContentPane().add((Component)jLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.locationComboBox, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 10), 0, 0));
        this.getContentPane().add((Component)jLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)jPanel2, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private List getGeneInfoTitleList() {
        ArrayList<GeneInfoTitle> arrayList = new ArrayList<GeneInfoTitle>();
        arrayList.add(GeneInfoTitle.TITLE_ORGANISM_CODE);
        arrayList.add(GeneInfoTitle.TITLE_LOCUSTAG_SERVER);
        arrayList.add(GeneInfoTitle.TITLE_DESCRIPTION);
        return arrayList;
    }

    private void createFileChooser() {
        this.chooser = new JFileChooser();
        this.chooser.setDialogTitle("Select file");
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.setFileFilter(FILE_FITER_GENE_SET);
    }

    void updateValue(GeneSet geneSet) {
        this.baseGeneSet = geneSet;
        this.nameTextField.setText(geneSet.getName());
        this.locationComboBox.updateLocationConboBox();
        this.locationComboBox.setSelectedItem(geneSet.getLocation());
        List list = geneSet.getElementList();
        if (list == null) {
            list = new ArrayList();
        } else {
            try {
                list = GeneInfoFacade.getGeneInfoList(list, this.getGeneInfoTitleList());
                Collections.sort(list, new GeneInfoOrganismLocusTagComparator());
            }
            catch (Exception exception) {
                logger.warn("Fail to load gene information.", exception);
            }
        }
        this.getGeneInfoTableModel().setGeneInfoList(list);
    }

    private GeneInfoTableModel getGeneInfoTableModel() {
        return (GeneInfoTableModel)this.geneTable.getModel();
    }

    private List getGeneInfoList() {
        return this.getGeneInfoTableModel().getGeneInfoList();
    }

    private String getSetName() {
        return this.nameTextField.getText();
    }

    private String getLocationString() {
        return (String)this.locationComboBox.getSelectedItem();
    }

    GeneSet createGeneSet() {
        GeneSet geneSet = new GeneSet();
        if (this.baseGeneSet != null) {
            geneSet.copy(this.baseGeneSet);
        }
        geneSet.setName(this.getSetName());
        geneSet.setLocation(this.getLocationString());
        geneSet.setElementList(this.getGeneInfoList());
        geneSet.setStatus(this.baseGeneSet.getStatus());
        if (!geneSet.equalsName(this.baseGeneSet.getName())) {
            geneSet.addEditName();
        }
        if (!geneSet.equalsLocation(this.baseGeneSet.getLocation())) {
            geneSet.addEditLocation();
        }
        if (!geneSet.equalsGeneInfoList(this.baseGeneSet)) {
            geneSet.addEditList();
        }
        return geneSet;
    }

    @Override
    protected boolean check() {
        Object[] objectArray;
        if (StringTool.isNull(this.getSetName())) {
            MessageManager.showErrorMessage((Component)this, "Input name.");
            return false;
        }
        GeneSet geneSet = this.getDuplicateGeneSet();
        return geneSet == null || MessageManager.showConfirmMessage((Component)this, objectArray = new String[]{"Overwrite gene set [" + this.getSetName() + "]?"});
    }

    private GeneSet getDuplicateGeneSet() {
        GeneSet geneSet = this.createGeneSet();
        GeneSet geneSet2 = (GeneSet)GeneSetFacade.getInstance().getSameElementSet(geneSet);
        if (geneSet2 == null || geneSet2.equalsElement(this.baseGeneSet)) {
            return null;
        }
        return geneSet2;
    }

    @Override
    protected boolean apply() {
        return true;
    }

    private void export() {
        GeneSet geneSet = this.createGeneSet();
        this.mediator.export(geneSet);
    }

    private void delete() {
        if (!MessageManager.showConfirmMessage((Component)this, "Delete clusters?")) {
            return;
        }
        int[] nArray = this.geneTable.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        this.getGeneInfoTableModel().remove(nArray);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.exportButton) {
            this.export();
        } else if (actionEvent.getSource() == this.deleteButton) {
            this.delete();
        }
    }

    static {
        FILE_FITER_GENE_SET = FileFilterFactory.createGeneSetFileWithDirFilter();
        TABLE_SIZE = new Dimension(400, 100);
    }
}

