/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy;

import cgdp.recog.data.DataManager;
import cgdp.recog.data.RankDif;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.taxonomy.DisplayTaxonomyTreeNode;
import cgdp.recog.taxonomy.TaxImporter;
import cgdp.recog.taxonomy.TaxonomyTreeNode;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FileImporter;
import cgdp.recog.util.StringTool;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class TaxFacade {
    public static List getTaxonomyTreeNodeList() throws IOException {
        return TaxFacade.getTaxonomyTreeNodeList(null);
    }

    public static List getTaxonomyTreeNodeList(String string) throws IOException {
        String string2;
        File file;
        FileImporter fileImporter = null;
        if (string != null && (file = new File(string2 = DataManager.getTaxonomyDat_DomClust(string))).exists()) {
            fileImporter = new TaxImporter(string2);
        }
        if (fileImporter == null) {
            fileImporter = new TaxImporter(DataManager.getTaxonomyDat());
        }
        fileImporter.execute();
        return ((TaxImporter)fileImporter).getNodeList();
    }

    public static List getDisplayTaxonomyTreeNodeList() throws IOException {
        List list = TaxFacade.getTaxonomyTreeNodeList();
        ArrayList<DisplayTaxonomyTreeNode> arrayList = new ArrayList<DisplayTaxonomyTreeNode>();
        for (TaxonomyTreeNode taxonomyTreeNode : list) {
            arrayList.add(new DisplayTaxonomyTreeNode(taxonomyTreeNode));
        }
        return arrayList;
    }

    public static TaxonomyTreeNode createTargetTaxonomyTree(List list, Collection collection) throws IOException {
        TaxonomyTreeNode taxonomyTreeNode = TaxFacade.createTaxonomyTree(list, collection);
        TaxFacade.filterRank(taxonomyTreeNode);
        return taxonomyTreeNode;
    }

    public static TaxonomyTreeNode createCompleteTaxonomyTree() throws IOException {
        List list = TaxFacade.getTaxonomyTreeNodeList();
        TaxonomyTreeNode taxonomyTreeNode = TaxFacade.createTaxonomyTree(list, null);
        return taxonomyTreeNode;
    }

    public static TaxonomyTreeNode createTaxonomyTree(List list, Collection collection) {
        TaxonomyTreeNode taxonomyTreeNode = null;
        block0: for (int i = 0; i < list.size(); ++i) {
            TaxonomyTreeNode taxonomyTreeNode2 = (TaxonomyTreeNode)list.get(i);
            if (!CollectionUtil.isNull(collection)) {
                Vector vector = StringTool.splitString(taxonomyTreeNode2.getAbbreviation());
                boolean bl = false;
                for (int j = 0; j < vector.size(); ++j) {
                    if (!collection.contains((String)vector.get(j))) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
            }
            if (taxonomyTreeNode2.getLevel() == 1) {
                taxonomyTreeNode = taxonomyTreeNode2;
                continue;
            }
            for (int j = i - 1; j >= 0; --j) {
                TaxonomyTreeNode taxonomyTreeNode3 = (TaxonomyTreeNode)list.get(j);
                if (j == i - 1 && taxonomyTreeNode3.getLevel() >= taxonomyTreeNode2.getLevel() && !taxonomyTreeNode3.isGenome()) {
                    taxonomyTreeNode3.add(taxonomyTreeNode2);
                    continue block0;
                }
                if (taxonomyTreeNode3.getLevel() >= taxonomyTreeNode2.getLevel() || !taxonomyTreeNode3.containsAbbr(taxonomyTreeNode2.getAbbreviation())) continue;
                taxonomyTreeNode3.add(taxonomyTreeNode2);
                continue block0;
            }
        }
        return taxonomyTreeNode;
    }

    static void filterNoBrother(TaxonomyTreeNode taxonomyTreeNode) {
        ArrayList arrayList = new ArrayList();
        TaxFacade.getLeafNodeList(taxonomyTreeNode, arrayList);
        HashMap hashMap = new HashMap();
        block0: for (TaxonomyTreeNode taxonomyTreeNode2 : arrayList) {
            boolean bl = true;
            while (true) {
                TaxonomyTreeNode taxonomyTreeNode3;
                if (bl) {
                    taxonomyTreeNode3 = TaxFacade.getNewParent((TaxonomyTreeNode)taxonomyTreeNode2.getParent());
                    bl = false;
                } else {
                    taxonomyTreeNode3 = (TaxonomyTreeNode)taxonomyTreeNode2.getParent();
                }
                ArrayList<TaxonomyTreeNode> arrayList2 = (ArrayList<TaxonomyTreeNode>)hashMap.get(taxonomyTreeNode3);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<TaxonomyTreeNode>();
                    hashMap.put(taxonomyTreeNode3, arrayList2);
                }
                boolean bl2 = false;
                for (TaxonomyTreeNode taxonomyTreeNode4 : arrayList2) {
                    if (!taxonomyTreeNode4.getName().equals(taxonomyTreeNode2.getName()) || !taxonomyTreeNode4.getAbbreviation().equals(taxonomyTreeNode2.getAbbreviation())) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    arrayList2.add(taxonomyTreeNode2);
                }
                if (taxonomyTreeNode3.getLevel() == 1) continue block0;
                taxonomyTreeNode2 = taxonomyTreeNode3;
            }
        }
        TaxFacade.createTaxonomyTree(taxonomyTreeNode, hashMap);
    }

    private static TaxonomyTreeNode getNewParent(TaxonomyTreeNode taxonomyTreeNode) {
        while (!taxonomyTreeNode.isRoot()) {
            TaxonomyTreeNode taxonomyTreeNode2 = (TaxonomyTreeNode)taxonomyTreeNode.getNextSibling();
            TaxonomyTreeNode taxonomyTreeNode3 = (TaxonomyTreeNode)taxonomyTreeNode.getPreviousSibling();
            if (taxonomyTreeNode2 != null || taxonomyTreeNode3 != null) {
                return taxonomyTreeNode;
            }
            taxonomyTreeNode = (TaxonomyTreeNode)taxonomyTreeNode.getParent();
        }
        return taxonomyTreeNode;
    }

    public static Map createRankNodeSetMap(List list) {
        HashMap<String, HashSet<TaxonomyTreeNode>> hashMap = new HashMap<String, HashSet<TaxonomyTreeNode>>();
        for (TaxonomyTreeNode taxonomyTreeNode : list) {
            String string = taxonomyTreeNode.getRank();
            HashSet<TaxonomyTreeNode> hashSet = (HashSet<TaxonomyTreeNode>)hashMap.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<TaxonomyTreeNode>();
                hashMap.put(string, hashSet);
            }
            hashSet.add(taxonomyTreeNode);
        }
        return hashMap;
    }

    public static List filterRank(List list) {
        ArrayList<TaxonomyTreeNode> arrayList = new ArrayList<TaxonomyTreeNode>();
        for (TaxonomyTreeNode taxonomyTreeNode : list) {
            if (!TaxFacade.isShowRank(taxonomyTreeNode)) continue;
            arrayList.add(taxonomyTreeNode);
        }
        return arrayList;
    }

    public static void filterRank(TaxonomyTreeNode taxonomyTreeNode) {
        ArrayList arrayList = new ArrayList();
        TaxFacade.getLeafNodeList(taxonomyTreeNode, arrayList);
        HashMap hashMap = new HashMap();
        block0: for (TaxonomyTreeNode taxonomyTreeNode2 : arrayList) {
            while (true) {
                TaxonomyTreeNode taxonomyTreeNode3;
                ArrayList<TaxonomyTreeNode> arrayList2;
                if ((arrayList2 = (ArrayList<TaxonomyTreeNode>)hashMap.get(taxonomyTreeNode3 = TaxFacade.getDisplayRankParentNode((TaxonomyTreeNode)taxonomyTreeNode2.getParent()))) == null) {
                    arrayList2 = new ArrayList<TaxonomyTreeNode>();
                    hashMap.put(taxonomyTreeNode3, arrayList2);
                }
                boolean bl = false;
                for (TaxonomyTreeNode taxonomyTreeNode4 : arrayList2) {
                    if (!taxonomyTreeNode4.getName().equals(taxonomyTreeNode2.getName()) || !taxonomyTreeNode4.getAbbreviation().equals(taxonomyTreeNode2.getAbbreviation())) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    arrayList2.add(taxonomyTreeNode2);
                }
                if (taxonomyTreeNode3.getLevel() == 1) continue block0;
                taxonomyTreeNode2 = taxonomyTreeNode3;
            }
        }
        TaxFacade.createTaxonomyTree(taxonomyTreeNode, hashMap);
    }

    public static void createTaxonomyTree(TaxonomyTreeNode taxonomyTreeNode, Map map) {
        taxonomyTreeNode.removeAllChildren();
        for (TaxonomyTreeNode taxonomyTreeNode2 : (ArrayList)map.get(taxonomyTreeNode)) {
            taxonomyTreeNode.add(taxonomyTreeNode2);
            if (map.get(taxonomyTreeNode2) == null) continue;
            TaxFacade.createTaxonomyTree(taxonomyTreeNode2, map);
        }
    }

    public static void getLeafNodeList(TaxonomyTreeNode taxonomyTreeNode, List list) {
        if (taxonomyTreeNode.isLeaf()) {
            list.add(taxonomyTreeNode);
        }
        int n = taxonomyTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            TaxonomyTreeNode taxonomyTreeNode2 = (TaxonomyTreeNode)taxonomyTreeNode.getChildAt(i);
            TaxFacade.getLeafNodeList(taxonomyTreeNode2, list);
        }
    }

    private static TaxonomyTreeNode getDisplayRankParentNode(TaxonomyTreeNode taxonomyTreeNode) {
        while (!TaxFacade.isShowRank(taxonomyTreeNode)) {
            taxonomyTreeNode = (TaxonomyTreeNode)taxonomyTreeNode.getParent();
        }
        return taxonomyTreeNode;
    }

    private static boolean isShowRank(TaxonomyTreeNode taxonomyTreeNode) {
        if (taxonomyTreeNode.getLevel() == 1) {
            return true;
        }
        if (RankDif.isGenome(taxonomyTreeNode.getRank())) {
            return true;
        }
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        for (int i = 0; i < RankDif.RANKS.length; ++i) {
            String string = RankDif.RANKS[i];
            if (!taxonomyTreeNode.equalsRank(string) || !optionValues.isSelectedRankForTaxTree(string)) continue;
            return true;
        }
        return false;
    }

    public static Set getRankNameSet(TaxonomyTreeNode taxonomyTreeNode) {
        HashSet<String> hashSet = new HashSet<String>();
        Enumeration<TreeNode> enumeration = taxonomyTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            TaxonomyTreeNode taxonomyTreeNode2 = (TaxonomyTreeNode)enumeration.nextElement();
            if (taxonomyTreeNode2.isLeaf()) {
                hashSet.add(taxonomyTreeNode2.getAbbreviation());
                continue;
            }
            hashSet.add(taxonomyTreeNode2.getName());
        }
        return hashSet;
    }

    public static Map getRankNodeMap(TaxonomyTreeNode taxonomyTreeNode) {
        HashMap<String, HashSet<TaxonomyTreeNode>> hashMap = new HashMap<String, HashSet<TaxonomyTreeNode>>();
        Enumeration<TreeNode> enumeration = taxonomyTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            TaxonomyTreeNode taxonomyTreeNode2 = (TaxonomyTreeNode)enumeration.nextElement();
            String string = taxonomyTreeNode2.getRank();
            HashSet<TaxonomyTreeNode> hashSet = (HashSet<TaxonomyTreeNode>)hashMap.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<TaxonomyTreeNode>();
                hashMap.put(string, hashSet);
            }
            hashSet.add(taxonomyTreeNode2);
        }
        return hashMap;
    }
}

