/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.taxonomy.TaxSearchCondition;
import cgdp.recog.taxonomy.TaxonomyTreeNode;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.TreeNode;

public class TaxTreeSearchExecuter
extends AbstractThreadProcess {
    private MediatorImpl mediator;
    private Component parent;
    private TaxSearchCondition condition;
    private TaxonomyTreeNode rootNode;
    private Set resultNodeSet = new HashSet();

    public TaxTreeSearchExecuter(MediatorImpl mediatorImpl, Component component, TaxSearchCondition taxSearchCondition, TaxonomyTreeNode taxonomyTreeNode) {
        this.mediator = mediatorImpl;
        this.condition = taxSearchCondition;
        this.rootNode = taxonomyTreeNode;
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        HashSet<TaxonomyTreeNode> hashSet = new HashSet<TaxonomyTreeNode>();
        int n = 0;
        Enumeration<TreeNode> enumeration = this.rootNode.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            TaxonomyTreeNode taxonomyTreeNode = (TaxonomyTreeNode)enumeration.nextElement();
            if (this.condition.isOrganismCode() && !taxonomyTreeNode.isGenome()) continue;
            String string = this.condition.isOrganismCode() ? taxonomyTreeNode.getAbbreviation() : taxonomyTreeNode.getName();
            if (this.isMatch(string)) {
                hashSet.add(taxonomyTreeNode);
            }
            if (this.condition.isResultFirst() && !hashSet.isEmpty()) break;
            ++n;
        }
        this.resultNodeSet = hashSet;
    }

    private boolean isMatch(String string) {
        String string2 = string.toLowerCase();
        Iterator iterator = this.condition.getKeywordSet().iterator();
        while (iterator.hasNext()) {
            Matcher matcher;
            String string3 = null;
            Pattern pattern = null;
            if (this.condition.isEqualTypeRegexp()) {
                pattern = (Pattern)iterator.next();
            } else {
                string3 = ((String)iterator.next()).toLowerCase();
            }
            if (!(this.condition.isEqualTypeEqual() ? string2.equals(string3) : (this.condition.isEqualTypeFirst() ? string2.startsWith(string3.toLowerCase()) : this.condition.isEqualTypeRegexp() && (matcher = pattern.matcher(string2)).find()))) continue;
            return true;
        }
        return false;
    }

    public Set getResultNodeSet() {
        return this.resultNodeSet;
    }

    @Override
    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
            return;
        }
        if (this.resultNodeSet.isEmpty()) {
            return;
        }
        this.mediator.selectTaxonomyTreePathBoth(this.resultNodeSet);
    }
}

