/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.color.geneinfo.GeneColorPopupItem;
import cgdp.recog.data.Chromosome;
import cgdp.recog.data.ChromosomeTbl;
import cgdp.recog.data.ChromosomeTypeComparator;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.SpGroupTbl;
import cgdp.recog.filter.FilterMenuFactory;
import cgdp.recog.gmap.GenomeMapItem;
import cgdp.recog.histogram.HistogramPopupItem;
import cgdp.recog.mapping.MapMenu;
import cgdp.recog.menu.GeneFrameItem;
import cgdp.recog.neighbor.NeighborClustItem;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.organism.MergeOrganismReleaseItem;
import cgdp.recog.organism.ModifiedOrganismManager;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismMergeItem;
import cgdp.recog.organism.OrganismSetMenu;
import cgdp.recog.organism.OrganismSplitItem;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.organism.SplitOrganismReleaseItem;
import cgdp.recog.pattern.PatternRegisterItem;
import cgdp.recog.pattern.PatternUtil;
import cgdp.recog.ppm.OrganismColumnAddItem;
import cgdp.recog.sort.SortMenuFactory;
import cgdp.recog.spgroup.NewSpGroupItem;
import cgdp.recog.spgroup.SpGroup;
import cgdp.recog.spgroup.SpGroupAddItem;
import cgdp.recog.system.OS;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.taxonomy.OrganismColorMenu;
import cgdp.recog.taxonomy.TaxonomyTree;
import cgdp.recog.taxonomy.TaxonomyTreeNode;
import cgdp.recog.taxonomy.map.TaxMapExecutePopupItem;
import cgdp.recog.taxonomy.map.TaxMapFacade;
import cgdp.recog.taxonomy.map.TaxMapItem;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.StringTool;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

public class TaxonomyTreeEx
extends TaxonomyTree {
    private static final ApplicationLogger logger = new ApplicationLogger(TaxonomyTreeEx.class);

    public TaxonomyTreeEx(MediatorImpl mediatorImpl) throws Exception {
        super(mediatorImpl);
        this.enableShowModifiedOrganism = true;
    }

    private void showPopup(String string, Set set, Point point) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        Map map = OrganismUtil.createOrganismNameMap(set);
        this.createTaxonomyMenu(string, set, map, jPopupMenu);
        JMenu jMenu = new JMenu("Sp Group");
        jPopupMenu.add(jMenu);
        jMenu.add(new NewSpGroupItem(this, this.m_mediatorImpl, string, map));
        SpGroupTbl spGroupTbl = SpGroupTbl.getInstance();
        JMenu jMenu2 = new JMenu("Add Sp Group");
        jMenu2.setEnabled(spGroupTbl.getSpGroups().isExistSpGroup());
        jMenu.add(jMenu2);
        for (SpGroup spGroup : spGroupTbl.getSpGroups().getSpGroupList()) {
            SpGroupAddItem spGroupAddItem = new SpGroupAddItem(this, this.m_mediatorImpl, map, spGroup);
            jMenu2.add(spGroupAddItem);
        }
        jPopupMenu.addSeparator();
        TaxonomyTreeEx.showOrganismMenus((ActionListener)this, this.m_mediatorImpl, this.m_clusterTbl, jPopupMenu, map.keySet());
        jPopupMenu.show(this, point.x, point.y);
    }

    private void createTaxonomyMenu(String string, Set set, Map map, JPopupMenu jPopupMenu) {
        FilterMenuFactory.createTaxonomyMenu(this, this.m_mediatorImpl, this.m_clusterTbl, string, set, map, jPopupMenu);
    }

    public static void showOrganismMenus(ActionListener actionListener, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, JPopupMenu jPopupMenu, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        Map map = OrganismUtil.createOrganismNameMap(hashSet);
        String string2 = (String)map.get(string);
        FilterMenuFactory.createTaxonomyMenu(actionListener, mediatorImpl, clusterTbl, string2, hashSet, map, jPopupMenu);
        jPopupMenu.addSeparator();
        TaxonomyTreeEx.showOrganismMenus(actionListener, mediatorImpl, clusterTbl, jPopupMenu, hashSet);
    }

    public static void showOrganismMenus(ActionListener actionListener, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, JPopupMenu jPopupMenu, Set set) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        AbstractCollection abstractCollection;
        JMenu jMenu;
        Object object5;
        if (set.isEmpty()) {
            return;
        }
        if (clusterTbl == null) {
            return;
        }
        String string = (String)set.iterator().next();
        if (StringTool.isNull(string)) {
            return;
        }
        try {
            object5 = new ChromosomeTbl(string);
            ((ChromosomeTbl)object5).read();
            jMenu = new JMenu("Genome Map");
            jPopupMenu.add(jMenu);
            abstractCollection = new ArrayList(((TreeMap)object5).values());
            Collections.sort(abstractCollection, new ChromosomeTypeComparator());
            object4 = ModifiedOrganismManager.getInstance().getMergeOrganism(string);
            object3 = abstractCollection.iterator();
            while (object3.hasNext()) {
                object2 = (Chromosome)object3.next();
                if (object4 != null) {
                    object = clusterTbl.getOrganism(((Chromosome)object2).getOrganismCode());
                    jMenu.add(new GenomeMapItem(actionListener, mediatorImpl, string, (Chromosome)object2, ((Chromosome)object2).getDisplayName() + "(" + ((Organism)object).getNameForTaxonomy() + ")"));
                    continue;
                }
                jMenu.add(new GenomeMapItem(actionListener, mediatorImpl, string, (Chromosome)object2, ((Chromosome)object2).getDisplayName()));
            }
            ((TreeMap)object5).clear();
            object5 = null;
        }
        catch (Exception exception) {
            logger.warn("Fail to load the chromosome file.", exception);
        }
        jPopupMenu.add(new GeneFrameItem(actionListener, mediatorImpl, string));
        object5 = OptionTbl.getInstance();
        if (((OptionTbl)object5).getOptionValues().isIntensive()) {
            jPopupMenu.addSeparator();
            jMenu = SortMenuFactory.createSortMenuForAggregate(actionListener, mediatorImpl, null, clusterTbl.getViewOrganismCodeList());
            jPopupMenu.add(jMenu);
        } else {
            jMenu = SortMenuFactory.createSortMenuForDisaggregate(actionListener, mediatorImpl, clusterTbl, null, string);
            jPopupMenu.add(jMenu);
        }
        jPopupMenu.add(new NeighborClustItem(actionListener, mediatorImpl, true));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new OrganismColumnAddItem(actionListener, mediatorImpl, set));
        jPopupMenu.add(new OrganismColorMenu(actionListener, mediatorImpl, set));
        jPopupMenu.add(new OrganismSetMenu(actionListener, mediatorImpl, set));
        boolean bl = false;
        abstractCollection = new HashSet(clusterTbl.getOrganismList(set));
        object4 = OrganismUtil.getEnableMergeOrganismList(abstractCollection);
        if (object4.size() >= 2) {
            if (!bl) {
                jPopupMenu.addSeparator();
                bl = true;
            }
            jPopupMenu.add(new OrganismMergeItem(actionListener, mediatorImpl, (Collection)object4));
        }
        if ((object3 = OrganismUtil.getEnableSplitOrganismList(abstractCollection)).size() == 1) {
            if (!bl) {
                jPopupMenu.addSeparator();
                bl = true;
            }
            jPopupMenu.add(new OrganismSplitItem(actionListener, mediatorImpl, string));
        }
        if (!CollectionUtil.isNull((Collection)(object2 = OrganismUtil.extractMergeOrganismList(abstractCollection)))) {
            if (!bl) {
                jPopupMenu.addSeparator();
                bl = true;
            }
            jPopupMenu.add(new MergeOrganismReleaseItem(actionListener, mediatorImpl, (Collection)object2));
        }
        if (!CollectionUtil.isNull((Collection)(object = OrganismUtil.extractSplitOrganismList(abstractCollection)))) {
            if (!bl) {
                jPopupMenu.addSeparator();
                bl = true;
            }
            jPopupMenu.add(new SplitOrganismReleaseItem(actionListener, mediatorImpl, (Collection)object));
        }
        jPopupMenu.addSeparator();
        jPopupMenu.add(new PatternRegisterItem(actionListener, mediatorImpl, PatternUtil.createPattern(set, clusterTbl)));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new GeneColorPopupItem(actionListener, mediatorImpl, set));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new HistogramPopupItem(actionListener, mediatorImpl, string, clusterTbl.getHistogramCondition()));
        Set set2 = TaxMapFacade.getMappingOrganismCodeSet(clusterTbl.getClusterId());
        List list = ModifiedOrganismManager.getInstance().convertSystemOrganismCodeList(set);
        set2.retainAll(list);
        if (!CollectionUtil.isNull(set2)) {
            jPopupMenu.addSeparator();
            jPopupMenu.add(new TaxMapItem(actionListener, mediatorImpl, set2));
            jPopupMenu.add(new TaxMapExecutePopupItem(actionListener, mediatorImpl, set));
        } else {
            jPopupMenu.addSeparator();
            jPopupMenu.add(new TaxMapExecutePopupItem(actionListener, mediatorImpl, set));
        }
        if (ApplicationPropertyFacade.isIncompleteOrganismCode(string)) {
            jPopupMenu.addSeparator();
            jPopupMenu.add(new MapMenu(actionListener, mediatorImpl, string));
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!OS.isWindows()) {
            this.controlMouseForShowPopup(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (OS.isWindows()) {
            this.controlMouseForShowPopup(mouseEvent);
        }
        this.selectOrganism();
    }

    private void controlMouseForShowPopup(MouseEvent mouseEvent) {
        if (!this.isEnabledMouseAction()) {
            return;
        }
        TreePath[] treePathArray = this.getSelectionPaths();
        if (mouseEvent.isPopupTrigger()) {
            int n;
            TreePath treePath = treePathArray[0];
            if (treePathArray.length > 1 && this.isRowSelected(n = this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()))) {
                treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            }
            Map map = this.createSelectedOrganismMap();
            TaxonomyTreeNode taxonomyTreeNode = (TaxonomyTreeNode)treePath.getLastPathComponent();
            String string = TaxonomyTreeEx.createNameForSelectedNode(taxonomyTreeNode, map);
            this.showPopup(string, map.keySet(), mouseEvent.getPoint());
            return;
        }
    }

    private void selectOrganism() {
        if (!this.isEnabledMouseAction()) {
            return;
        }
        Map map = this.createSelectedOrganismMap();
        this.setSelectChileNode();
        this.m_mediatorImpl.selectOrganismOnTaxonomyTree(map.keySet());
        this.m_mediatorImpl.setSelectedOrganism(map.keySet(), this);
    }

    private boolean isEnabledMouseAction() {
        TaxonomyTreeNode taxonomyTreeNode;
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null) {
            this.m_mediatorImpl.setSelectedOrganism(new HashSet(), this);
            return false;
        }
        return treePathArray.length != 1 || !(taxonomyTreeNode = (TaxonomyTreeNode)treePathArray[0].getLastPathComponent()).getName().equals("No Data");
    }

    public static String createNameForSelectedNode(TaxonomyTreeNode taxonomyTreeNode, Map map) {
        Object object2;
        Cloneable cloneable;
        Set set = map.keySet();
        HashSet hashSet = new HashSet(StringTool.splitString(taxonomyTreeNode.getAbbreviation(), ","));
        if (hashSet.containsAll(set)) {
            return taxonomyTreeNode.getName();
        }
        hashSet.retainAll(set);
        HashMap<Cloneable, Integer> hashMap = new HashMap<Cloneable, Integer>();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            cloneable = (TaxonomyTreeNode)((TaxonomyTreeNode)iterator.next()).getParent();
            int n = 0;
            if (hashMap.containsKey(cloneable)) {
                n = (Integer)hashMap.get(cloneable);
            }
            hashMap.put(cloneable, new Integer(++n));
        }
        int n = 0;
        cloneable = new ArrayList();
        if (!taxonomyTreeNode.isLeaf()) {
            n = hashSet.size();
            cloneable.add(taxonomyTreeNode);
        }
        for (Object object2 : hashMap.keySet()) {
            int n2 = (Integer)hashMap.get(object2);
            if (n2 > n) {
                cloneable.clear();
                cloneable.add(object2);
                n = n2;
                continue;
            }
            if (n2 != n) continue;
            cloneable.add(object2);
        }
        ArrayList arrayList = new ArrayList();
        object2 = cloneable.iterator();
        while (object2.hasNext()) {
            TaxonomyTreeNode taxonomyTreeNode2 = (TaxonomyTreeNode)object2.next();
            arrayList.add(taxonomyTreeNode2.getName());
        }
        return (String)Collections.min(arrayList);
    }
}

