/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy;

import cgdp.recog.data.RankComparator;
import cgdp.recog.data.RankDif;
import cgdp.recog.util.StringTool;
import java.util.HashSet;
import javax.swing.tree.DefaultMutableTreeNode;

public class TaxonomyTreeNode
extends DefaultMutableTreeNode {
    private static final String DELIMITER_ABBR = ",";
    private String name;
    private int level;
    private String abbreviation;
    private String rank;
    private int no1;
    private int no2;
    private long specWeight = 0L;

    public TaxonomyTreeNode(int n, String string, String string2, String string3, int n2, int n3, long l) {
        super(string, true);
        this.name = string;
        this.level = n;
        this.abbreviation = string2;
        this.rank = string3;
        this.no1 = n2;
        this.no2 = n3;
        this.specWeight = l;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String string) {
        this.abbreviation = string;
    }

    public String getRank() {
        return this.rank;
    }

    public int getNo1() {
        return this.no1;
    }

    public int getNo2() {
        return this.no2;
    }

    public long getSpecWeight() {
        return this.specWeight;
    }

    public void setSpecWeight(long l) {
        this.specWeight = l;
    }

    public boolean isSuperKingdom() {
        return RankDif.isSuperkingdom(this.getRank());
    }

    public boolean isNoRank() {
        return this.level > 2 && RankDif.isNoRank(this.getRank());
    }

    public boolean isKingdom() {
        return RankDif.isKingdom(this.getRank());
    }

    public boolean isSuperPhylum() {
        return RankDif.isSuperphylum(this.getRank());
    }

    public boolean isPhylum() {
        return RankDif.isPhylum(this.getRank());
    }

    public boolean isSubPhylum() {
        return RankDif.isSubphylum(this.getRank());
    }

    public boolean isClass() {
        return RankDif.isClass(this.getRank());
    }

    public boolean isSubClass() {
        return RankDif.isSubclass(this.getRank());
    }

    public boolean isOrder() {
        return RankDif.isOrder(this.getRank());
    }

    public boolean isSubOrder() {
        return RankDif.isSuborder(this.getRank());
    }

    public boolean isFamily() {
        return RankDif.isFamily(this.getRank());
    }

    public boolean isTribe() {
        return RankDif.isTribe(this.getRank());
    }

    public boolean isGenus() {
        return RankDif.isGenus(this.getRank());
    }

    public boolean isSpeciesGroup() {
        return RankDif.isSpeciesGroup(this.getRank());
    }

    public boolean isSpecies() {
        return RankDif.isSpecies(this.getRank());
    }

    public boolean isGenome() {
        return RankDif.isGenome(this.getRank());
    }

    public boolean equalsRank(String string) {
        return this.getRank().equals(string);
    }

    public boolean equalsNode(TaxonomyTreeNode taxonomyTreeNode) {
        if (taxonomyTreeNode == null) {
            return false;
        }
        return taxonomyTreeNode.getName().equals(this.getName()) && this.equalsRank(taxonomyTreeNode.getRank()) && taxonomyTreeNode.getAbbreviation().equals(this.getAbbreviation());
    }

    public boolean isMinRank(String string) {
        return RankComparator.compareRank(string, this.getRank()) < 0;
    }

    public boolean containsAbbr(String string) {
        HashSet hashSet = new HashSet(StringTool.splitString(this.getAbbreviation(), DELIMITER_ABBR));
        HashSet hashSet2 = new HashSet(StringTool.splitString(string, DELIMITER_ABBR));
        return hashSet.containsAll(hashSet2);
    }

    public TaxonomyTreeNode getParentNode(String string) {
        TaxonomyTreeNode taxonomyTreeNode = (TaxonomyTreeNode)this.getParent();
        for (taxonomyTreeNode = this; taxonomyTreeNode != null && !taxonomyTreeNode.getRank().equals(string); taxonomyTreeNode = (TaxonomyTreeNode)taxonomyTreeNode.getParent()) {
        }
        return taxonomyTreeNode;
    }
}

