/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.process.ProgressImpl;
import cgdp.recog.taxonomy.TaxFacade;
import cgdp.recog.taxonomy.TaxonomyTreeNode;
import cgdp.recog.taxonomy.map.AbstractRankScoreCalculater;
import cgdp.recog.taxonomy.map.TaxMapFacade;
import cgdp.recog.taxonomy.map.TaxMapInfo;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.util.StringTool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

class RankAddScoreCalculater
extends AbstractRankScoreCalculater {
    private int geneScoreMode;
    private boolean calcForwardChild = false;
    private boolean calcForwardParent = true;

    RankAddScoreCalculater(List list, TaxMapModel taxMapModel, int n) {
        super(list, taxMapModel);
        this.geneScoreMode = n;
    }

    @Override
    public void execute(ProgressImpl progressImpl) throws Exception {
        List list = this.getTaxMapInfoListByAggregateType();
        Map map = this.createRankTaxMapInfoMapForCompleteTree(list);
        List list2 = TaxFacade.getDisplayTaxonomyTreeNodeList();
        TaxonomyTreeNode taxonomyTreeNode = TaxFacade.createTaxonomyTree(list2, this.taxMapModel.getTreeOrganismCodeSet());
        Map map2 = TaxMapFacade.createTaxonomyTreeNodeMap(taxonomyTreeNode);
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        HashMap hashMap4 = new HashMap();
        for (String string : map.keySet()) {
            Object object;
            Object object2;
            if (TaxMapModel.isNoHitsCode(string)) continue;
            List list3 = (List)map.get(string);
            double d = RankAddScoreCalculater.calcScore(this.taxMapModel, list3);
            RankAddScoreCalculater.updateScore(string, d, hashMap);
            RankAddScoreCalculater.updateRankTaxMapInfoMap(string, list3, hashMap4);
            TaxonomyTreeNode taxonomyTreeNode2 = (TaxonomyTreeNode)map2.get(string);
            if (this.isCalcForwardParent()) {
                for (object2 = (TaxonomyTreeNode)taxonomyTreeNode2.getParent(); object2 != null; object2 = (TaxonomyTreeNode)((DefaultMutableTreeNode)object2).getParent()) {
                    object = TaxMapModel.getKeyName((TaxonomyTreeNode)object2);
                    RankAddScoreCalculater.updateScore((String)object, d, hashMap3);
                    RankAddScoreCalculater.updateRankTaxMapInfoMap((String)object, list3, hashMap4);
                }
            }
            if (!this.isCalcForwardChild()) continue;
            this.updateChildScoreParRank(taxonomyTreeNode2, d, hashMap2);
            object2 = taxonomyTreeNode2.children();
            while (object2.hasMoreElements()) {
                object = (TaxonomyTreeNode)object2.nextElement();
                RankAddScoreCalculater.updateChildRankTaxMapInfoMap((TaxonomyTreeNode)object, list3, hashMap4);
            }
        }
        this.setRankTaxMapInfoMap(hashMap4);
        this.setRankScoreMap(hashMap);
        this.setParentRankScoreMap(hashMap2);
        this.setChildRankScoreMap(hashMap3);
    }

    private int getGeneScoreMode() {
        return this.geneScoreMode;
    }

    private boolean isModeScoreLower() {
        return TaxMapModel.isModeScoreLower(this.getGeneScoreMode());
    }

    private boolean isModeScoreUpper() {
        return TaxMapModel.isModeScoreUpper(this.getGeneScoreMode());
    }

    private String getTaxMapInfoName(TaxMapInfo taxMapInfo) {
        String string;
        if (this.isModeScoreUpper()) {
            string = taxMapInfo.getUpperName();
            if (StringTool.isNull(string)) {
                string = "root";
            }
        } else {
            string = taxMapInfo.getLowerName();
        }
        return string;
    }

    private Map createRankTaxMapInfoMapForCompleteTree(List list) throws IOException {
        List list2 = TaxFacade.getDisplayTaxonomyTreeNodeList();
        HashMap<String, TaxonomyTreeNode> hashMap = new HashMap<String, TaxonomyTreeNode>();
        for (Object object : list2) {
            Object object2 = TaxMapModel.getKeyName((TaxonomyTreeNode)object);
            hashMap.put((String)object2, (TaxonomyTreeNode)object);
        }
        TaxFacade.createTaxonomyTree(list2, null);
        HashMap hashMap2 = new HashMap();
        for (Object object2 : list) {
            TaxonomyTreeNode taxonomyTreeNode = (TaxonomyTreeNode)hashMap.get(this.getTaxMapInfoName((TaxMapInfo)object2));
            String string = TaxMapModel.getKeyName(taxonomyTreeNode);
            ArrayList<Object> arrayList = (ArrayList<Object>)hashMap2.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
                hashMap2.put(string, arrayList);
            }
            arrayList.add(object2);
        }
        return hashMap2;
    }

    private void updateChildScoreParRank(TaxonomyTreeNode taxonomyTreeNode, double d, Map map) {
        if (taxonomyTreeNode.isLeaf()) {
            return;
        }
        Map map2 = TaxFacade.getRankNodeMap(taxonomyTreeNode);
        for (String string : map2.keySet()) {
            Set set = (Set)map2.get(string);
            double d2 = d / (double)set.size();
            for (TaxonomyTreeNode taxonomyTreeNode2 : set) {
                String string2 = TaxMapModel.getKeyName(taxonomyTreeNode2);
                RankAddScoreCalculater.updateScore(string2, d2, map);
            }
        }
    }

    private void updateChildScoreParBranch(TaxonomyTreeNode taxonomyTreeNode, double d, Map map) {
        double d2 = d / (double)taxonomyTreeNode.getChildCount();
        Enumeration<TreeNode> enumeration = taxonomyTreeNode.children();
        while (enumeration.hasMoreElements()) {
            TaxonomyTreeNode taxonomyTreeNode2 = (TaxonomyTreeNode)enumeration.nextElement();
            RankAddScoreCalculater.updateChildScore(taxonomyTreeNode2, d2, map);
        }
    }

    private static void updateChildScore(TaxonomyTreeNode taxonomyTreeNode, double d, Map map) {
        String string = TaxMapModel.getKeyName(taxonomyTreeNode);
        RankAddScoreCalculater.updateScore(string, d, map);
        if (taxonomyTreeNode.isLeaf()) {
            return;
        }
        double d2 = d / (double)taxonomyTreeNode.getChildCount();
        Enumeration<TreeNode> enumeration = taxonomyTreeNode.children();
        while (enumeration.hasMoreElements()) {
            TaxonomyTreeNode taxonomyTreeNode2 = (TaxonomyTreeNode)enumeration.nextElement();
            RankAddScoreCalculater.updateChildScore(taxonomyTreeNode2, d2, map);
        }
    }

    private static void updateScore(String string, double d, Map map) {
        Double d2 = (Double)map.get(string);
        double d3 = 0.0;
        if (d2 != null) {
            d3 = d2;
        }
        map.put(string, new Double(d3 += d));
    }

    private static void updateRankTaxMapInfoMap(String string, List list, Map map) {
        ArrayList<TaxMapInfo> arrayList = (ArrayList<TaxMapInfo>)map.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<TaxMapInfo>();
            map.put(string, arrayList);
        }
        HashSet<TaxMapInfo> hashSet = new HashSet<TaxMapInfo>(arrayList);
        for (TaxMapInfo taxMapInfo : list) {
            if (hashSet.contains(taxMapInfo)) continue;
            arrayList.add(taxMapInfo);
            hashSet.add(taxMapInfo);
        }
    }

    private static void updateChildRankTaxMapInfoMap(TaxonomyTreeNode taxonomyTreeNode, List list, Map map) {
        String string = TaxMapModel.getKeyName(taxonomyTreeNode);
        RankAddScoreCalculater.updateRankTaxMapInfoMap(string, list, map);
        if (taxonomyTreeNode.isLeaf()) {
            return;
        }
        Enumeration<TreeNode> enumeration = taxonomyTreeNode.children();
        while (enumeration.hasMoreElements()) {
            TaxonomyTreeNode taxonomyTreeNode2 = (TaxonomyTreeNode)enumeration.nextElement();
            RankAddScoreCalculater.updateChildRankTaxMapInfoMap(taxonomyTreeNode2, list, map);
        }
    }

    public void setCalcForwardChild(boolean bl) {
        this.calcForwardChild = bl;
    }

    public boolean isCalcForwardChild() {
        return this.calcForwardChild;
    }

    public void setCalcForwardParent(boolean bl) {
        this.calcForwardParent = bl;
    }

    public boolean isCalcForwardParent() {
        return this.calcForwardParent;
    }
}

