/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.domclust.DomClustCondition;
import cgdp.recog.domclust.DomClustExecuter;
import cgdp.recog.domclust.DomClustQuery;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.server.AccessServer;
import cgdp.recog.taxonomy.map.TaxMapFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;

public class TaxMapExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(TaxMapExecuter.class);
    private Component parent;
    private MediatorImpl mediator;
    private String domClustId;
    private Set taxMapOrganismCodeSet = new HashSet();
    private boolean existResult = false;

    public TaxMapExecuter(Component component, MediatorImpl mediatorImpl, String string, Set set) {
        this.parent = component;
        this.mediator = mediatorImpl;
        this.domClustId = string;
        this.taxMapOrganismCodeSet = set;
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        try {
            DomClustCondition domClustCondition = new DomClustCondition();
            domClustCondition.setDomClustId(this.domClustId);
            domClustCondition.setTaxMapOrganismCodeSet(this.taxMapOrganismCodeSet);
            String string = DomClustQuery.getTaxMapQueryOption(domClustCondition);
            DomClustExecuter domClustExecuter = new DomClustExecuter(domClustCondition, progressImpl, string);
            domClustExecuter.setOutputFile(false);
            domClustExecuter.execute();
            if (domClustExecuter.isCanceled()) {
                this.setCancel(true);
                return;
            }
            if (domClustExecuter.isError()) {
                this.setError(true);
                this.setErrorMessage("Fail to execute the taxonomy mapping.");
                return;
            }
            this.existResult = TaxMapFacade.downloadTaxMapInfo(this.domClustId, domClustCondition.getTaxMapOrganismCodeSet(), true);
        }
        catch (Exception exception) {
            String string = "Fail to execute taxonomy mapping process." + this.domClustId + " " + StringTool.conbineStrList(this.taxMapOrganismCodeSet);
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    @Override
    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
            return;
        }
        if (!this.existResult) {
            MessageManager.showMessage(this.parent, "There is no mapping genes.");
            return;
        }
        this.mediator.showTaxMapDialog(this.taxMapOrganismCodeSet);
    }

    public static void main(String[] stringArray) {
        try {
            AccessServer.getInstance().setServerUrl("http://alt.nibb.ac.jp:8043");
            Project project = ProjectAccesser.getProject("Metagenome");
            ProjectAccesser.updateSelectProject(project);
            String string = "1261388220_26978";
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("OP1");
            DomClustCondition domClustCondition = new DomClustCondition();
            domClustCondition.setDomClustId(string);
            domClustCondition.setTaxMapOrganismCodeSet(hashSet);
            String string2 = DomClustQuery.getTaxMapQueryOption(domClustCondition);
            DomClustExecuter domClustExecuter = new DomClustExecuter(domClustCondition, (ProgressImpl)new DummyProgressComponent(), string2);
            domClustExecuter.setOutputFile(false);
            domClustExecuter.execute();
            TaxMapFacade.downloadTaxMapInfo(string, domClustCondition.getTaxMapOrganismCodeSet(), true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

