/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.color.geneinfo.GeneColorCondition;
import cgdp.recog.color.geneinfo.GeneColorConditionFactory;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.domclust.AbstractDomClustImporter;
import cgdp.recog.domclust.DomClustListImporter;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.cell.CellInfo;
import cgdp.recog.info.cell.CellInfoFacade;
import cgdp.recog.info.cell.CellInfoTitle;
import cgdp.recog.info.cell.CellInfoUtil;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.taxonomy.map.RankAddScoreCalculater;
import cgdp.recog.taxonomy.map.TaxMapFacade;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.taxonomy.map.TaxMapUtil;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TaxMapGenomeScoreCalculater
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(TaxMapGenomeScoreCalculater.class);
    private Component parent;
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private String domClustId;
    private Set mappingOrganismCodeSet = new HashSet();
    private Set targetOrganismCodeSet = new HashSet();
    private List clusterList;
    private CellInfoTitle cellInfoTitle;
    private Map scoreMap = new HashMap();

    public TaxMapGenomeScoreCalculater(Component component, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, String string, Set set, Set set2, CellInfoTitle cellInfoTitle, List list) {
        this.parent = component;
        this.mediator = mediatorImpl;
        this.clusterTbl = clusterTbl;
        this.domClustId = string;
        this.mappingOrganismCodeSet = set;
        this.targetOrganismCodeSet = set2;
        this.clusterList = list;
        this.cellInfoTitle = cellInfoTitle;
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        try {
            progressImpl.setTotal(this.clusterList.size());
            List list = TaxMapFacade.getTaxMapInfoList(this.domClustId, this.mappingOrganismCodeSet, true);
            TaxMapModel taxMapModel = this.createTaxMapModel();
            Map map = TaxMapUtil.createClusterIdTaxMapInfoListMap(list, this.clusterTbl);
            double d = this.getMaxScore();
            Iterator iterator = this.clusterList.iterator();
            while (iterator.hasNext()) {
                if (progressImpl.isCanceled()) {
                    this.setCancel(true);
                    return;
                }
                progressImpl.increment();
                Cluster cluster = (Cluster)iterator.next();
                String string = CellInfoUtil.getClusterInfoKey(cluster, this.cellInfoTitle.getInfoType());
                List list2 = (List)map.get(string);
                if (CollectionUtil.isNull(list2)) continue;
                try {
                    RankAddScoreCalculater rankAddScoreCalculater = this.createRankAddScoreCalculater(taxMapModel, list2);
                    rankAddScoreCalculater.execute(progressImpl);
                    Map map2 = rankAddScoreCalculater.getParentRankScoreMap();
                    Map map3 = rankAddScoreCalculater.getRankScoreMap();
                    Set set = taxMapModel.getTreeOrganismCodeSet();
                    for (String string2 : set) {
                        Double d2;
                        if (!cluster.containsSp(string2) || this.mappingOrganismCodeSet.contains(string2)) continue;
                        double d3 = 0.0;
                        boolean bl = false;
                        Double d4 = (Double)map2.get(string2);
                        if (d4 != null) {
                            d3 += d4.doubleValue();
                            bl = true;
                        }
                        if ((d2 = (Double)map3.get(string2)) != null) {
                            d3 += d2.doubleValue();
                            bl = true;
                        }
                        if (!bl) continue;
                        HashMap<String, CellInfo> hashMap = (HashMap<String, CellInfo>)this.scoreMap.get(string);
                        if (hashMap == null) {
                            hashMap = new HashMap<String, CellInfo>();
                            this.scoreMap.put(string, hashMap);
                        }
                        double d5 = this.getMaxScoreByCluster(cluster);
                        d3 = d3 * d / d5;
                        CellInfo cellInfo = new CellInfo();
                        cellInfo.putInfo(this.cellInfoTitle, new Float(d3));
                        hashMap.put(string2, cellInfo);
                    }
                }
                catch (Exception exception) {
                    logger.warn("Fail to calculate the score with the taxonomy mapping results. Cluster ID:" + string, exception);
                }
            }
        }
        catch (IOException iOException) {
            String string = "Fail to calculate the score with the taxonomy mapping results.";
            logger.warn(string, iOException);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    private int getMaxScore() {
        int n = 0;
        for (Cluster cluster : this.clusterList) {
            n = Math.max(n, this.getMaxScoreByCluster(cluster));
        }
        return n;
    }

    private int getMaxScoreByCluster(Cluster cluster) {
        int n = 0;
        for (String string : this.mappingOrganismCodeSet) {
            n += cluster.getGeneCount(string);
        }
        return n;
    }

    @Override
    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
        }
        CellInfoFacade.removeCachedInfo(this.cellInfoTitle);
        CellInfoFacade.addCellInfo(this.getScoreMap(), this.cellInfoTitle);
        if (this.mediator != null) {
            HashSet hashSet = new HashSet(this.mappingOrganismCodeSet);
            hashSet.addAll(this.targetOrganismCodeSet);
            GeneColorCondition geneColorCondition = GeneColorConditionFactory.createGeneColorCondition(hashSet, (AbstractInfoTitle)this.cellInfoTitle, 2, 0.0, (double)this.getMaxScore());
            this.mediator.showGeneInfoColorDialog(this.parent, hashSet, geneColorCondition);
        }
    }

    private RankAddScoreCalculater createRankAddScoreCalculater(TaxMapModel taxMapModel, List list) {
        RankAddScoreCalculater rankAddScoreCalculater = new RankAddScoreCalculater(list, taxMapModel, taxMapModel.getGeneScoreMode());
        rankAddScoreCalculater.setCalcForwardChild(true);
        rankAddScoreCalculater.setCalcForwardParent(false);
        return rankAddScoreCalculater;
    }

    private TaxMapModel createTaxMapModel() {
        TaxMapModel taxMapModel = new TaxMapModel();
        taxMapModel.setMappingOrganismCodeSet(this.mappingOrganismCodeSet);
        taxMapModel.setTreeOrganismCodeSet(this.targetOrganismCodeSet);
        return taxMapModel;
    }

    public Map getScoreMap() {
        return this.scoreMap;
    }

    public static void main(String[] stringArray) {
        try {
            String string = "C:\\Documents and Settings\\093031_101071\\RECOG\\project\\Metagenome\\cluster_20091224.dclst";
            AbstractDomClustImporter abstractDomClustImporter = DomClustListImporter.createDomClustImporter(string);
            abstractDomClustImporter.execute();
            abstractDomClustImporter.getClusterList();
            List list = abstractDomClustImporter.getOrganismCodeList();
            String string2 = abstractDomClustImporter.getDomClustId();
            List list2 = abstractDomClustImporter.getClusterList();
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("OP1");
            HashSet hashSet2 = new HashSet(list);
            hashSet2.removeAll(hashSet);
            CellInfoTitle cellInfoTitle = CellInfoTitle.createInfoTitle("Test", "Test", 1, "Test");
            cellInfoTitle.setCategory(4);
            cellInfoTitle.setInfoType(3);
            TaxMapGenomeScoreCalculater taxMapGenomeScoreCalculater = new TaxMapGenomeScoreCalculater(null, null, null, string2, hashSet, hashSet2, cellInfoTitle, list2);
            taxMapGenomeScoreCalculater.execute(new DummyProgressComponent());
            Map map = taxMapGenomeScoreCalculater.getScoreMap();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

