/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.data.RankComparator;
import cgdp.recog.data.RankDif;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.observer.ApplicationObservable;
import cgdp.recog.observer.ApplicationObserver;
import cgdp.recog.observer.ApplicationObserverEvent;
import cgdp.recog.option.DefaultOptionValues;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.project.Project;
import cgdp.recog.system.property.ApplicationProperty;
import cgdp.recog.system.property.ApplicationPropertyAccessable;
import cgdp.recog.taxonomy.DisplayTaxonomyTreeNode;
import cgdp.recog.taxonomy.TaxTreeShowType;
import cgdp.recog.taxonomy.TaxonomyTreeNode;
import cgdp.recog.taxonomy.map.AbstractRankScoreCalculater;
import cgdp.recog.taxonomy.map.TaxMapAggregateType;
import cgdp.recog.taxonomy.map.TaxMapConf;
import cgdp.recog.taxonomy.map.TaxMapDisplayMode;
import cgdp.recog.taxonomy.map.TaxMapFacade;
import cgdp.recog.taxonomy.map.TaxMapInfoComapartor;
import cgdp.recog.taxonomy.map.TaxTreeBarType;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.LabelValue;
import cgdp.recog.util.LabelValueComparator;
import cgdp.recog.util.StringTool;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreeNode;
import org.jfree.chart.plot.PlotOrientation;

public class TaxMapModel
implements ApplicationPropertyAccessable {
    private static final ApplicationLogger logger = new ApplicationLogger(TaxMapModel.class);
    protected static final String FONT_NAME = "Times New Roman";
    private static final int FONT_STYLE = 1;
    private static final float DEFAULT_FONT_SIZE = 12.0f;
    static final Font TITLE_FONT = new Font("Times New Roman", 1, 12);
    public static final int MODE_SCORE_LOWER = 1;
    public static final int MODE_SCORE_UPPER = 2;
    public static final int MODE_GENE_COUNT_LOWER = 3;
    public static final int MODE_GENE_COUNT_UPPER = 4;
    public static final String DISPLAY_RANK_MODE_SYNC_SELECT_RANK = "SelectRank";
    static final String NO_HIT_CODE = "nohits";
    static final String NO_HIT_CODE_NAME = "No hits";
    static final String NO_HIT_RANK = "nohits";
    static final String UNASSIGNED_NAME = "Unassigned";
    static final String HIGHER_RANK_NAME = "Higher rank";
    static final String OTHER_NAME = "Other";
    private TaxMapConf taxMapConf;
    private String domClustId;
    private Set treeOrganismCodeSet = new HashSet();
    private Set mappingOrganismCodeSet = new HashSet();
    private List taxMapInfoList = new ArrayList();
    private TaxonomyTreeNode rootNode;
    private Map keyNodeMap;
    private Map rankTaxMapInfoMap = new HashMap();
    private Map rankScoreMap = new HashMap();
    private Map parentRankScoreMap = new HashMap();
    private Map childRankScoreMap = new HashMap();
    private Map geneCountMap = new HashMap();
    private boolean allRank = false;
    private Set rankSet = new HashSet();
    private Map rankNodeSetMap = new HashMap();
    private Set areaSet = new HashSet();
    private Set treeIconAreaSet = new HashSet();
    private int geneScoreMode = 3;
    private Map geneScoreMap = new HashMap();
    private List unassignedTaxMapInfoList = new ArrayList();
    private boolean showUnassigned = true;
    private boolean showHigherRank = true;
    private List selectNodeList = new ArrayList();
    private boolean syncPPMFilter = false;
    private boolean syncPPMSelect = false;
    private boolean showLabelPopulation = true;
    private AbstractInfoTitle selectedInfoTitle = ClusterInfoFacade.getInfoTitle("CFuncCat");
    private int displayMaxValuePropGraph = 10;
    private boolean enableMaxRankCount = true;
    private int displayMaxRankCount = 5;
    private int treeBarType = 1;
    private double cumulativeBarStep = 10.0;
    private PlotOrientation propertyGraphOrientation = PlotOrientation.HORIZONTAL;
    private boolean enableScoreFilter = false;
    private double scoreFilterThreshold = 0.0;
    private int displayMode = 1;
    private String displayRankMode = "SelectRank";
    private int aggregate = 1;
    private Map organismNameMap = new HashMap();
    private Map organismCodeMap = new HashMap();
    private ApplicationObservable observable = new ApplicationObservable();

    public TaxMapModel() {
        TaxMapModel.updateDefaultShowRankSet(this);
    }

    public TaxMapConf getTaxMapConf() {
        return this.taxMapConf;
    }

    public void setTaxMapConf(TaxMapConf taxMapConf) {
        this.taxMapConf = taxMapConf;
    }

    public String getTaxMapListFilename() {
        return this.taxMapConf.getFilename();
    }

    public Set getBaseMappingOrganismCodeSet() {
        return this.taxMapConf.getMappingOrganismCodeSet();
    }

    public String getDomClustId() {
        return this.domClustId;
    }

    public void setDomClustId(String string) {
        this.domClustId = string;
    }

    public List getTaxMapInfoList() {
        return this.taxMapInfoList;
    }

    public void setTaxMapInfoList(List list) {
        this.taxMapInfoList = list;
    }

    public void setTreeOrganismCodeSet(Set set) {
        this.treeOrganismCodeSet = set;
        this.updateOrganismNameMap(this.treeOrganismCodeSet);
    }

    public Set getTreeOrganismCodeSet() {
        return this.treeOrganismCodeSet;
    }

    private void updateOrganismNameMap(Collection collection) {
        if (CollectionUtil.isNull(collection)) {
            return;
        }
        List list = OrganismUtil.getOrganismList(collection);
        this.organismNameMap.putAll(OrganismUtil.createOrganismMap(list));
        this.organismCodeMap.putAll(OrganismUtil.createOrganismNameMap(list));
    }

    public String getDisplayOrganismName(String string) {
        Organism organism = (Organism)this.organismNameMap.get(string);
        String string2 = string;
        if (organism != null) {
            string2 = organism.getNameForTaxonomy();
        }
        return string2;
    }

    public String getOrganismCodeByName(String string) {
        Organism organism = (Organism)this.organismCodeMap.get(string);
        if (organism == null) {
            return string;
        }
        return organism.getOrganismCode();
    }

    public TaxonomyTreeNode getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(TaxonomyTreeNode taxonomyTreeNode) {
        this.rootNode = taxonomyTreeNode;
    }

    public void setKeyNodeMap(Map map) {
        this.keyNodeMap = map;
    }

    public Map getKeyNodeMap() {
        return this.keyNodeMap;
    }

    public TaxonomyTreeNode getTaxonomyTreeNode(String string) {
        return (TaxonomyTreeNode)this.getKeyNodeMap().get(string);
    }

    public int getGeneScoreMode() {
        return this.geneScoreMode;
    }

    public void setGeneScoreMode(int n) {
        this.geneScoreMode = n;
    }

    public boolean isModeScoreLower() {
        return TaxMapModel.isModeScoreLower(this.getGeneScoreMode());
    }

    public boolean isModeScoreUpper() {
        return TaxMapModel.isModeScoreUpper(this.getGeneScoreMode());
    }

    public boolean isModeScore() {
        return TaxMapModel.isModeScore(this.getGeneScoreMode());
    }

    public static boolean isModeScoreLower(int n) {
        return n == 1;
    }

    public static boolean isModeScoreUpper(int n) {
        return n == 2;
    }

    public static boolean isModeScore(int n) {
        return TaxMapModel.isModeScoreLower(n) || TaxMapModel.isModeScoreUpper(n);
    }

    public boolean isModeGeneCountLower() {
        return this.getGeneScoreMode() == 3;
    }

    public boolean isModeGeneCountUpper() {
        return this.getGeneScoreMode() == 4;
    }

    public boolean isModeGeneCount() {
        return this.isModeGeneCountLower() || this.isModeGeneCountUpper();
    }

    public boolean isLower() {
        return this.isModeGeneCountLower() || this.isModeScoreLower();
    }

    public boolean isUpper() {
        return this.isModeGeneCountUpper() || this.isModeScoreUpper();
    }

    public String getDisplayRankMode() {
        return this.displayRankMode;
    }

    public boolean isDisplayRankSyncSelectRank() {
        return this.getDisplayRankMode().equals(DISPLAY_RANK_MODE_SYNC_SELECT_RANK);
    }

    public void setDisplayRankMode(String string) {
        this.displayRankMode = string;
    }

    public boolean isSameDisplayRankMode(String string) {
        return this.getDisplayRankMode().equals(string);
    }

    public int getAggregate() {
        return this.aggregate;
    }

    public boolean isAggregateMaxScoreInfo() {
        return TaxMapAggregateType.isMaxScoreInfo(this.getAggregate());
    }

    public boolean isNoAggregate() {
        return TaxMapAggregateType.isNoAggregate(this.getAggregate());
    }

    public boolean isAggregateScoring() {
        return TaxMapAggregateType.isScoring(this.getAggregate());
    }

    public void setAggregate(int n) {
        this.aggregate = n;
    }

    public void setGeneScoreMap(Map map) {
        this.geneScoreMap = map;
    }

    public Map getGeneScoreMap() {
        return this.geneScoreMap;
    }

    public void setRankNodeSetMap(Map map) {
        this.rankNodeSetMap = map;
    }

    public Map getRankNodeSetMap() {
        return this.rankNodeSetMap;
    }

    public Set getTaxonomyNodeSetByRank(String string) {
        return (Set)this.getRankNodeSetMap().get(string);
    }

    public void setRankTaxMapInfoMap(Map map) {
        this.rankTaxMapInfoMap = map;
    }

    public Map getRankTaxMapInfoMap() {
        return this.rankTaxMapInfoMap;
    }

    public Set getRankNameSet() {
        return new HashSet(this.getRankTaxMapInfoMap().keySet());
    }

    public Map getRankScoreMap() {
        return this.rankScoreMap;
    }

    public void setRankScoreMap(Map map) {
        this.rankScoreMap = map;
    }

    public Map getParentRankScoreMap() {
        return this.parentRankScoreMap;
    }

    public void setParentRankScoreMap(Map map) {
        this.parentRankScoreMap = map;
    }

    public Map getChildRankScoreMap() {
        return this.childRankScoreMap;
    }

    public void setChildRankScoreMap(Map map) {
        this.childRankScoreMap = map;
    }

    public List getUnassignedTaxMapInfoList() {
        return this.unassignedTaxMapInfoList;
    }

    public double getUnassignedTaxMapInfoScore() {
        return AbstractRankScoreCalculater.calcScore(this, this.getUnassignedTaxMapInfoList());
    }

    public void setUnassignedTaxMapInfoList(List list) {
        this.unassignedTaxMapInfoList = list;
    }

    public boolean isUnassignedTaxMapInfoList() {
        return !CollectionUtil.isNull(this.getUnassignedTaxMapInfoList());
    }

    public boolean isShowUnassigned() {
        return this.showUnassigned;
    }

    public void setShowUnassigned(boolean bl) {
        this.showUnassigned = bl;
    }

    public boolean isShowHigherRank() {
        return this.showHigherRank;
    }

    public void setShowHigherRank(boolean bl) {
        this.showHigherRank = bl;
    }

    public List getHigherRankTaxMapInfoList() {
        String string = this.getDisplayRank();
        List list = RankDif.getRankList();
        Collections.sort(list, new RankComparator());
        int n = list.indexOf(string);
        if (n <= 0) {
            return new ArrayList();
        }
        List list2 = list.subList(0, n - 1);
        HashSet hashSet = new HashSet();
        for (String string2 : list2) {
            hashSet.addAll(this.getTaxMapInfoSetByRank(string2));
        }
        hashSet.removeAll(this.getTaxMapInfoSetByRank(string));
        return new ArrayList(hashSet);
    }

    private Set getTaxMapInfoSetByRank(String string) {
        HashSet hashSet = new HashSet();
        Set set = this.getTaxonomyNodeSetByRank(string);
        for (TaxonomyTreeNode taxonomyTreeNode : set) {
            hashSet.addAll(this.getTaxMapInfoList(taxonomyTreeNode));
        }
        return hashSet;
    }

    public double getHigherRankTaxMapInfoListScore() {
        return AbstractRankScoreCalculater.calcScore(this, this.getHigherRankTaxMapInfoList());
    }

    public boolean isHigherRankTaxMapInfoList() {
        return !CollectionUtil.isNull(this.getHigherRankTaxMapInfoList());
    }

    public boolean isSyncPPMFilter() {
        return this.syncPPMFilter;
    }

    public void setSyncPPMFilter(boolean bl) {
        this.syncPPMFilter = bl;
    }

    public boolean isSyncPPMSelect() {
        return this.syncPPMSelect;
    }

    public void setSyncPPMSelect(boolean bl) {
        this.syncPPMSelect = bl;
    }

    public void setDisplayMode(int n) {
        this.displayMode = n;
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public boolean isActionMode() {
        return TaxMapDisplayMode.isAction(this.getDisplayMode());
    }

    public boolean isViewMode() {
        return TaxMapDisplayMode.isView(this.getDisplayMode());
    }

    public Map getSelectNodeRankTaxMapInfoMap() {
        String string = this.getDisplayRank();
        if (StringTool.isNull(string)) {
            return this.getRankTaxMapInfoMap();
        }
        Set set = this.getTaxonomyNodeSetByRank(string);
        HashMap<String, List> hashMap = new HashMap<String, List>();
        for (TaxonomyTreeNode taxonomyTreeNode : set) {
            List list = this.getTaxMapInfoList(taxonomyTreeNode);
            if (CollectionUtil.isNull(list)) continue;
            hashMap.put(TaxMapModel.getKeyName(taxonomyTreeNode), list);
        }
        return hashMap;
    }

    public String getGraphTitle() {
        if (this.isDisplayRankSyncSelectRank()) {
            return this.getSelectNodeRankTitle();
        }
        return StringTool.toUpperCaseTop(this.getDisplayRankMode());
    }

    private String getSelectNodeRankTitle() {
        if (!this.isExistSelectedNode()) {
            return "All";
        }
        if (this.getSelectNodeList().size() > 1) {
            return OTHER_NAME;
        }
        TaxonomyTreeNode taxonomyTreeNode = this.getSelectNode();
        return StringTool.toUpperCaseTop(taxonomyTreeNode.getRank());
    }

    public String getSelectNodeName() {
        if (!this.isExistSelectedNode()) {
            return "All";
        }
        if (this.getSelectNodeList().size() > 1) {
            return OTHER_NAME;
        }
        TaxonomyTreeNode taxonomyTreeNode = this.getSelectNode();
        return taxonomyTreeNode.getName();
    }

    public Set getAllRankNameSet() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.getRankScoreMap().keySet());
        hashSet.addAll(this.getParentRankScoreMap().keySet());
        hashSet.addAll(this.getChildRankScoreMap().keySet());
        return hashSet;
    }

    private String getDisplayRank() {
        String string = this.getDisplayRankMode();
        if (this.isDisplayRankSyncSelectRank()) {
            TaxonomyTreeNode taxonomyTreeNode = this.getSelectNode();
            if (taxonomyTreeNode == null) {
                return null;
            }
            string = taxonomyTreeNode.getRank();
        }
        return string;
    }

    public Set getSameRankNameSet() {
        String string = this.getDisplayRank();
        if (StringTool.isNull(string)) {
            return this.getAllRankNameSet();
        }
        HashSet<String> hashSet = new HashSet<String>();
        Set set = this.getTaxonomyNodeSetByRank(string);
        for (TaxonomyTreeNode taxonomyTreeNode : set) {
            if (this.getTotalScore(taxonomyTreeNode) == 0.0) continue;
            hashSet.add(TaxMapModel.getKeyName(taxonomyTreeNode));
        }
        return hashSet;
    }

    public List getSelectedNodeRankLabelValueList() {
        Set set = this.getSameRankNameSet();
        ArrayList<LabelValue> arrayList = new ArrayList<LabelValue>();
        for (String string : set) {
            double d = this.getTotalScore(string);
            if (d == 0.0) continue;
            LabelValue labelValue = new LabelValue(string, new Double(d));
            arrayList.add(labelValue);
        }
        Collections.sort(arrayList, new LabelValueComparator(2));
        return arrayList;
    }

    static String getKeyName(TaxonomyTreeNode taxonomyTreeNode) {
        if (taxonomyTreeNode.isGenome()) {
            return taxonomyTreeNode.getAbbreviation();
        }
        return taxonomyTreeNode.getName();
    }

    public boolean isExistRankTaxMapInfo(TaxonomyTreeNode taxonomyTreeNode) {
        return this.isExistRankTaxMapInfo(TaxMapModel.getKeyName(taxonomyTreeNode));
    }

    public boolean isExistRankTaxMapInfo(String string) {
        return this.rankTaxMapInfoMap.containsKey(string);
    }

    public List getTaxMapInfoList(TaxonomyTreeNode taxonomyTreeNode) {
        return this.getTaxMapInfoList(TaxMapModel.getKeyName(taxonomyTreeNode));
    }

    public List getSelectedTaxMapInfoList() {
        if (!this.isExistSelectedNode()) {
            return new ArrayList();
        }
        ArrayList arrayList = new ArrayList();
        for (TaxonomyTreeNode taxonomyTreeNode : this.getSelectNodeList()) {
            arrayList.addAll(this.getTaxMapInfoList(taxonomyTreeNode));
        }
        return arrayList;
    }

    public List getTaxMapInfoList(String string) {
        if (this.isUnassignedName(string)) {
            return this.getUnassignedTaxMapInfoList();
        }
        ArrayList arrayList = (ArrayList)this.rankTaxMapInfoMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        return arrayList;
    }

    public boolean isExistRankScore(TaxonomyTreeNode taxonomyTreeNode) {
        String string = TaxMapModel.getKeyName(taxonomyTreeNode);
        return this.rankScoreMap.containsKey(string) || this.getParentRankScoreMap().containsKey(string) || this.getChildRankScoreMap().containsKey(string);
    }

    public double getScore(TaxonomyTreeNode taxonomyTreeNode) {
        return this.getScore(TaxMapModel.getKeyName(taxonomyTreeNode));
    }

    public double getScore(String string) {
        return TaxMapModel.getScore(string, this.getRankScoreMap());
    }

    public double getParentScore(String string) {
        return TaxMapModel.getScore(string, this.getParentRankScoreMap());
    }

    public double getParentScore(TaxonomyTreeNode taxonomyTreeNode) {
        return TaxMapModel.getScore(taxonomyTreeNode, this.getParentRankScoreMap());
    }

    public double getChildScore(String string) {
        return TaxMapModel.getScore(string, this.getChildRankScoreMap());
    }

    public double getChildScore(TaxonomyTreeNode taxonomyTreeNode) {
        return TaxMapModel.getScore(taxonomyTreeNode, this.getChildRankScoreMap());
    }

    private static double getScore(TaxonomyTreeNode taxonomyTreeNode, Map map) {
        String string = TaxMapModel.getKeyName(taxonomyTreeNode);
        return TaxMapModel.getScore(string, map);
    }

    private static double getScore(String string, Map map) {
        Double d = (Double)map.get(string);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public int getGeneCount(String string) {
        List list = this.getTaxMapInfoList(string);
        if (CollectionUtil.isNull(list)) {
            return 0;
        }
        return list.size();
    }

    public double getScoreRatio(String string) {
        return this.getScoreRatio(string, this.getRankScoreMap());
    }

    public double getParentScoreRatio(String string) {
        return this.getScoreRatio(string, this.getParentRankScoreMap());
    }

    public double getChildScoreRatio(String string) {
        return this.getScoreRatio(string, this.getChildRankScoreMap());
    }

    private double getScoreRatio(String string, Map map) {
        double d = TaxMapModel.getScore(string, map);
        double d2 = d / this.getTotalScore();
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        return d2;
    }

    public double getMaxTotalScore() {
        double d = 0.0;
        for (String string : this.getRankNameSet()) {
            d = Math.max(d, this.getTotalScore(string));
        }
        return d;
    }

    public double getTotalScore(TaxonomyTreeNode taxonomyTreeNode) {
        double d = this.getScore(taxonomyTreeNode);
        double d2 = this.getParentScore(taxonomyTreeNode);
        double d3 = this.getChildScore(taxonomyTreeNode);
        double d4 = d + d2 + d3;
        return d4;
    }

    public double getTotalScore(String string) {
        double d = this.getScore(string);
        double d2 = this.getParentScore(string);
        double d3 = this.getChildScore(string);
        double d4 = d + d2 + d3;
        return d4;
    }

    private double getTotalScore() {
        double d = 0.0;
        if (this.isModeGeneCountLower() || this.isModeGeneCountUpper()) {
            for (String string : this.rankScoreMap.keySet()) {
                Double d2 = (Double)this.rankScoreMap.get(string);
                if (d2 == null) continue;
                d += d2.doubleValue();
            }
        } else {
            HashSet hashSet = new HashSet(this.getRankScoreMap().keySet());
            hashSet.addAll(this.getParentRankScoreMap().keySet());
            hashSet.addAll(this.getChildRankScoreMap().keySet());
            for (String string : hashSet) {
                if (TaxMapModel.isNoHitsCode(string)) continue;
                double d3 = this.getScore(string);
                double d4 = this.getParentScore(string);
                double d5 = this.getChildScore(string);
                double d6 = d3 + d4 + d5;
                d = Math.max(d, d6);
            }
        }
        return d;
    }

    public int getTotalGeneCount() {
        int n = 0;
        Iterator iterator = this.geneCountMap.values().iterator();
        while (iterator.hasNext()) {
            n += ((Integer)iterator.next()).intValue();
        }
        return n;
    }

    public synchronized TaxonomyTreeNode getSelectNode() {
        if (!this.isExistSelectedNode()) {
            return null;
        }
        return (TaxonomyTreeNode)this.getSelectNodeList().get(0);
    }

    public synchronized List getSelectNodeList() {
        return this.selectNodeList;
    }

    public synchronized void setSelectNode(TaxonomyTreeNode taxonomyTreeNode) {
        this.selectNodeList.clear();
        if (taxonomyTreeNode != null) {
            this.selectNodeList.add(taxonomyTreeNode);
        }
    }

    public synchronized void setSelectNodeList(List list) {
        this.selectNodeList = list;
    }

    public boolean isExistSelectedNode() {
        return !CollectionUtil.isNull(this.getSelectNodeList());
    }

    public boolean isOtherSelected() {
        return this.getSelectNodeList().size() > 1;
    }

    public List getSelectNodeTaxMapInfoList() {
        ArrayList arrayList = new ArrayList();
        if (!this.isExistSelectedNode()) {
            for (String string : this.getRankTaxMapInfoMap().keySet()) {
                if (TaxMapModel.isNoHitsCode(string)) continue;
                arrayList.addAll(this.getTaxMapInfoList(string));
            }
            arrayList.addAll(this.getUnassignedTaxMapInfoList());
        } else {
            for (TaxonomyTreeNode taxonomyTreeNode : this.getSelectNodeList()) {
                arrayList.addAll(this.getTaxMapInfoList(taxonomyTreeNode));
            }
        }
        Collections.sort(arrayList, new TaxMapInfoComapartor());
        return arrayList;
    }

    public String getRank(TaxonomyTreeNode taxonomyTreeNode) {
        if (taxonomyTreeNode.getAbbreviation().equals("nohits")) {
            return "nohits";
        }
        return taxonomyTreeNode.getRank();
    }

    public static boolean isNoHitsRank(String string) {
        return string.equals("nohits");
    }

    public static boolean isNoHitsCode(String string) {
        return string.equals("nohits");
    }

    public Map getGeneCountMap() {
        return this.geneCountMap;
    }

    public void setGeneCountMap(Map map) {
        this.geneCountMap = map;
    }

    public double getGeneScore(String string) {
        Double d = (Double)this.getGeneScoreMap().get(string);
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    public Set getMappingOrganismCodeSet() {
        return this.mappingOrganismCodeSet;
    }

    public void setMappingOrganismCodeSet(Set set) {
        this.mappingOrganismCodeSet = set;
        this.updateOrganismNameMap(this.mappingOrganismCodeSet);
    }

    public boolean isShowLabelPopulation() {
        return this.showLabelPopulation;
    }

    public void setShowLabelPopulation(boolean bl) {
        this.showLabelPopulation = bl;
    }

    public void setAllRank(boolean bl) {
        this.allRank = bl;
    }

    public boolean isAllRank() {
        return this.allRank;
    }

    public Set getRankSet() {
        return this.rankSet;
    }

    public void setRankSet(Set set) {
        this.rankSet = set;
    }

    public boolean containsShowRank(String string) {
        return this.rankSet.contains(string);
    }

    public void addRankArea(TaxonomyTreeNode taxonomyTreeNode, Rectangle rectangle) {
        this.areaSet.add(new RankArea(taxonomyTreeNode, rectangle));
    }

    public void clearRankArea() {
        this.areaSet.clear();
    }

    public Rectangle getRect(TaxonomyTreeNode taxonomyTreeNode) {
        for (RankArea rankArea : this.areaSet) {
            if (!rankArea.getNode().equals(taxonomyTreeNode)) continue;
            return rankArea.getRect();
        }
        return null;
    }

    public void clearTreeIconAreaSet() {
        this.treeIconAreaSet.clear();
    }

    public void addTreeIconRect(TaxonomyTreeNode taxonomyTreeNode, Rectangle rectangle) {
        this.treeIconAreaSet.add(new RankArea(taxonomyTreeNode, rectangle));
    }

    public Set getTaxonomyTreeNodeSetOnTreeIcon(Point point) {
        HashSet<TaxonomyTreeNode> hashSet = new HashSet<TaxonomyTreeNode>();
        for (RankArea rankArea : this.treeIconAreaSet) {
            if (!rankArea.containsArea(point)) continue;
            hashSet.add(rankArea.getNode());
        }
        return hashSet;
    }

    public Rectangle getSelectedNodeRect() {
        if (!this.isExistSelectedNode()) {
            return null;
        }
        Rectangle rectangle = this.getRect(this.getSelectNode());
        if (rectangle == null) {
            return null;
        }
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width + 10, rectangle.height + 5);
        return rectangle2;
    }

    public List getSelectedNodeRectList() {
        if (!this.isExistSelectedNode()) {
            return null;
        }
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        for (TaxonomyTreeNode taxonomyTreeNode : this.getSelectNodeList()) {
            Rectangle rectangle = this.getRect(taxonomyTreeNode);
            if (rectangle == null) continue;
            arrayList.add(rectangle);
        }
        return arrayList;
    }

    private boolean isShowRank(String string) {
        return this.getRankSet().contains(string);
    }

    boolean isShowRank(TaxonomyTreeNode taxonomyTreeNode) {
        if (this.isAllRank()) {
            return true;
        }
        if (taxonomyTreeNode.getLevel() == 1) {
            return true;
        }
        if (RankDif.isGenome(taxonomyTreeNode.getRank())) {
            return true;
        }
        for (int i = 0; i < RankDif.RANKS.length; ++i) {
            String string = RankDif.RANKS[i];
            if (!taxonomyTreeNode.equalsRank(string) || !this.isShowRank(string)) continue;
            return true;
        }
        return false;
    }

    public boolean containsRankArea(Point point) {
        return this.getTaxonomyTreeNode(point) != null;
    }

    public boolean containsTreeIcon(Point point) {
        return !CollectionUtil.isNull(this.getTaxonomyTreeNodeSetOnTreeIcon(point));
    }

    public TaxonomyTreeNode getTaxonomyTreeNode(Point point) {
        for (RankArea rankArea : this.areaSet) {
            if (!rankArea.containsArea(point)) continue;
            return rankArea.getNode();
        }
        return null;
    }

    static TaxonomyTreeNode createNoHitNode() {
        DisplayTaxonomyTreeNode displayTaxonomyTreeNode = new DisplayTaxonomyTreeNode(1, NO_HIT_CODE_NAME, "nohits", "genome", -1, -1, -1L);
        return displayTaxonomyTreeNode;
    }

    private static void updateDefaultShowRankSet(TaxMapModel taxMapModel) {
        taxMapModel.setAllRank(TaxTreeShowType.isAllRank(1));
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < RankDif.RANKS.length; ++i) {
            String string = RankDif.RANKS[i];
            if (!DefaultOptionValues.isDefaultTaxTreeRankSelected(string)) continue;
            hashSet.add(string);
        }
        taxMapModel.setRankSet(hashSet);
    }

    public AbstractInfoTitle getSelectedInfoTitle() {
        return this.selectedInfoTitle;
    }

    public void setSelectedInfoTitle(AbstractInfoTitle abstractInfoTitle) {
        this.selectedInfoTitle = abstractInfoTitle;
    }

    public boolean isFuncCatInfoTitle() {
        return this.getSelectedInfoTitle().equalsKey("CFuncCat");
    }

    public boolean isNumInfoTitle() {
        return this.getSelectedInfoTitle().isNumeric();
    }

    public boolean isTextInfoTitle() {
        return !this.isFuncCatInfoTitle() && !this.isNumInfoTitle();
    }

    public int getDisplayMaxValuePropGraph() {
        return this.displayMaxValuePropGraph;
    }

    public void setDisplayMaxValuePropGraph(int n) {
        this.displayMaxValuePropGraph = n;
    }

    public boolean isEnableMaxRankCount() {
        return this.enableMaxRankCount;
    }

    public void setEnableMaxRankCount(boolean bl) {
        this.enableMaxRankCount = bl;
    }

    public int getTreeBarType() {
        return this.treeBarType;
    }

    public void setTreeBarType(int n) {
        this.treeBarType = n;
    }

    public double getCumulativeBarStep() {
        return this.cumulativeBarStep;
    }

    public void setCumulativeBarStep(double d) {
        this.cumulativeBarStep = d;
    }

    public PlotOrientation getPropertyGraphOrientation() {
        return this.propertyGraphOrientation;
    }

    public void setPropertyGraphOrientation(PlotOrientation plotOrientation) {
        this.propertyGraphOrientation = plotOrientation;
    }

    public boolean isPropertyGraphHorizontal() {
        return this.getPropertyGraphOrientation().equals(PlotOrientation.HORIZONTAL);
    }

    public boolean isPropertyGraphVertical() {
        return this.getPropertyGraphOrientation().equals(PlotOrientation.VERTICAL);
    }

    public boolean isGradation() {
        return TaxTreeBarType.isGradation(this.getTreeBarType());
    }

    public boolean isLine() {
        return TaxTreeBarType.isLine(this.getTreeBarType());
    }

    public boolean isCumulative() {
        return TaxTreeBarType.isCumulative(this.getTreeBarType());
    }

    public Set getMappingNodeSet() {
        HashSet<TaxonomyTreeNode> hashSet = new HashSet<TaxonomyTreeNode>();
        Enumeration<TreeNode> enumeration = this.getRootNode().depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            TaxonomyTreeNode taxonomyTreeNode = (TaxonomyTreeNode)enumeration.nextElement();
            if (!this.isExistRankTaxMapInfo(taxonomyTreeNode) || TaxMapModel.isNoHitsCode(taxonomyTreeNode.getAbbreviation())) continue;
            hashSet.add(taxonomyTreeNode);
        }
        return hashSet;
    }

    public boolean isEnableScoreFilter() {
        return this.enableScoreFilter;
    }

    public void setEnableScoreFilter(boolean bl) {
        this.enableScoreFilter = bl;
    }

    public double getScoreFilterThreshold() {
        return this.scoreFilterThreshold;
    }

    public void setScoreFilterThreshold(double d) {
        this.scoreFilterThreshold = d;
    }

    public boolean isMatchScoreFilter(String string) {
        if (!this.isEnableScoreFilter()) {
            return true;
        }
        double d = this.getTotalScore(string);
        return d >= this.getScoreFilterThreshold();
    }

    public int getDisplayMaxRankCount() {
        return this.displayMaxRankCount;
    }

    public void setDisplayMaxRankCount(int n) {
        this.displayMaxRankCount = n;
    }

    public boolean isOtherName(String string) {
        return string.equals(OTHER_NAME);
    }

    public boolean isUnassignedName(String string) {
        return string.equals(UNASSIGNED_NAME);
    }

    public static TaxonomyTreeNode createUnassingedNode() {
        return new TaxonomyTreeNode(-1, UNASSIGNED_NAME, UNASSIGNED_NAME, "genome", -1, -1, 0L);
    }

    public Set getOtherTaxonomyTreeNodeSet() {
        List list = this.getSelectedNodeRankLabelValueList();
        int n = 1;
        HashSet<TaxonomyTreeNode> hashSet = new HashSet<TaxonomyTreeNode>();
        for (LabelValue labelValue : list) {
            String string = labelValue.getLabel();
            if (TaxMapModel.isNoHitsCode(string)) continue;
            if (!this.isDisplayRankOrder(n)) {
                TaxonomyTreeNode taxonomyTreeNode = this.getTaxonomyTreeNode(string);
                hashSet.add(taxonomyTreeNode);
            }
            ++n;
        }
        return hashSet;
    }

    public boolean isDisplayRankOrder(int n) {
        if (!this.isEnableMaxRankCount()) {
            return true;
        }
        return n <= this.getDisplayMaxRankCount();
    }

    @Override
    public String getCategory() {
        return "TaxMap";
    }

    @Override
    public List getPropertyList(Project project, String string) {
        ArrayList<ApplicationProperty> arrayList = new ArrayList<ApplicationProperty>();
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "TaxMapName", this.getTaxMapConf().getName()));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "TaxMapAllRank", String.valueOf(this.isAllRank())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "TaxMapShowRank", StringTool.conbineStrList(this.getRankSet(), ",")));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "TaxMapTopPropertyCount", String.valueOf(this.getDisplayMaxValuePropGraph())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "TaxMapTopRankCount", String.valueOf(this.getDisplayMaxRankCount())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "TaxMapTopRankCountEnable", String.valueOf(this.isEnableMaxRankCount())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "TaxMapSyncSelectOnPPM", String.valueOf(this.isSyncPPMSelect())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "TaxMapSyncFilterOnPPM", String.valueOf(this.isSyncPPMFilter())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "TaxMapScoreFilterEnable", String.valueOf(this.isEnableScoreFilter())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "TaxMapScoreFilterThreshold", String.valueOf(this.getScoreFilterThreshold())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "TaxMapShowLabelPopulation", String.valueOf(this.isShowLabelPopulation())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "TaxMapGeneScoreMode", String.valueOf(this.getGeneScoreMode())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "TaxMapDisplayMode", String.valueOf(this.getDisplayMode())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "TaxMapShowUnassignedGene", String.valueOf(this.isShowUnassigned())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "TaxMapShowHigherRank", String.valueOf(this.isShowHigherRank())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "TaxMapDisplayRankMode", this.getDisplayRankMode()));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "TaxMapAggregate", String.valueOf(this.getAggregate())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "TaxMapTreeBarType", String.valueOf(this.getTreeBarType())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "TaxMapCumulativeBarStep", String.valueOf(this.getCumulativeBarStep())));
        return arrayList;
    }

    @Override
    public int getPropertyType() {
        return 2;
    }

    @Override
    public void updateProperty(Map map, Project project, String string) {
        String string2;
        Object object;
        String string3 = (String)map.get("TaxMapName");
        if (StringTool.isNull(string3)) {
            string3 = "Default mapping";
        }
        try {
            TaxMapConf taxMapConf = TaxMapFacade.getTaxMapConf(project, string, string3);
            this.setTaxMapConf(taxMapConf);
        }
        catch (IOException iOException) {
            logger.warn("Fail to load the taxonomy mapping conf file." + string3, iOException);
            object = TaxMapConf.createDefaultTaxMapConf(new HashSet());
            this.setTaxMapConf((TaxMapConf)object);
        }
        if (map.containsKey("TaxMapAllRank")) {
            boolean bl = new Boolean((String)map.get("TaxMapAllRank"));
            this.setAllRank(bl);
        }
        if (map.containsKey("TaxMapShowRank")) {
            String string4 = (String)map.get("TaxMapShowRank");
            object = new HashSet(StringTool.splitString(string4, ","));
            this.setRankSet((Set)object);
        }
        if (map.containsKey("TaxMapTopPropertyCount")) {
            String string5 = (String)map.get("TaxMapTopPropertyCount");
            try {
                this.setDisplayMaxValuePropGraph(Integer.parseInt(string5));
            }
            catch (Exception exception) {
                string2 = "Fail to load Option[KEY_TAXMAP_TOP_PROPERTY_COUNT].";
                logger.warn(string2, exception);
            }
        }
        if (map.containsKey("TaxMapTopRankCount")) {
            String string6 = (String)map.get("TaxMapTopRankCount");
            try {
                this.setDisplayMaxRankCount(Integer.parseInt(string6));
            }
            catch (Exception exception) {
                string2 = "Fail to load Option[KEY_TAXMAP_TOP_RANK_COUNT].";
                logger.warn(string2, exception);
            }
        }
        if (map.containsKey("TaxMapTopRankCountEnable")) {
            String string7 = (String)map.get("TaxMapTopRankCountEnable");
            this.setEnableMaxRankCount(new Boolean(string7));
        }
        if (map.containsKey("TaxMapSyncSelectOnPPM")) {
            String string8 = (String)map.get("TaxMapSyncSelectOnPPM");
            this.setSyncPPMSelect(new Boolean(string8));
        }
        if (map.containsKey("TaxMapSyncFilterOnPPM")) {
            String string9 = (String)map.get("TaxMapSyncFilterOnPPM");
            this.setSyncPPMFilter(new Boolean(string9));
        }
        if (map.containsKey("TaxMapScoreFilterEnable")) {
            String string10 = (String)map.get("TaxMapScoreFilterEnable");
            this.setEnableScoreFilter(new Boolean(string10));
        }
        if (map.containsKey("TaxMapScoreFilterThreshold")) {
            String string11 = (String)map.get("TaxMapScoreFilterThreshold");
            try {
                this.setScoreFilterThreshold(Double.parseDouble(string11));
            }
            catch (Exception exception) {
                string2 = "Fail to load Option[KEY_TAXMAP_SCORE_FILTER_THRESHOLD].";
                logger.warn(string2, exception);
            }
        }
        if (map.containsKey("TaxMapShowLabelPopulation")) {
            String string12 = (String)map.get("TaxMapShowLabelPopulation");
            this.setShowLabelPopulation(new Boolean(string12));
        }
        if (map.containsKey("TaxMapGeneScoreMode")) {
            String string13 = (String)map.get("TaxMapGeneScoreMode");
            try {
                this.setGeneScoreMode(Integer.parseInt(string13));
            }
            catch (Exception exception) {
                string2 = "Fail to load Option[KEY_TAXMAP_GENE_SCORE_MODE].";
                logger.warn(string2, exception);
            }
        }
        if (map.containsKey("TaxMapDisplayMode")) {
            String string14 = (String)map.get("TaxMapDisplayMode");
            try {
                this.setDisplayMode(Integer.parseInt(string14));
            }
            catch (Exception exception) {
                string2 = "Fail to load Option[KEY_TAXMAP_DISPLAY_MODE].";
                logger.warn(string2, exception);
            }
        }
        if (map.containsKey("TaxMapShowUnassignedGene")) {
            String string15 = (String)map.get("TaxMapShowUnassignedGene");
            this.setShowUnassigned(new Boolean(string15));
        }
        if (map.containsKey("TaxMapDisplayRankMode")) {
            String string16 = (String)map.get("TaxMapDisplayRankMode");
            this.setDisplayRankMode(string16);
        }
        if (map.containsKey("TaxMapAggregate")) {
            String string17 = (String)map.get("TaxMapAggregate");
            try {
                this.setAggregate(Integer.parseInt(string17));
            }
            catch (Exception exception) {
                string2 = "Fail to load Option[KEY_TAXMAP_AGGREGATE].";
                logger.warn(string2, exception);
            }
        }
        if (map.containsKey("TaxMapTreeBarType")) {
            String string18 = (String)map.get("TaxMapTreeBarType");
            try {
                this.setTreeBarType(Integer.parseInt(string18));
            }
            catch (Exception exception) {
                string2 = "Fail to load Option[KEY_TAXMAP_BAR_TYPE].";
                logger.warn(string2, exception);
            }
        }
        if (map.containsKey("TaxMapCumulativeBarStep")) {
            String string19 = (String)map.get("TaxMapCumulativeBarStep");
            try {
                this.setCumulativeBarStep(Double.parseDouble(string19));
            }
            catch (Exception exception) {
                string2 = "Fail to load Option[KEY_TAXMAP_CUMULATIVE_BAR_STEP].";
                logger.warn(string2, exception);
            }
        }
    }

    public void addObserver(ApplicationObserver applicationObserver) {
        this.observable.addObserver(applicationObserver);
    }

    public void deleteObserver(ApplicationObserver applicationObserver) {
        this.observable.deleteObserver(applicationObserver);
    }

    public void deleteObservers() {
        this.observable.deleteObservers();
    }

    public void nodifyObservers(ApplicationObserverEvent applicationObserverEvent) {
        this.observable.notifyObservers(applicationObserverEvent);
    }

    private class RankArea {
        private TaxonomyTreeNode node;
        private Rectangle rect;

        public RankArea(TaxonomyTreeNode taxonomyTreeNode, Rectangle rectangle) {
            this.node = taxonomyTreeNode;
            this.rect = rectangle;
        }

        public TaxonomyTreeNode getNode() {
            return this.node;
        }

        public Rectangle getRect() {
            return this.rect;
        }

        public boolean equalsNode(TaxonomyTreeNode taxonomyTreeNode) {
            return this.getNode().equals(taxonomyTreeNode);
        }

        public boolean containsArea(Point point) {
            return this.getRect().contains(point);
        }
    }
}

