/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.taxonomy.map.TaxMapPopulationDataCreater;
import cgdp.recog.taxonomy.map.TaxMapUtil;
import cgdp.recog.util.AbstractFileExporter;
import cgdp.recog.util.FileUtil;
import org.jfree.data.general.PieDataset;

class TaxMapPopulationDataExporter
extends AbstractFileExporter {
    private static final String DELIMITER = "\t";
    private static final String HEADER = "Name\tValue\tRatio";
    private TaxMapModel taxMapModel;

    TaxMapPopulationDataExporter(TaxMapModel taxMapModel) {
        this.taxMapModel = taxMapModel;
    }

    @Override
    protected String getContents() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = !this.taxMapModel.isExistSelectedNode();
        TaxMapPopulationDataCreater taxMapPopulationDataCreater = new TaxMapPopulationDataCreater(this.taxMapModel, bl);
        PieDataset pieDataset = taxMapPopulationDataCreater.createPieDataset();
        float f = TaxMapUtil.calcSum(pieDataset);
        stringBuffer.append(HEADER);
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        for (int i = 0; i < pieDataset.getItemCount(); ++i) {
            String string = (String)((Object)pieDataset.getKey(i));
            float f2 = pieDataset.getValue(i).floatValue();
            float f3 = f2 / f;
            stringBuffer.append(string);
            stringBuffer.append(DELIMITER);
            stringBuffer.append(f2);
            stringBuffer.append(DELIMITER);
            stringBuffer.append(f3);
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        return stringBuffer.toString();
    }
}

