/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.update;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.DataFileDownloader;
import cgdp.recog.data.DataManager;
import cgdp.recog.data.GenomeExporter;
import cgdp.recog.data.GenomeImporter;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.server.AccessServer;
import cgdp.recog.update.AbstractDataUpdater;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class LocalGeneInfoUpdater
extends AbstractDataUpdater {
    private static final ApplicationLogger logger = new ApplicationLogger(LocalGeneInfoUpdater.class);
    private boolean forceFlag = false;

    LocalGeneInfoUpdater(Frame frame, MediatorImpl mediatorImpl) {
        super(frame, mediatorImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ProgressImpl progressImpl) {
        Object object;
        try {
            HashSet hashSet;
            progressImpl.setTotal(3);
            DataFileDownloader dataFileDownloader = DataFileDownloader.getInstance();
            DataManager.createDataDirectory();
            this.createWorkDir();
            object = this.getWorkDir();
            String string = new File((File)object, "taxonomy.dat").getAbsolutePath();
            String string2 = new File((File)object, "dataVersion").getAbsolutePath();
            String string3 = new File((File)object, "genome.dat").getAbsolutePath();
            String string4 = new File((File)object, "genome_param.dat").getAbsolutePath();
            dataFileDownloader.downloadTaxonomyData(string);
            progressImpl.increment();
            AbstractDataUpdater.updateDataVersion(string2);
            progressImpl.increment();
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            Set set = DataManager.getDataExistOrganismCodeSet();
            System.err.println("Organisms: " + set);
            dataFileDownloader.downloadGenomeParamData(string4);
            dataFileDownloader.downloadGenomeData(string3);
            GenomeImporter genomeImporter = new GenomeImporter(string3);
            genomeImporter.execute();
            GenomeImporter genomeImporter2 = new GenomeImporter(DataManager.getGenomeDat());
            genomeImporter2.execute();
            List list = genomeImporter2.getGenomeList();
            List list2 = genomeImporter.getGenomeList();
            if (this.isForceFlag()) {
                hashSet = new HashSet(set);
            } else {
                hashSet = DataManager.getOrganismCodeSetNotExistGeneChromosomeFile(set);
                hashSet.addAll(this.getUpdateOrganismCodeSet(list, list2, set));
            }
            List list3 = this.createUpdateGenmeList(list, list2, hashSet);
            GenomeExporter genomeExporter = new GenomeExporter(list3, string3);
            genomeExporter.execute();
            progressImpl.increment();
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            progressImpl.nextProc();
            progressImpl.setCount(-1);
            progressImpl.increment();
            progressImpl.setTotal(hashSet.size());
            dataFileDownloader.downloadGeneAndChromosomeData(hashSet, (File)object, progressImpl);
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            progressImpl.nextProc();
            progressImpl.setTotal(1);
            progressImpl.setCount(-1);
            progressImpl.increment();
            if (!this.downloadFunctionCategory()) {
                return;
            }
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            progressImpl.increment();
            this.copyFromWorkDir(AccessServer.getDataDir());
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
        }
        catch (Exception exception) {
            object = "Fail to update data files.";
            logger.warn((String)object, exception);
            this.setError(true);
            this.setErrorMessage((String)object);
        }
        finally {
            this.deleteWorkDir();
        }
    }

    @Override
    public String[] getProgressMessages() {
        return new String[]{"Update taxonomy tree data...", "Update gene data...", "Update function category..."};
    }

    @Override
    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage((Component)this.getParent(), this.getErrorMessages());
            return;
        }
        this.getMediator().updateTaxonomyTree();
    }

    public void setForceFlag(boolean bl) {
        this.forceFlag = bl;
    }

    private boolean isForceFlag() {
        return this.forceFlag;
    }

    public static void main(String[] stringArray) {
        LocalGeneInfoUpdater localGeneInfoUpdater = new LocalGeneInfoUpdater(null, null);
        localGeneInfoUpdater.execute(new DummyProgressComponent());
    }
}

