/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import cgdp.recog.server.AccessServer;
import cgdp.recog.server.ServerAccessException;
import cgdp.recog.util.AbstractServerConnection;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.ResourceBandleWrapper;
import cgdp.recog.util.ServerStatus;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.URLConnection;

public abstract class ProgressServerConnection
extends AbstractServerConnection {
    private static final ApplicationLogger logger = new ApplicationLogger(ProgressServerConnection.class);
    private static final long WAIT_TIME = 5000L;
    private static final long MAX_WAIT_TIME = 60000L;
    private int progress;
    private float increaseRate = 1.0f;
    private long waitTime = 5000L;
    private boolean intervalWait = true;

    public ProgressServerConnection() {
        this.setServerStatus("running");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute() throws Exception {
        if (this.isDebug()) {
            return;
        }
        if (!AccessServer.getInstance().isEnableAccess()) {
            throw new ServerAccessException();
        }
        this.before();
        try {
            while (this.isRunning()) {
                this.beforeRunning();
                URLConnection uRLConnection = this.postServer();
                if (!ProgressServerConnection.checkHttpStatus(uRLConnection)) {
                    this.setError();
                    this.setMessage(ResourceBandleWrapper.getMessage("error.access.server"));
                    return;
                }
                InputStreamReader inputStreamReader = null;
                BufferedReader bufferedReader = null;
                try {
                    if (this.isCanceled()) {
                        this.cancel();
                        return;
                    }
                    inputStreamReader = new InputStreamReader(uRLConnection.getInputStream());
                    bufferedReader = new BufferedReader(inputStreamReader);
                    this.loadServerOutput(bufferedReader);
                    if (this.isError()) {
                        return;
                    }
                    if (this.isRunning()) {
                        this.getProgressImpl().setCount(this.getProgress());
                        this.getProgressImpl().increment();
                        logger.info("runnning." + this.getProgress());
                    }
                    if (this.isIntervalWait()) {
                        Thread.sleep(this.waitTime);
                    }
                    this.waitTime = this.increaseWaitTime();
                }
                finally {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (inputStreamReader == null) continue;
                    inputStreamReader.close();
                }
            }
            return;
        }
        catch (ConnectException connectException) {
            this.setError();
            this.setMessage(ResourceBandleWrapper.getMessage("error.access.server"));
            return;
        }
        finally {
            this.after();
        }
    }

    public boolean isIntervalWait() {
        return this.intervalWait;
    }

    public void setIntervalWait(boolean bl) {
        this.intervalWait = bl;
    }

    private long increaseWaitTime() {
        long l = (long)Math.ceil((float)this.waitTime * this.increaseRate);
        if (l > 60000L) {
            l = 60000L;
        }
        return l;
    }

    protected void loadServerOutput(BufferedReader bufferedReader) throws IOException {
        String string;
        int n = 0;
        while ((string = bufferedReader.readLine()) != null && !this.isCanceled()) {
            this.setParameter(string);
            this.parseOutputString(n, string);
            ++n;
        }
    }

    @Override
    protected boolean setParameter(String string) {
        if (!ServerStatus.isParameter(string)) {
            return false;
        }
        if (super.setParameter(string)) {
            return true;
        }
        if (ServerStatus.isProgress(string)) {
            this.setProgress(ServerStatus.getProgressValue(string));
            return true;
        }
        return false;
    }

    protected int getProgress() {
        return this.progress;
    }

    private void setProgress(int n) {
        this.progress = n;
    }

    public void setIncreaseRate(float f) {
        this.increaseRate = f;
    }

    protected void beforeRunning() {
    }

    protected void cancel() {
    }
}

