/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.access;

import cgdp.recog.access.AbstractFileAccessExecuter;
import cgdp.recog.access.FileChooserFactory;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.domclust.AbstractDomClustExporter;
import cgdp.recog.domclust.DomClustTabExporter;
import cgdp.recog.filefilter.SingleFileFilter;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.util.FileUtil;
import java.awt.Cursor;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;

class ClustTabExportExecuter
extends AbstractFileAccessExecuter {
    private JFileChooser chooser = FileChooserFactory.createFileChooser(this.getAccessType(), null);
    private ClusterTbl clusterTbl;

    ClustTabExportExecuter(Frame frame, MediatorImpl mediatorImpl, ClusterTbl clusterTbl) {
        super(frame, mediatorImpl, null);
        this.clusterTbl = clusterTbl;
    }

    @Override
    int getAccessType() {
        return 101;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        if (this.chooser.showSaveDialog(this.parent) != 0) {
            return;
        }
        File file = this.chooser.getSelectedFile();
        SingleFileFilter singleFileFilter = (SingleFileFilter)this.chooser.getFileFilter();
        String string = singleFileFilter.modifiedExtension(file);
        if (!FileUtil.validateOverwrite(this.parent, string)) {
            return;
        }
        this.parent.setCursor(new Cursor(3));
        try {
            DomClustTabExporter domClustTabExporter = AbstractDomClustExporter.createDomClustTabExporter(string, this.clusterTbl.getFilepath(), this.clusterTbl.getViewClusterList(), this.clusterTbl.isOutgroup(), this.clusterTbl.getViewIngroupOrganismCodeList(), this.clusterTbl.getViewOutgroupOrganismCodeList());
            domClustTabExporter.execute();
        }
        finally {
            this.parent.setCursor(new Cursor(0));
        }
        optionValues.setUserImportDir(new File(string).getParent());
    }
}

