/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.access;

import cgdp.recog.access.AbstractFileAccessExecuter;
import cgdp.recog.access.FileChooserFactory;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.filefilter.FileFilterType;
import cgdp.recog.filefilter.SingleFileFilter;
import cgdp.recog.info.InfoTitleComparator;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.info.gene.GeneInfoUtil;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.set.gene.GeneSet;
import cgdp.recog.util.MapUtil;
import cgdp.recog.util.MessageManager;
import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.Cursor;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;

class GeneSetExportExecuter
extends AbstractFileAccessExecuter {
    private JFileChooser chooser;
    private GeneSet geneSet;
    private Map infoMap;
    private Map parameterMap;
    boolean simplemode = true;

    GeneSetExportExecuter(Frame frame, MediatorImpl mediatorImpl, GeneSet geneSet) {
        this(frame, mediatorImpl, geneSet, null, null);
    }

    GeneSetExportExecuter(Frame frame, MediatorImpl mediatorImpl, GeneSet geneSet, Map map, Map map2) {
        super(frame, mediatorImpl, null);
        this.geneSet = geneSet;
        this.infoMap = map;
        this.parameterMap = map2;
        this.chooser = FileChooserFactory.createFileChooser(this.getAccessType(), null);
    }

    @Override
    int getAccessType() {
        return 103;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        try {
            Serializable serializable;
            if (this.chooser.showSaveDialog(this.parent) != 0) {
                return;
            }
            this.parent.setCursor(new Cursor(3));
            File file = this.chooser.getSelectedFile();
            SingleFileFilter singleFileFilter = (SingleFileFilter)this.chooser.getFileFilter();
            String string = singleFileFilter.modifiedExtension(file);
            if (new File(string).isFile() && !MessageManager.showConfirmOverwriteMessage(this.parent, string)) {
                return;
            }
            List list = this.geneSet.getElementList();
            Map map = GeneInfoUtil.createOrganismCodeLocusTagListMap(list);
            if (FileFilterType.isExportGeneSet(singleFileFilter.getFilterType())) {
                this.geneSetExportSimple(string, map);
                return;
            }
            List list2 = GeneInfoFacade.getGeneInfoTitleList(map.keySet());
            list2.remove(GeneInfoTitle.TITLE_LOCUSTAG_SERVER);
            list2.remove(GeneInfoTitle.TITLE_ORGANISM_CODE);
            list2.add(0, GeneInfoTitle.TITLE_LOCUSTAG_SERVER);
            list2.add(0, GeneInfoTitle.TITLE_ORGANISM_CODE);
            list = GeneInfoFacade.getGeneInfoList(list, list2);
            if (!MapUtil.isNull(this.infoMap)) {
                serializable = new HashSet();
                for (GeneInfo geneInfo : list) {
                    GeneInfo geneInfo2 = (GeneInfo)this.infoMap.get(geneInfo.getKey());
                    if (geneInfo2 == null) continue;
                    geneInfo.putAllInfo(geneInfo2);
                    serializable.addAll(geneInfo2.getTitleSet());
                }
                ArrayList arrayList = new ArrayList(serializable);
                Collections.sort(arrayList, new InfoTitleComparator(2));
                list2.addAll(arrayList);
            }
            GeneInfoFacade.exportGeneInfoList(string, list, list2, this.parameterMap);
            serializable = OptionTbl.getInstance().getOptionValues();
            ((OptionValues)serializable).setUserImportDir(new File(string).getParent());
        }
        finally {
            this.parent.setCursor(new Cursor(0));
        }
    }

    private void geneSetExportSimple(String string, Map map) throws IOException {
        PrintWriter printWriter;
        File file = new File(string);
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        }
        catch (IOException iOException) {
            MessageManager.showWarningMessage(this.parent, "File open error: " + file.getPath());
            return;
        }
        for (String string2 : map.keySet()) {
            List list = (List)map.get(string2);
            for (String string3 : list) {
                printWriter.println(string2 + ":" + string3);
            }
        }
        printWriter.close();
    }
}

