/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.access;

import cgdp.recog.access.ImportMenuManager;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.util.JLicenserTool;
import cgdp.recog.util.PullDownMenuButton;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;

public class ImportTool
extends PullDownMenuButton
implements CommandImpl {
    private MediatorImpl mediator;
    private ImportMenuManager importMenuManager;

    public ImportTool(ActionListener actionListener, MediatorImpl mediatorImpl) {
        this.setToolTipText("Import");
        this.setMargin(new Insets(2, 2, 2, 2));
        try {
            this.setIcon(new ImageIcon(JLicenserTool.getResource("cgdp.recog.startup.Startup", "images/import.png")));
        }
        catch (Exception exception) {
            this.setText("0");
        }
        this.mediator = mediatorImpl;
        this.mediator.register(this);
        this.addActionListener(actionListener);
        this.importMenuManager = new ImportMenuManager(mediatorImpl);
        this.setMenuList(this.importMenuManager.getMenuList());
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.importMenuManager.setClusterTbl(clusterTbl);
    }

    @Override
    public void execute() {
        ImportMenuManager.ImportSubItem importSubItem = this.importMenuManager.getLastSelectItem();
        if (importSubItem != null && importSubItem.isEnabled()) {
            importSubItem.execute();
        } else {
            this.mediator.importer(1, null);
        }
    }
}

