/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.CoreGeneTargetCondition;
import cgdp.recog.align.GlobalAlign;
import cgdp.recog.align.GlobalAlignGenerater;
import cgdp.recog.align.GlobalAlignGroup;
import cgdp.recog.coregenome.GenomeAlign;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CoreGeneCreater
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(CoreGeneCreater.class);
    private GeneInfoTitle geneInfoTitle;
    private CoreGeneTargetCondition condition;
    private ClusterTbl clusterTbl;
    private GenomeAlign genomeAlign;
    private List globalAlignGroupList = new ArrayList();
    private List organismList;
    private Set targetOrganismCodeSet = new HashSet();
    private Map organismCodeGeneInfoListMap = new HashMap();

    public CoreGeneCreater(GeneInfoTitle geneInfoTitle, CoreGeneTargetCondition coreGeneTargetCondition, List list, GenomeAlign genomeAlign, ClusterTbl clusterTbl) {
        this.geneInfoTitle = geneInfoTitle;
        this.condition = coreGeneTargetCondition;
        this.organismList = list;
        this.genomeAlign = genomeAlign;
        this.clusterTbl = clusterTbl;
    }

    public CoreGeneCreater(GeneInfoTitle geneInfoTitle, CoreGeneTargetCondition coreGeneTargetCondition, List list, List list2, ClusterTbl clusterTbl) {
        this.geneInfoTitle = geneInfoTitle;
        this.condition = coreGeneTargetCondition;
        this.organismList = list;
        this.globalAlignGroupList = list2;
        this.clusterTbl = clusterTbl;
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        try {
            this.createGlobalAlignGroupList(progressImpl);
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            progressImpl.nextProc();
            progressImpl.setTotal(this.organismList.size());
            progressImpl.setCount(-1);
            progressImpl.increment();
            HashSet<String> hashSet = new HashSet<String>();
            HashMap hashMap = new HashMap();
            Iterator iterator = this.organismList.iterator();
            while (iterator.hasNext()) {
                Object object;
                if (progressImpl.isCanceled()) {
                    this.setCancel(true);
                    return;
                }
                progressImpl.increment();
                Organism organism = (Organism)iterator.next();
                String string = organism.getOrganismCode();
                List list = null;
                try {
                    list = GeneInfoFacade.getLocusTagList(string);
                }
                catch (Exception exception) {
                    object = "Fail to load core gene's property. " + string;
                    logger.warn((String)object, exception);
                    this.setError(true);
                    this.setErrorMessage((String)object);
                    return;
                }
                ArrayList arrayList = (ArrayList)hashMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    hashMap.put(string, arrayList);
                }
                object = new HashSet();
                for (GlobalAlignGroup globalAlignGroup : this.globalAlignGroupList) {
                    List list2 = globalAlignGroup.getLocusTagListWithoutDomain(string);
                    if (CollectionUtil.isNull(list2)) continue;
                    int n = 0;
                    if (this.condition.isMatch(globalAlignGroup)) {
                        n = 1;
                    }
                    this.addGeneInfo(string, list2, arrayList, n);
                    hashSet.add(string);
                    object.addAll(list2);
                }
                ArrayList arrayList2 = new ArrayList(list);
                arrayList2.removeAll((Collection<?>)object);
                this.addGeneInfo(string, arrayList2, arrayList, 0);
            }
            this.targetOrganismCodeSet = hashSet;
            this.organismCodeGeneInfoListMap = hashMap;
        }
        catch (Exception exception) {
            String string = "Fail to create the core gene's property.";
            this.setError(true);
            this.setErrorMessage(string);
            logger.warn(string, exception);
        }
    }

    private void createGlobalAlignGroupList(ProgressImpl progressImpl) throws Exception {
        if (!CollectionUtil.isNull(this.globalAlignGroupList)) {
            return;
        }
        if (this.clusterTbl == null || this.genomeAlign == null || this.organismList == null) {
            return;
        }
        GlobalAlignGenerater globalAlignGenerater = new GlobalAlignGenerater();
        globalAlignGenerater.setClusterTbl(this.clusterTbl);
        globalAlignGenerater.setGenomeAlign(this.genomeAlign);
        globalAlignGenerater.setOrganismList(this.organismList);
        globalAlignGenerater.setProgressImpl(progressImpl);
        globalAlignGenerater.execute();
        List list = OrganismUtil.getOrganismCodeList(this.organismList);
        GlobalAlign globalAlign = globalAlignGenerater.getGlobalAlign();
        globalAlign.updateAlignGroupStatus(list);
        this.globalAlignGroupList = globalAlign.getGlobalAlignGroupList();
    }

    private void addGeneInfo(String string, List list, List list2, int n) {
        for (String string2 : list) {
            GeneInfo geneInfo = new GeneInfo();
            geneInfo.putInfo(GeneInfoTitle.TITLE_LOCUSTAG_SERVER, string2);
            if (this.geneInfoTitle != null) {
                geneInfo.putInfo(this.geneInfoTitle, String.valueOf(n));
            }
            list2.add(geneInfo);
        }
    }

    public Set getTargetOrganismCodeSet() {
        return this.targetOrganismCodeSet;
    }

    public Map getOrganismCodeGeneInfoListMap() {
        return this.organismCodeGeneInfoListMap;
    }

    @Override
    public void done() {
    }
}

