/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.CoreGeneTargetCondition;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CoreGeneOptionPanel
extends JPanel
implements ActionListener {
    private JCheckBox coreCheckBox;
    private JCheckBox nonCoreCheckBox;
    private JCheckBox coreUniversalCheckBox;
    private JCheckBox coreOneToOneCheckBox;
    private JCheckBox nonCoreUniversalCheckBox;
    private JCheckBox nonCoreUniqueCheckBox;
    private JCheckBox nonCoreOneToOneCheckBox;

    CoreGeneOptionPanel() {
        this.createComponents();
    }

    private void createComponents() {
        this.coreCheckBox = new JCheckBox("Core genes");
        this.coreCheckBox.addActionListener(this);
        this.coreUniversalCheckBox = new JCheckBox("Universal Only");
        this.coreOneToOneCheckBox = new JCheckBox("1vs1 Only");
        this.nonCoreCheckBox = new JCheckBox("Non-Core genes");
        this.nonCoreCheckBox.addActionListener(this);
        this.nonCoreUniversalCheckBox = new JCheckBox("Universal Only");
        this.nonCoreUniqueCheckBox = new JCheckBox("Unique Only");
        this.nonCoreUniqueCheckBox.addActionListener(this);
        this.nonCoreOneToOneCheckBox = new JCheckBox("1vs1 Only");
        JLabel jLabel = new JLabel("(");
        JLabel jLabel2 = new JLabel(")");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.nonCoreCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 20, 2, 0), 0, 0));
        jPanel.add((Component)this.nonCoreUniqueCheckBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 0, 2, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.setBorder(BorderFactory.createTitledBorder("Target"));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.coreCheckBox, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.coreUniversalCheckBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 20, 2, 2), 0, 0));
        this.add((Component)this.coreOneToOneCheckBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.nonCoreUniversalCheckBox, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 20, 2, 2), 0, 0));
        this.add((Component)this.nonCoreOneToOneCheckBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
    }

    public void updateValue(CoreGeneTargetCondition coreGeneTargetCondition) {
        this.coreCheckBox.setSelected(coreGeneTargetCondition.isShowCore());
        this.coreUniversalCheckBox.setSelected(coreGeneTargetCondition.isShowCoreUniversal());
        this.coreOneToOneCheckBox.setSelected(coreGeneTargetCondition.isShowCoreOneToOne());
        this.nonCoreCheckBox.setSelected(coreGeneTargetCondition.isShowNonCore());
        this.nonCoreUniversalCheckBox.setSelected(coreGeneTargetCondition.isShowNonCoreUniversal());
        this.nonCoreOneToOneCheckBox.setSelected(coreGeneTargetCondition.isShowNonCoreOneToOne());
        this.nonCoreUniqueCheckBox.setSelected(coreGeneTargetCondition.isShowNonCoreUnique());
        this.setEnableDisplayElementParts();
    }

    private void setEnableDisplayElementParts() {
        if (this.coreCheckBox.isSelected()) {
            this.coreUniversalCheckBox.setEnabled(true);
            this.coreOneToOneCheckBox.setEnabled(true);
        } else {
            this.coreUniversalCheckBox.setEnabled(false);
            this.coreOneToOneCheckBox.setEnabled(false);
        }
        if (this.nonCoreCheckBox.isSelected()) {
            this.nonCoreUniqueCheckBox.setEnabled(true);
            if (!this.nonCoreUniqueCheckBox.isSelected()) {
                this.nonCoreUniversalCheckBox.setEnabled(true);
                this.nonCoreOneToOneCheckBox.setEnabled(true);
            } else {
                this.nonCoreUniversalCheckBox.setEnabled(false);
                this.nonCoreOneToOneCheckBox.setEnabled(false);
            }
        } else {
            this.nonCoreUniqueCheckBox.setEnabled(false);
            this.nonCoreUniversalCheckBox.setEnabled(false);
            this.nonCoreOneToOneCheckBox.setEnabled(false);
        }
    }

    public boolean isCore() {
        return this.coreCheckBox.isSelected();
    }

    public boolean isNonCore() {
        return this.nonCoreCheckBox.isSelected();
    }

    public boolean isExistTarget() {
        return this.isCore() || this.isNonCore();
    }

    public CoreGeneTargetCondition createCondition() {
        CoreGeneTargetCondition coreGeneTargetCondition = new CoreGeneTargetCondition();
        coreGeneTargetCondition.setShowCore(this.coreCheckBox.isSelected());
        coreGeneTargetCondition.setShowCoreOneToOne(this.coreOneToOneCheckBox.isSelected());
        coreGeneTargetCondition.setShowCoreUniversal(this.coreUniversalCheckBox.isSelected());
        coreGeneTargetCondition.setShowNonCore(this.nonCoreCheckBox.isSelected());
        coreGeneTargetCondition.setShowNonCoreOneToOne(this.nonCoreOneToOneCheckBox.isSelected());
        coreGeneTargetCondition.setShowNonCoreUnique(this.nonCoreUniqueCheckBox.isSelected());
        coreGeneTargetCondition.setShowNonCoreUniversal(this.nonCoreUniversalCheckBox.isSelected());
        return coreGeneTargetCondition;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.coreCheckBox || actionEvent.getSource() == this.nonCoreCheckBox || actionEvent.getSource() == this.nonCoreUniqueCheckBox) {
            this.setEnableDisplayElementParts();
        }
    }
}

