/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.CoreGeneOptionPanel;
import cgdp.recog.align.CoreGeneTargetCondition;
import cgdp.recog.info.LocationComboBox;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.info.gene.GeneInfoUtil;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import javax.swing.JLabel;

public class CoreGenePropertyDialog
extends AbstractApplyDialog {
    private static final ApplicationLogger logger = new ApplicationLogger(CoreGenePropertyDialog.class);
    private static final String TITLE = "Register gene property";
    private static final String DEFAULT_NAME_PREFIX = "Core gene";
    private FocusTextField nameTextField;
    private LocationComboBox locationComboBox;
    private CoreGeneOptionPanel coreGeneOptionPanel;
    private GeneInfoTitle templateGeneInfoTitle;

    private CoreGenePropertyDialog(Frame frame) {
        super(frame);
        this.createComponents();
    }

    public CoreGenePropertyDialog(Dialog dialog) {
        super(dialog);
        this.createComponents();
    }

    public static CoreGenePropertyDialog getInstance(Component component) {
        if (component instanceof Frame) {
            return new CoreGenePropertyDialog((Frame)component);
        }
        if (component instanceof Dialog) {
            return new CoreGenePropertyDialog((Dialog)component);
        }
        return null;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(true);
        JLabel jLabel = new JLabel("Name");
        this.nameTextField = new FocusTextField(30);
        JLabel jLabel2 = new JLabel("Location");
        this.locationComboBox = new LocationComboBox();
        this.coreGeneOptionPanel = new CoreGeneOptionPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.nameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(10, 0, 0, 15), 0, 0));
        this.getContentPane().add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.locationComboBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(10, 0, 5, 15), 0, 0));
        this.getContentPane().add((Component)this.coreGeneOptionPanel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 15, 0, 15), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 0, new Insets(10, 15, 10, 15), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void updateValue(GeneInfoTitle geneInfoTitle, String string) {
        CoreGeneTargetCondition coreGeneTargetCondition = new CoreGeneTargetCondition();
        ApplicationPropertyFacade.updateAccessable(coreGeneTargetCondition);
        this.coreGeneOptionPanel.updateValue(coreGeneTargetCondition);
        this.templateGeneInfoTitle = geneInfoTitle;
        this.nameTextField.setText(GeneInfoUtil.getDefaultGeneInfoTitleName(DEFAULT_NAME_PREFIX));
        this.locationComboBox.updateLocationConboBox();
        this.locationComboBox.setSelectedItem(string);
    }

    private String getPropertyName() {
        return this.nameTextField.getText();
    }

    private String getLocationString() {
        return this.locationComboBox.getLocationString();
    }

    public GeneInfoTitle getGeneInfoTitle() {
        GeneInfoTitle geneInfoTitle = GeneInfoFacade.getGeneInfoTitle(this.getPropertyName());
        if (geneInfoTitle != null) {
            return geneInfoTitle;
        }
        String string = this.getPropertyName();
        this.templateGeneInfoTitle.setName(string);
        this.templateGeneInfoTitle.setKey(string);
        this.templateGeneInfoTitle.setLocationName(this.getLocationString());
        return this.templateGeneInfoTitle;
    }

    public CoreGeneTargetCondition createCondition() {
        return this.coreGeneOptionPanel.createCondition();
    }

    @Override
    protected boolean check() {
        Object[] objectArray;
        if (StringTool.isNull(this.getPropertyName())) {
            MessageManager.showErrorMessage((Component)this, "Input name.");
            return false;
        }
        GeneInfoTitle geneInfoTitle = GeneInfoFacade.getGeneInfoTitle(this.getPropertyName());
        if (geneInfoTitle != null && !MessageManager.showConfirmMessage((Component)this, objectArray = new String[]{"You have already made gene property [" + this.getPropertyName() + "].", "Overwrite the gene property [" + this.getPropertyName() + "]?"})) {
            return false;
        }
        if (!this.coreGeneOptionPanel.isExistTarget()) {
            MessageManager.showErrorMessage((Component)this, "Select core genes or non-core genes.");
            return false;
        }
        return true;
    }

    @Override
    protected boolean apply() {
        return true;
    }

    @Override
    protected void exit() {
        try {
            CoreGeneTargetCondition coreGeneTargetCondition = this.createCondition();
            ApplicationPropertyFacade.saveProperty(coreGeneTargetCondition);
        }
        catch (IOException iOException) {
            String string = "Fail to save the condition generated the core gene property.";
            logger.warn(string, iOException);
        }
        super.exit();
    }
}

