/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.CoreGeneOptionPanel;
import cgdp.recog.align.CoreGeneTargetCondition;
import cgdp.recog.info.LocationComboBox;
import cgdp.recog.set.SetComboBox;
import cgdp.recog.set.gene.GeneSet;
import cgdp.recog.set.gene.GeneSetFacade;
import cgdp.recog.set.gene.GeneSetRegistHelper;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.OverwriteAddOptionPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.List;
import javax.swing.JLabel;

public class CoreGeneSetAddDialog
extends AbstractApplyDialog
implements ItemListener {
    private static final ApplicationLogger logger = new ApplicationLogger(CoreGeneSetAddDialog.class);
    private static final String TITLE = "Register gene set";
    private SetComboBox setComboBox;
    private LocationComboBox locationComboBox;
    private OverwriteAddOptionPanel overwriteAddOptionPanel;
    private CoreGeneOptionPanel coreGeneOptionPanel;
    private GeneSetRegistHelper geneSetRegisterHelper;

    protected CoreGeneSetAddDialog(Dialog dialog) {
        super(dialog);
        this.geneSetRegisterHelper = new GeneSetRegistHelper(dialog);
        this.createComponents();
    }

    protected CoreGeneSetAddDialog(Frame frame) {
        super(frame);
        this.geneSetRegisterHelper = new GeneSetRegistHelper(frame);
        this.createComponents();
    }

    public static CoreGeneSetAddDialog getInstanse(Component component) {
        if (component instanceof Dialog) {
            return new CoreGeneSetAddDialog((Dialog)component);
        }
        if (component instanceof Frame) {
            return new CoreGeneSetAddDialog((Frame)component);
        }
        return null;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(true);
        JLabel jLabel = new JLabel("Name");
        this.setComboBox = new SetComboBox();
        this.setComboBox.setEditable(true);
        JLabel jLabel2 = new JLabel("Location");
        this.locationComboBox = new LocationComboBox();
        this.locationComboBox.addItemListener(this);
        this.overwriteAddOptionPanel = new OverwriteAddOptionPanel();
        this.coreGeneOptionPanel = new CoreGeneOptionPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.setComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(10, 0, 0, 15), 0, 0));
        this.getContentPane().add((Component)jLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.locationComboBox, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(10, 0, 5, 15), 0, 0));
        this.getContentPane().add((Component)this.overwriteAddOptionPanel, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 15), 0, 0));
        this.getContentPane().add((Component)this.coreGeneOptionPanel, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 15, 0, 15), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 10, 0, new Insets(10, 15, 15, 15), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void updateValue(String string) {
        CoreGeneTargetCondition coreGeneTargetCondition = new CoreGeneTargetCondition();
        ApplicationPropertyFacade.updateAccessable(coreGeneTargetCondition);
        this.coreGeneOptionPanel.updateValue(coreGeneTargetCondition);
        this.locationComboBox.updateLocationConboBox();
        this.locationComboBox.setSelectedItem(string);
        this.updateSetNameComboBox();
        this.overwriteAddOptionPanel.updateValue(2);
    }

    private String getSetName() {
        return this.setComboBox.getSelectedSetName();
    }

    private String getLocationString() {
        return this.locationComboBox.getLocationString();
    }

    private boolean isOverwrite() {
        return this.overwriteAddOptionPanel.isOverwrite();
    }

    public CoreGeneTargetCondition createCondition() {
        return this.coreGeneOptionPanel.createCondition();
    }

    public GeneSet createGeneSet() {
        GeneSet geneSet = (GeneSet)this.setComboBox.getSelectedElementSet();
        return this.geneSetRegisterHelper.createGeneSet(this.getSetName(), this.getLocationString(), this.isOverwrite(), geneSet);
    }

    @Override
    protected boolean check() {
        GeneSet geneSet = this.createGeneSet();
        return this.geneSetRegisterHelper.validateGeneSet(geneSet, this.isOverwrite());
    }

    @Override
    protected boolean apply() {
        return true;
    }

    private void updateSetNameComboBox() {
        String string = this.getLocationString();
        List list = GeneSetFacade.getInstance().getGeneSetListGlobalAndSameLocation(string);
        this.setComboBox.updateValue(list);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.locationComboBox) {
            this.updateSetNameComboBox();
        }
    }

    @Override
    protected void exit() {
        try {
            CoreGeneTargetCondition coreGeneTargetCondition = this.createCondition();
            ApplicationPropertyFacade.saveProperty(coreGeneTargetCondition);
        }
        catch (IOException iOException) {
            String string = "Fail to save the condition generated the core gene property.";
            logger.warn(string, iOException);
        }
        super.exit();
    }
}

