/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.GlobalAlignGroup;
import cgdp.recog.coregenome.OrthologGroup;
import cgdp.recog.data.Chromosome;
import cgdp.recog.organism.Organism;
import cgdp.recog.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class GlobalAlign {
    private List organismList = new ArrayList();
    private Map organismGenomeLengthMap = new HashMap();
    private Map chromosomeOrderMap = new HashMap();
    private List globalAlignGroupList = new ArrayList();
    private Map clusterIdGlobalAlignMap = new HashMap();

    GlobalAlign() {
    }

    List getGlobalAlignGroupList() {
        return this.globalAlignGroupList;
    }

    void setGlobalAlignGroupList(List list) {
        this.globalAlignGroupList = list;
        this.updateClusterIdGlobalAlignMap();
    }

    private void updateClusterIdGlobalAlignMap() {
        HashMap<String, ArrayList<GlobalAlignGroup>> hashMap = new HashMap<String, ArrayList<GlobalAlignGroup>>();
        for (GlobalAlignGroup globalAlignGroup : this.globalAlignGroupList) {
            if (!globalAlignGroup.isCore() && !globalAlignGroup.isNonCore() || !globalAlignGroup.isExistCluster()) continue;
            String string = globalAlignGroup.getConbineClusterId();
            ArrayList<GlobalAlignGroup> arrayList = (ArrayList<GlobalAlignGroup>)hashMap.get(string);
            if (CollectionUtil.isNull(arrayList)) {
                arrayList = new ArrayList<GlobalAlignGroup>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(globalAlignGroup);
        }
        this.clusterIdGlobalAlignMap.clear();
        this.clusterIdGlobalAlignMap = hashMap;
    }

    List getOrganismList() {
        return this.organismList;
    }

    void setOrganismList(List list) {
        this.organismList = list;
    }

    void setOrganismGenomeLengthMap(Map map) {
        this.organismGenomeLengthMap = map;
    }

    void setChromosomeOrderMap(Map map) {
        this.chromosomeOrderMap = map;
    }

    int getChromosomeStartPosition(String string, int n) {
        double d = 0.0;
        List list = this.getChromosomeList(string);
        Chromosome chromosome = this.getMainChromosome(string);
        if (chromosome.isCircular()) {
            Chromosome chromosome2;
            for (int i = 0; i < list.size() && (chromosome2 = (Chromosome)list.get(i)).getId() != n; ++i) {
                if (i == 0) {
                    d += (double)chromosome2.getLength() / 2.0;
                    continue;
                }
                d += (double)chromosome2.getLength();
            }
        } else {
            Chromosome chromosome3;
            for (int i = 0; i < list.size() && (chromosome3 = (Chromosome)list.get(i)).getId() != n; ++i) {
                d += (double)chromosome3.getLength();
            }
        }
        return (int)d;
    }

    List getChromosomeList(String string) {
        return (List)this.chromosomeOrderMap.get(string);
    }

    Chromosome getMainChromosome(String string) {
        List list = this.getChromosomeList(string);
        return (Chromosome)list.get(0);
    }

    boolean isMainChromosome(String string, int n) {
        Chromosome chromosome = this.getMainChromosome(string);
        return chromosome.equalsChromId(n);
    }

    double getMaxChromosomeLength() {
        int n = -1;
        Iterator iterator = this.organismGenomeLengthMap.values().iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            n = Math.max(n, n2);
        }
        return n;
    }

    int getAllChromosomeLengthByOrganism(String string) {
        Integer n = (Integer)this.organismGenomeLengthMap.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    int getChromosomeLengthByChromId(String string, int n) {
        Chromosome chromosome = this.getChromosome(string, n);
        if (chromosome != null) {
            return chromosome.getLength();
        }
        return -1;
    }

    Chromosome getChromosome(String string, int n) {
        List list = this.getChromosomeList(string);
        for (Chromosome chromosome : list) {
            if (chromosome.getId() != n) continue;
            return chromosome;
        }
        return null;
    }

    public static Map createGlobalAlignElementMap(List list, List list2) {
        HashMap hashMap = new HashMap();
        for (Organism organism : list) {
            ArrayList arrayList = new ArrayList();
            for (GlobalAlignGroup globalAlignGroup : list2) {
                arrayList.addAll(globalAlignGroup.getAlignElementList(organism.getOrganismCode()));
            }
            hashMap.put(organism.getOrganismCode(), arrayList);
        }
        return hashMap;
    }

    Set getGlobalAlignGroupSet(String string) {
        HashSet<GlobalAlignGroup> hashSet = new HashSet<GlobalAlignGroup>();
        for (GlobalAlignGroup globalAlignGroup : this.globalAlignGroupList) {
            if (!globalAlignGroup.isCore() || !globalAlignGroup.getOrthologGroupId().equals(string)) continue;
            hashSet.add(globalAlignGroup);
        }
        return hashSet;
    }

    void changeChromosomePosition(String string, int n) {
        boolean bl = false;
        List list = this.getChromosomeList(string);
        ArrayList<Chromosome> arrayList = new ArrayList<Chromosome>();
        ArrayList<Chromosome> arrayList2 = new ArrayList<Chromosome>();
        for (Chromosome chromosome : list) {
            if (chromosome.getId() == n || bl) {
                arrayList.add(chromosome);
                bl = true;
                continue;
            }
            arrayList2.add(chromosome);
        }
        arrayList.addAll(arrayList2);
        this.chromosomeOrderMap.put(string, arrayList);
    }

    void updateAlignGroupStatus(Collection collection) {
        for (GlobalAlignGroup globalAlignGroup : this.getGlobalAlignGroupList()) {
            globalAlignGroup.updateStatus(collection);
        }
    }

    Set getOrthologGroupSetByCluster(Set set) {
        HashSet<OrthologGroup> hashSet = new HashSet<OrthologGroup>();
        for (String string : set) {
            List list = (List)this.clusterIdGlobalAlignMap.get(string);
            if (CollectionUtil.isNull(list)) continue;
            for (GlobalAlignGroup globalAlignGroup : list) {
                hashSet.add(globalAlignGroup.getOrthologGroup());
            }
        }
        return hashSet;
    }

    public Set getCoreOrthologGroupSet() {
        HashSet<OrthologGroup> hashSet = new HashSet<OrthologGroup>();
        for (GlobalAlignGroup globalAlignGroup : this.getGlobalAlignGroupList()) {
            if (!globalAlignGroup.isCore()) continue;
            hashSet.add(globalAlignGroup.getOrthologGroup());
        }
        return hashSet;
    }

    Set getGlobalAlignGroupSetByCluster(Set set) {
        HashSet hashSet = new HashSet();
        for (String string : set) {
            List list = (List)this.clusterIdGlobalAlignMap.get(string);
            if (CollectionUtil.isNull(list)) continue;
            hashSet.addAll(list);
        }
        return hashSet;
    }
}

