/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.DirArrangeType;
import cgdp.recog.align.GlobalAlignViewModel;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.util.TabPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class GlobalAlignArrangeOptionPanel
extends TabPanel {
    private MediatorImpl mediator;
    private GlobalAlignViewModel globalAlignViewModel;
    private JRadioButton dirPosButton;
    private JRadioButton dirConsensusButton;
    private JRadioButton dirRefButton;

    GlobalAlignArrangeOptionPanel(Component component, MediatorImpl mediatorImpl, GlobalAlignViewModel globalAlignViewModel) {
        super(component);
        this.mediator = mediatorImpl;
        this.globalAlignViewModel = globalAlignViewModel;
        this.createComponents();
    }

    private void createComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.createGeneArrangePanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 10, 10, 10), 0, 0));
        this.updateValue();
    }

    private JPanel createGeneArrangePanel() {
        this.dirPosButton = new JRadioButton("Arranged in the positive direction");
        this.dirConsensusButton = new JRadioButton("Arranged in the consensus direction of the core genome");
        this.dirRefButton = new JRadioButton("Arranged in the direction of the reference genome");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.dirPosButton);
        buttonGroup.add(this.dirConsensusButton);
        buttonGroup.add(this.dirRefButton);
        this.dirRefButton.setSelected(true);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Arrangement of orthologous genes"));
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.dirPosButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)this.dirConsensusButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)this.dirRefButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        return jPanel;
    }

    private void updateValue() {
        this.updateValue(this.globalAlignViewModel);
    }

    private void updateValue(GlobalAlignViewModel globalAlignViewModel) {
        this.updateValueDirArrange(globalAlignViewModel.getDirArrangeType());
    }

    private void updateValueDirArrange(int n) {
        if (DirArrangeType.isPositive(n)) {
            this.dirPosButton.setSelected(true);
        } else if (DirArrangeType.isConsensusOrtholog(n)) {
            this.dirConsensusButton.setSelected(true);
        } else {
            this.dirRefButton.setSelected(true);
        }
    }

    private int getDirArrangeType() {
        int n = 3;
        if (this.dirPosButton.isSelected()) {
            n = 1;
        } else if (this.dirConsensusButton.isSelected()) {
            n = 2;
        }
        return n;
    }

    @Override
    protected void changeDefault() {
        GlobalAlignViewModel globalAlignViewModel = new GlobalAlignViewModel();
        this.updateValue(globalAlignViewModel);
    }

    @Override
    public boolean check() {
        return true;
    }

    @Override
    protected void updateParameters() {
        this.globalAlignViewModel.setDirArrangeType(this.getDirArrangeType());
    }
}

