/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.GlobalAlignGroup;
import cgdp.recog.align.GlobalAlignRange;
import cgdp.recog.align.GlobalAlignViewModel;
import cgdp.recog.organism.Organism;
import cgdp.recog.util.GeneDirection;
import cgdp.recog.util.GeneUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class GlobalAlignElement {
    private GlobalAlignGroup globalAlignGroup;
    private String locusTag;
    private Organism organism;
    private int start;
    private int end;
    private double position;
    private GeneDirection geneDirection = new GeneDirection();
    private int chromID;
    private boolean showArrow = true;
    private List locationList = new ArrayList();
    private double viewPosition;

    GlobalAlignElement() {
    }

    public String getLocusTag() {
        return this.locusTag;
    }

    public String getLocusTagWithoutDomain() {
        return GeneUtil.removeDomainNo(this.getLocusTag());
    }

    public void setLocusTag(String string) {
        this.locusTag = string;
    }

    public Organism getOrganism() {
        return this.organism;
    }

    public String getOrganismCode() {
        return this.getOrganism().getOrganismCode();
    }

    public void setOrganism(Organism organism) {
        this.organism = organism;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int n) {
        this.start = n;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int n) {
        this.end = n;
    }

    public double getPosition() {
        return this.position;
    }

    public void setPosition(double d) {
        this.position = d;
    }

    public int getLength() {
        return this.getEnd() - this.getStart();
    }

    public List getLocationList() {
        return this.locationList;
    }

    public boolean isExon() {
        return !this.getLocationList().isEmpty();
    }

    public void setLocationList(List list) {
        this.locationList = list;
    }

    private GeneDirection getGeneDirection() {
        return this.geneDirection;
    }

    public void setGeneDirection(short s) {
        this.geneDirection.setDirection(s);
    }

    public boolean isDomain() {
        return GeneUtil.isDomain(this.getLocusTag());
    }

    public GlobalAlignGroup getGlobalAlignGroup() {
        return this.globalAlignGroup;
    }

    public void setGlobalAlignGroup(GlobalAlignGroup globalAlignGroup) {
        this.globalAlignGroup = globalAlignGroup;
    }

    public boolean isCore() {
        return this.globalAlignGroup.isCore();
    }

    public boolean isNonCore() {
        return this.globalAlignGroup.isNonCore();
    }

    public int getChromID() {
        return this.chromID;
    }

    public void setChromID(int n) {
        this.chromID = n;
    }

    public boolean isShowArrow() {
        return this.showArrow;
    }

    public void setShowArrow(boolean bl) {
        this.showArrow = bl;
    }

    public boolean isPositive() {
        return this.getGeneDirection().isPositive();
    }

    public boolean isNegative() {
        return this.getGeneDirection().isNegative();
    }

    public double getViewPosition() {
        return this.viewPosition;
    }

    public void setViewPosition(double d) {
        this.viewPosition = d;
    }

    public boolean equalsDirection(GlobalAlignElement globalAlignElement) {
        return globalAlignElement.getGeneDirection().equalsDirection(this.getGeneDirection());
    }

    public boolean equalsDirection(int n) {
        return this.getGeneDirection().equalsDirection(n);
    }

    List getAdjustReverseLocationList(GlobalAlignViewModel globalAlignViewModel) {
        ArrayList<GlobalAlignRange> arrayList = new ArrayList<GlobalAlignRange>();
        if (globalAlignViewModel.containsReverseChromId(this.getChromID())) {
            int n = Math.abs(this.getEnd() - this.getStart());
            for (GlobalAlignRange globalAlignRange : this.getLocationList()) {
                GlobalAlignRange globalAlignRange2 = new GlobalAlignRange(n - globalAlignRange.getX2(), n - globalAlignRange.getX1(), this);
                arrayList.add(globalAlignRange2);
            }
            Collections.reverse(arrayList);
        } else {
            arrayList.addAll(this.getLocationList());
        }
        return arrayList;
    }
}

