/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.GlobalAlignContext;
import cgdp.recog.align.GlobalAlignElement;
import cgdp.recog.align.GlobalAlignPositionManager;
import cgdp.recog.align.GlobalAlignViewModel;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismViewModel;
import cgdp.recog.util.ApplicationLogger;
import java.util.List;

abstract class GlobalAlignElementLoopExecuter {
    private static final ApplicationLogger logger = new ApplicationLogger(GlobalAlignElementLoopExecuter.class);
    private GlobalAlignPositionManager globalAlignPositionManager;
    private double offsetGenomeLineStartX;

    GlobalAlignElementLoopExecuter(GlobalAlignPositionManager globalAlignPositionManager) {
        this.globalAlignPositionManager = globalAlignPositionManager;
        this.init();
    }

    protected void init() {
    }

    void execute() {
        double d = this.globalAlignPositionManager.getDrawLimitRight() + this.getOffsetGenomeLineStartX();
        double d2 = this.globalAlignPositionManager.getDrawLimitLeft() + this.getOffsetGenomeLineStartX();
        List list = this.getOrganismViewModel().getViewOrganismList();
        long l = System.currentTimeMillis();
        for (Organism organism : list) {
            double d3 = this.globalAlignPositionManager.getGenomeLineStartX(organism.getOrganismCode()) + this.getOffsetGenomeLineStartX();
            List list2 = this.getGlobalAlignViewModel().getViewGlobalAlignElementList(organism.getOrganismCode());
            this.beforeGlobalAlignElement(organism);
            for (GlobalAlignElement globalAlignElement : list2) {
                double d4 = globalAlignElement.getViewPosition();
                int n = (int)(d3 + this.getGlobalAlignContext().calcX(d4 - (double)globalAlignElement.getLength() / 2.0));
                int n2 = (int)(d3 + this.getGlobalAlignContext().calcX(d4 + (double)globalAlignElement.getLength() / 2.0));
                if (!GlobalAlignPositionManager.containsRange(n, d2, d) && !GlobalAlignPositionManager.containsRange(n2, d2, d)) continue;
                this.loopGlobalAlignElement(globalAlignElement, n, n2);
            }
            this.afterGlobalAlignElement(organism);
        }
        long l2 = System.currentTimeMillis();
    }

    protected void beforeGlobalAlignElement(Organism organism) {
    }

    protected abstract boolean loopGlobalAlignElement(GlobalAlignElement var1, int var2, int var3);

    protected void afterGlobalAlignElement(Organism organism) {
    }

    private double getOffsetGenomeLineStartX() {
        return this.offsetGenomeLineStartX;
    }

    void setOffsetGenomeLineStartX(double d) {
        this.offsetGenomeLineStartX = d;
    }

    private OrganismViewModel getOrganismViewModel() {
        return this.globalAlignPositionManager.getOrganismViewModel();
    }

    private GlobalAlignViewModel getGlobalAlignViewModel() {
        return this.globalAlignPositionManager.getGlobalAlignViewModel();
    }

    private GlobalAlignContext getGlobalAlignContext() {
        return this.globalAlignPositionManager.getGlobalAlignContext();
    }

    public GlobalAlignPositionManager getGlobalAlignPositionManager() {
        return this.globalAlignPositionManager;
    }
}

