/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.GlobalAlignContext;
import cgdp.recog.align.GlobalAlignPositionManager;
import cgdp.recog.align.GlobalAlignViewModel;
import cgdp.recog.align.ScaleBpUnit;
import cgdp.recog.data.Chromosome;
import cgdp.recog.organism.Organism;
import cgdp.recog.util.Range;
import cgdp.recog.util.axis.TickUnitUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;

class GlobalAlignScaleRenderer {
    private static final Color SCALE_COLOR = Color.black;
    private static final int SPLIT_SCALE_COUNT_FOR_CENTER = 8;
    private static final int SPLIT_SCALE_COUNT_FOR_REF = 8;
    private GlobalAlignViewModel globalAlignViewModel;
    private GlobalAlignContext globalAlignContext;
    private GlobalAlignPositionManager globalAlignPositionManager;

    GlobalAlignScaleRenderer(GlobalAlignViewModel globalAlignViewModel, GlobalAlignContext globalAlignContext, GlobalAlignPositionManager globalAlignPositionManager) {
        this.globalAlignViewModel = globalAlignViewModel;
        this.globalAlignContext = globalAlignContext;
        this.globalAlignPositionManager = globalAlignPositionManager;
    }

    void draw(Graphics2D graphics2D) {
        if (this.globalAlignViewModel.isScaleCenter()) {
            this.drawScaleRelativeCenter(graphics2D);
        } else {
            this.drawScaleReferenceGenome(graphics2D);
        }
    }

    private void drawScaleRelativeCenter(Graphics2D graphics2D) {
        graphics2D.setColor(SCALE_COLOR);
        double d = this.globalAlignPositionManager.getScaleLength();
        int n = this.globalAlignPositionManager.getDrawGenomeLength();
        double d2 = TickUnitUtil.getScaleUnit(n / 8);
        int n2 = (int)Math.ceil(d / d2);
        ScaleBpUnit scaleBpUnit = new ScaleBpUnit(d2);
        double d3 = scaleBpUnit.getUnitConversion();
        String string = scaleBpUnit.getUnitLabel();
        double d4 = this.globalAlignContext.calcGenomeLineWidth(d);
        double d5 = this.globalAlignContext.calcGenomeLineWidth(d2);
        double d6 = (this.globalAlignContext.getAlignDrawWidth() - d4) / 2.0;
        double d7 = this.globalAlignContext.getMarginLeft() + this.globalAlignContext.getOrganismNameWidth() + this.globalAlignContext.getOrganismIntervalX() + d6;
        double d8 = d7 + d4;
        double d9 = d7 + d4 / 2.0;
        double d10 = this.globalAlignContext.getAlignStartX();
        double d11 = this.globalAlignContext.getDrawWidth();
        double d12 = GlobalAlignPositionManager.adjustPointForIncludeDrawArea(d7, d10, d11);
        double d13 = GlobalAlignPositionManager.adjustPointForIncludeDrawArea(d8, d10, d11);
        double d14 = this.globalAlignContext.getScaleStartY();
        graphics2D.drawLine((int)d12, (int)d14, (int)d13, (int)d14);
        double d15 = d14 - this.globalAlignContext.getScaleHeight() - 1.0;
        if (GlobalAlignPositionManager.containsRange(d9, d10, d11)) {
            graphics2D.drawString("0", (int)d9, (int)d15);
            graphics2D.drawLine((int)d9, (int)d14, (int)d9, (int)(d14 - this.globalAlignContext.getScaleHeight()));
        }
        int n3 = 0;
        int n4 = 0;
        for (int i = 1; i <= n2 / 2; ++i) {
            double d16 = d9 + d5 * (double)i;
            if (GlobalAlignPositionManager.containsRange(d16, d10, d11)) {
                graphics2D.drawString(String.valueOf(d2 * (double)i / d3), (int)d16, (int)d15);
                graphics2D.drawLine((int)d16, (int)d14, (int)d16, (int)(d14 - this.globalAlignContext.getScaleHeight()));
                n3 = 1;
            } else if (n3 == 1 || n4 == 1) {
                n3 = 2;
            }
            d16 = d9 - d5 * (double)i;
            if (GlobalAlignPositionManager.containsRange(d16, d10, d11)) {
                graphics2D.drawString(String.valueOf(d2 * (double)i * -1.0 / d3), (int)d16, (int)d15);
                graphics2D.drawLine((int)d16, (int)d14, (int)d16, (int)(d14 - this.globalAlignContext.getScaleHeight()));
                n4 = 1;
            } else if (n4 == 1 || n3 == 1) {
                n4 = 2;
            }
            if (n3 == 2 && n4 == 2) break;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n5 = fontMetrics.stringWidth(string);
        graphics2D.drawString(string, (int)(this.globalAlignContext.getAlignStartX() - (double)n5), (int)d14);
    }

    private void drawScaleReferenceGenome(Graphics2D graphics2D) {
        double d;
        graphics2D.setColor(SCALE_COLOR);
        int n = this.globalAlignPositionManager.getDrawGenomeLength();
        double d2 = TickUnitUtil.getScaleUnit(n / 8);
        ScaleBpUnit scaleBpUnit = new ScaleBpUnit(d2);
        double d3 = scaleBpUnit.getUnitConversion();
        String string = scaleBpUnit.getUnitLabel();
        double d4 = this.globalAlignContext.calcGenomeLineWidth(d2);
        Organism organism = this.globalAlignViewModel.getReferenceOrganism();
        Chromosome chromosome = this.globalAlignViewModel.getGlobalAlign().getMainChromosome(organism.getOrganismCode());
        Range range = this.globalAlignPositionManager.getViewRange(organism.getOrganismCode());
        double d5 = this.globalAlignContext.getMarginLeft() + this.globalAlignContext.getOrganismNameWidth() + this.globalAlignContext.getOrganismIntervalX();
        double d6 = this.globalAlignContext.getAlignDrawWidth();
        double d7 = this.globalAlignContext.calcX(chromosome.getLength());
        double d8 = d5;
        double d9 = this.globalAlignContext.getDrawWidth();
        double d10 = this.getScaleStartPosition(range, d2, chromosome.getId());
        double d11 = this.globalAlignContext.calcX(-1.0 * Math.abs(d10 - (double)range.getX1())) + d5;
        if (d6 > d7) {
            d = (d6 - d7) / 2.0;
            d8 += d;
            d9 -= d + this.globalAlignContext.getMarginRight();
        }
        d = this.globalAlignContext.getScaleStartY();
        graphics2D.drawLine((int)d8, (int)d, (int)d9, (int)d);
        double d12 = d - this.globalAlignContext.getScaleHeight() - 1.0;
        double d13 = d11;
        double d14 = d10;
        double d15 = this.getScaleLabelIntervalLength(d2, chromosome.getId());
        int n2 = 0;
        while (d13 <= d9) {
            if (d13 < d8 || d13 > d9) {
                d14 += d15;
                d13 += d4;
                ++n2;
                continue;
            }
            if (d14 >= (double)chromosome.getLength()) {
                d13 -= this.globalAlignContext.calcX(d14 - (double)chromosome.getLength());
                d14 = 1.0;
                if (d3 == 1.0) {
                    graphics2D.drawString(String.valueOf(d14 / d3), (int)d13, (int)d12);
                }
                graphics2D.drawLine((int)d13, (int)d, (int)d13, (int)(d - this.globalAlignContext.getScaleHeight()));
                d13 += d4;
                d14 = d15;
            }
            graphics2D.drawString(String.valueOf(d14 / d3), (int)d13, (int)d12);
            graphics2D.drawLine((int)d13, (int)d, (int)d13, (int)(d - this.globalAlignContext.getScaleHeight()));
            d14 += d15;
            d13 += d4;
            ++n2;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.stringWidth(string);
        graphics2D.drawString(string, (int)(this.globalAlignContext.getAlignStartX() - (double)n3), (int)d);
    }

    private double getScaleStartPosition(Range range, double d, int n) {
        double d2 = this.globalAlignViewModel.isReverseGenome(n) ? (double)range.getX1() + (d - (double)range.getX1() % d) : (double)range.getX1() - (double)range.getX1() % d;
        return d2;
    }

    private double getScaleLabelIntervalLength(double d, int n) {
        double d2 = d;
        if (this.globalAlignViewModel.isReverseGenome(n)) {
            d2 *= -1.0;
        }
        return d2;
    }
}

