/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import java.awt.Color;

public class GradientColor
implements Cloneable {
    private double interval = 0.1;
    private double rc = 255.0;
    private double gc = 0.0;
    private double bc = 0.0;
    private int colorFlag = 1;

    public void initColor(int n) {
        this.rc = 255.0;
        this.gc = 0.0;
        this.bc = 0.0;
        this.colorFlag = 1;
        double d = 506.0 / (double)n;
        this.setInterval(d);
    }

    public void setInterval(double d) {
        this.interval = d;
    }

    public double getInterval() {
        return this.interval;
    }

    public Color getGradientColor() {
        Color color = new Color((int)this.rc, (int)this.gc, (int)this.bc);
        this.updateColorComponents();
        return color;
    }

    private void updateColorComponents() {
        switch (this.colorFlag) {
            case 1: {
                this.gc += this.getInterval();
                if (!(this.gc >= 254.0 - this.getInterval())) break;
                this.colorFlag = 2;
                break;
            }
            case 2: {
                this.rc -= this.getInterval();
                if (!(this.rc <= this.getInterval() + 1.0)) break;
                this.colorFlag = 3;
                break;
            }
            case 3: {
                this.rc = 0.0;
                this.gc = 0.0;
                this.bc = 0.0;
            }
        }
    }

    public static Color getColor(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 510.0 * d;
        if (d5 < 256.0) {
            d2 = 255.0;
            d3 = d5;
            d4 = 0.0;
        } else {
            d2 = 510.0 - d5;
            d3 = 255.0;
            d4 = 0.0;
        }
        return new Color((int)d3, (int)d2, (int)d4);
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }
}

