/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.bean;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterUtil;
import cgdp.recog.funccat.FuncCat;
import cgdp.recog.funccat.FunctionColorUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ClusterListTableModel
extends AbstractTableModel {
    private static final String[] COLUMNS = new String[]{"Cluster ID", "Gene Name", "Description"};
    private List clusterList = new ArrayList();
    private boolean outgroupFlag;

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMNS[n];
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return String.class;
        }
        if (n == 1) {
            return String.class;
        }
        if (n == 2) {
            return FuncCat.class;
        }
        return super.getColumnClass(n);
    }

    @Override
    public int getRowCount() {
        return this.clusterList.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Cluster cluster = (Cluster)this.clusterList.get(n);
        if (n2 == 0) {
            return cluster.getDisplayClusterId();
        }
        if (n2 == 1) {
            return ClusterUtil.getGeneName(cluster, this.outgroupFlag);
        }
        if (n2 == 2) {
            String string = ClusterUtil.getFunctionCategoryNo(cluster, this.outgroupFlag);
            String string2 = ClusterUtil.getDescription(cluster, this.outgroupFlag);
            String string3 = FunctionColorUtil.getFuncCatColorString(string);
            FuncCat funcCat = new FuncCat();
            funcCat.setFunctionCategoryNo(string);
            funcCat.setColor(string3);
            funcCat.setName(string2);
            return funcCat;
        }
        return null;
    }

    public void setClusterList(List list) {
        this.clusterList = list;
        this.fireTableDataChanged();
    }

    public void setClusterList(List list, boolean bl) {
        this.clusterList = list;
        this.outgroupFlag = bl;
        this.fireTableDataChanged();
    }
}

