/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.bean;

import cgdp.recog.bean.ClusterList;
import cgdp.recog.bean.HeaderMap;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.color.ColorDrawable;
import cgdp.recog.color.ColorFacade;
import cgdp.recog.color.geneinfo.GeneColorPopupItem;
import cgdp.recog.color.geneinfo.GeneColorShowItem;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.ClusterUtil;
import cgdp.recog.data.SuperCluster;
import cgdp.recog.data.ViewData;
import cgdp.recog.funccat.FunctionColorUtil;
import cgdp.recog.hcluster.tree.ClusterTreeMap;
import cgdp.recog.histogram.CategoryMap;
import cgdp.recog.histogram.HistogramPopupItem;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.menu.AggregateModePopupItem;
import cgdp.recog.menu.AllClusterSelectPopupItem;
import cgdp.recog.menu.LimitReleaseItem;
import cgdp.recog.menu.TaxonomySelectOrganismItem;
import cgdp.recog.neighbor.NeighborClustItem;
import cgdp.recog.neighbor.NeighborClustShowItem;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.organism.Organism;
import cgdp.recog.pattern.PatternRegisterItem;
import cgdp.recog.pattern.PatternUtil;
import cgdp.recog.ppm.ClusterMergeItem;
import cgdp.recog.ppm.MergeClusterReleaseItem;
import cgdp.recog.ppm.PPMAggregateRenderer;
import cgdp.recog.ppm.PPMContext;
import cgdp.recog.ppm.PPMDisaggregateRenderer;
import cgdp.recog.ppm.PPMLabelPopupMenu;
import cgdp.recog.ppm.PPMRenderer;
import cgdp.recog.ppm.PPMSelectionManager;
import cgdp.recog.ppm.SplitClusterReleaseItem;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.search.SearchResultShowItem;
import cgdp.recog.set.cluster.ClusterSetRegisterItem;
import cgdp.recog.set.gene.GeneSetRegisterItem;
import cgdp.recog.sort.SortMenuFactory;
import cgdp.recog.system.KeyBindUtil;
import cgdp.recog.system.OS;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.ColorUtil;
import cgdp.recog.util.MapUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ClusterMap
extends JPanel
implements MouseListener,
MouseMotionListener,
ActionListener {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterMap.class);
    public static final int GENE_NAME_CELL_WIDTH = 45;
    private MediatorImpl mediator;
    private OptionTbl optionTbl;
    private ClusterTbl clusterTbl;
    private BufferedImage ppmImage;
    private int m_y1;
    private int m_y2;
    private int selMode;
    private boolean dragFlag;
    private List organismAreaList;
    private boolean popupFlagForMac = false;
    private ColorStore colorStore;
    private PPMContext ppmContext;
    private PPMAggregateRenderer ppmAggregateRenderer;
    private PPMDisaggregateRenderer ppmDisaggregateRenderer;
    private PPMRenderer ppmRenderer;
    private int anchorRow = -1;
    private int leadRow = -1;

    public ClusterMap(MediatorImpl mediatorImpl, PPMContext pPMContext) {
        this.mediator = mediatorImpl;
        this.mediator.register(this);
        this.colorStore = new ColorStore();
        this.ppmContext = pPMContext;
        this.ppmContext.setMediator(mediatorImpl);
        this.ppmAggregateRenderer = new PPMAggregateRenderer(this.ppmContext);
        this.ppmDisaggregateRenderer = new PPMDisaggregateRenderer(this.ppmContext);
        this.changePPMRenderer();
        this.clear();
        this.setLayout(null);
        this.setToolTipText("");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void changePPMRenderer() {
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        this.ppmRenderer = optionValues.isIntensive() ? this.ppmAggregateRenderer : this.ppmDisaggregateRenderer;
    }

    private void clear() {
        this.optionTbl = OptionTbl.getInstance();
        this.m_y1 = 0;
        this.m_y2 = 0;
        this.selMode = 1;
        this.dragFlag = false;
        this.organismAreaList = new ArrayList();
    }

    private Font createFont() {
        return new Font("Monospaced", 0, 12);
    }

    public void resizeClusterMap(Dimension dimension) {
        Graphics2D graphics2D;
        this.setRows(dimension.height);
        this.setColumns(dimension.width);
        this.ppmContext.updateScale();
        if (this.ppmImage == null || dimension.width != this.ppmImage.getWidth() || dimension.height != this.ppmImage.getHeight()) {
            if (this.ppmImage != null) {
                this.ppmImage.flush();
                this.ppmImage = null;
            }
            this.ppmImage = new BufferedImage(dimension.width, dimension.height, 1);
            this.ppmContext.setImageWidth(dimension.getWidth());
            this.ppmContext.setImageHeight(dimension.getHeight());
            graphics2D = (Graphics2D)this.ppmImage.getGraphics();
            graphics2D.setFont(new Font("Monospaced", 0, 12));
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, (int)this.ppmContext.getImageWidth(), (int)this.ppmContext.getImageHeight());
            graphics2D.dispose();
        }
        if (this.clusterTbl != null) {
            this.ppmRenderer.updateStartRow();
            this.ppmRenderer.updateStartColumn();
            this.ppmRenderer.updateScrollBar();
            boolean bl = this.mediator.isClusterVScrollBarVisible();
            boolean bl2 = this.mediator.isClusterHScrollBarVisible();
            boolean bl3 = this.ppmRenderer.isShowVirticalScrollBar();
            boolean bl4 = this.ppmRenderer.isShowHorisontalScrollBar();
            if (bl == bl3 && bl2 == bl4) {
                this.draw();
                this.repaint();
            }
        } else {
            graphics2D = (Graphics2D)this.ppmImage.getGraphics();
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, (int)this.ppmContext.getImageWidth(), (int)this.ppmContext.getImageHeight());
            graphics2D.dispose();
            this.repaint();
        }
        this.ppmContext.updateViewport();
    }

    public void setRows(int n) {
        int n2 = n / this.optionTbl.getOptionValues().getMinClusterH();
        this.ppmContext.setRows(n2);
    }

    public int getRows() {
        return this.ppmContext.getRows();
    }

    public void setColumns(int n) {
        int n2 = n / this.optionTbl.getOptionValues().getMinClusterW();
        this.ppmContext.setColumns(n2);
    }

    public int getColumns() {
        return this.ppmContext.getColumns();
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
        this.ppmContext.setClusterTbl(clusterTbl);
        this.ppmContext.clearSelectedOrganismAreaList();
        this.ppmContext.clearSelectedOrganismSet();
    }

    public List getClusterMapDrawInfo() {
        ArrayList<Number> arrayList = new ArrayList<Number>();
        arrayList.add(new Integer(this.ppmContext.getColumn()));
        arrayList.add(new Integer(this.ppmContext.getColumns()));
        double d = this.ppmContext.getCellWidth();
        double d2 = this.ppmContext.getCellHeight();
        arrayList.add(new Double(d));
        arrayList.add(new Double(d2));
        return arrayList;
    }

    public void createClusterMap() {
        this.createClusterMap(this.ppmContext.getStartRow(), this.ppmContext.getColumn());
    }

    public void createClusterMap(int n) {
        this.createClusterMap(n, 0);
    }

    private void createClusterMap(int n, int n2) {
        this.ppmContext.setStartRow(n);
        this.ppmContext.setColumn(n2);
        this.ppmRenderer.updateScrollBar();
        this.draw();
        this.repaint();
        this.ppmContext.updateViewport();
        this.updateScaleCenter();
    }

    public void updateSelection() {
        if (this.clusterTbl.isExistSelectedCluster() && !this.getPpmSelectionManager().containsSelctedRange(this.ppmContext.getStartRow(), this.ppmContext.getEndRow())) {
            int n = this.getPpmSelectionManager().getBaseRowIndex();
            this.mediator.setClusterVScrollBarValue(n < 0 ? 0 : n);
        }
        this.draw();
        this.repaint();
        this.updateScaleCenter();
    }

    private PPMSelectionManager getPpmSelectionManager() {
        if (this.clusterTbl == null) {
            return null;
        }
        return this.clusterTbl.getPpmSelectionManager();
    }

    public void setSelectedOrganism(Set set) {
        this.ppmContext.clearSelectedOrganismAreaList();
        this.ppmContext.clearSelectedOrganismSet();
        this.ppmContext.setSelectedOrganismSet(set);
        this.updateSelectedOrganismAreaList();
        this.repaint();
        this.updateScaleCenter();
    }

    public Set getSelectedOrganismSet() {
        return this.ppmContext.getSelectedOrganismSet();
    }

    public int getStartRow() {
        return this.ppmContext.getStartRow();
    }

    public void setStartRow(int n) {
        this.ppmContext.setStartRow(n);
        this.ppmContext.updateViewport();
        this.updateScaleCenter();
        this.draw();
        this.repaint();
    }

    public void setColumn(int n) {
        this.ppmContext.setColumn(n);
        this.ppmContext.updateViewport();
        this.updateScaleCenter();
        this.draw();
        this.repaint();
    }

    public int getSelectedRow() {
        return this.getPpmSelectionManager().getSelectedRow();
    }

    public List getSelectedClusterList() {
        return this.getPpmSelectionManager().getSelectedClusterList(this.clusterTbl);
    }

    private boolean isSearchResultCluster(Map map, String string) {
        if (!this.isEnableHighlightSearchResult()) {
            return false;
        }
        List list = this.clusterTbl.getViewClusterList(map);
        for (Cluster cluster : list) {
            if (!this.isSearchResultCluster(cluster, string)) continue;
            return true;
        }
        return false;
    }

    private boolean isSearchResultCluster(Cluster cluster, String string) {
        return this.clusterTbl.isSearchResultCluster(cluster, string);
    }

    private boolean isEnableHighlightSearchResult() {
        return this.clusterTbl.isEnableHighlightSearchResult();
    }

    protected void draw() {
        if (this.ppmImage == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this.ppmImage.getGraphics();
        graphics2D.setFont(this.createFont());
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, (int)this.ppmContext.getImageWidth(), (int)this.ppmContext.getImageHeight());
        this.ppmContext.clearSelectedOrganismAreaList();
        this.organismAreaList.clear();
        this.draw(graphics2D, this.ppmContext.getImageWidth(), this.ppmContext.getImageHeight(), this.ppmContext.getRows(), this.ppmContext.getColumns(), this.ppmContext.getStartRow(), this.ppmContext.getColumn(), false);
        graphics2D.dispose();
    }

    private void draw(Graphics2D graphics2D, double d, double d2, int n, int n2, int n3, int n4, boolean bl) {
        block42: {
            Cluster cluster;
            double d3;
            int n5;
            int n6;
            double d4;
            double d5;
            List list;
            ColorFacade colorFacade;
            OptionValues optionValues;
            block41: {
                Object object;
                Organism organism;
                int n7;
                optionValues = this.optionTbl.getOptionValues();
                colorFacade = ColorFacade.getInstance();
                this.colorStore = new ColorStore();
                list = this.clusterTbl.getViewOrganismList();
                d5 = this.ppmContext.getCellWidth();
                d4 = this.ppmContext.getCellHeight();
                if (!optionValues.isIntensive()) break block41;
                List list2 = this.clusterTbl.getViewOrderList();
                double d6 = 0.0;
                double d7 = 0.0;
                double d8 = 0.0;
                for (n7 = 0; n7 < list2.size() && n7 < n && n7 + n3 < list2.size(); ++n7) {
                    Map map = (Map)list2.get(n7 + n3);
                    d6 = 0.0;
                    for (int i = 0; i < list.size() && i < n2 && i + n4 < list.size(); ++i) {
                        organism = (Organism)list.get(i + n4);
                        object = organism.getOrganismCode();
                        if (map.get(object) == null) {
                            d6 += d5;
                            continue;
                        }
                        double d9 = (double)i * d5;
                        if (this.isSearchResultCluster(map, (String)object)) {
                            graphics2D.setColor(this.colorStore.searchResultColor);
                        } else {
                            graphics2D.setColor(this.colorStore.getBackgroundCellColor(organism));
                        }
                        graphics2D.fill(new Rectangle2D.Double(d9, d8, d5, d4));
                        d6 += d5;
                    }
                    d8 += d4;
                    d7 += d4;
                }
                graphics2D.setColor(Color.white);
                for (n7 = 1; n7 < n2; ++n7) {
                    double d10 = (double)n7 * d5;
                    graphics2D.draw(new Line2D.Double(d10, 0.0, d10, d7));
                }
                graphics2D.setColor(this.colorStore.borderLineColor);
                if (optionValues.isBorderLineView()) {
                    d8 = 0.0;
                    for (n7 = 0; n7 < list2.size() && n7 < n && n7 + n3 < list2.size(); ++n7) {
                        graphics2D.draw(new Line2D.Double(0.0, d8 + d4 - 1.0, d6, d8 + d4 - 1.0));
                        d8 += d4;
                    }
                }
                if (this.mediator.isViewUpper()) {
                    if (this.clusterTbl.isOutgroup()) {
                        for (n7 = 0; n7 < list.size(); ++n7) {
                            if (!this.clusterTbl.isOutgroup((Organism)list.get(n7))) continue;
                            double d11 = (double)(n7 - n4) * d5;
                            if (d11 >= 0.0 && d11 <= d) {
                                d11 = d11 == 0.0 ? d11 : d11 - 1.0;
                                graphics2D.draw(new Line2D.Double(d11, 0.0, d11, d7));
                            }
                            break;
                        }
                    } else {
                        double d12 = (double)(list.size() - n4) * d5;
                        if (d12 >= 0.0 && d12 <= d) {
                            d12 = d12 == 0.0 ? d12 : d12 - 1.0;
                            graphics2D.draw(new Line2D.Double(d12, 0.0, d12, d7));
                        }
                    }
                }
                if (bl) break block42;
                this.updateSelectedOrganismAreaList();
                for (int i = 0; i < list.size() && i < n2 && i + n4 < list.size(); ++i) {
                    double d13 = (double)i * d5;
                    organism = (Organism)list.get(i + n4);
                    object = new ViewData();
                    ((ViewData)object).setObject(organism);
                    ((ViewData)object).setDataRect2D(new Rectangle2D.Double(d13, 0.0, d5, d2));
                    this.organismAreaList.add(object);
                }
                break block42;
            }
            this.drawSubClusterLabel(graphics2D, bl, n3, n, n4);
            this.drawClusterLabel(graphics2D, bl, n3, n, n4, n2, d);
            this.drawHomClusterLabel(graphics2D, bl, n3, n, n4, n2, d);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            List list3 = this.clusterTbl.getViewClusterList();
            List list4 = this.clusterTbl.getViewSuperClusterList();
            boolean bl2 = ClusterMap.isDrawLabel(d4, fontMetrics.getAscent() + fontMetrics.getDescent()) && optionValues.isGeneNameView();
            double d14 = 0.0;
            double d15 = 0.0;
            int n8 = Integer.MAX_VALUE;
            String string = "";
            double d16 = 0.0;
            for (n6 = 0; n6 < list3.size() && n6 < n && n6 + n3 < list3.size(); ++n6) {
                Cluster cluster2 = (Cluster)list3.get(n6 + n3);
                n5 = (int)(d16 + d4 - 1.0) - (int)d16;
                n5 = n5 <= 0 ? 1 : n5;
                d3 = this.getTotalCellStartY(n6 + n3, cluster2, list3, d4, d16);
                double d17 = this.getTotalCellHeight(n6 + n3, cluster2, list3, d4);
                cluster = ClusterTbl.createSuperCluster(cluster2, list3, n6, n3);
                int n9 = this.clusterTbl.indexOfClusterListByCluster(list4, cluster);
                List list5 = null;
                List list6 = null;
                if (this.clusterTbl.isShowNeighboringCluster()) {
                    list5 = ClusterTbl.createNbrClusterList(list4, n9, 0, -1, 1);
                    list6 = ClusterTbl.createNbrClusterList(list3, n6, n3, -1, 1);
                }
                for (int i = 0; i < list.size() && i < n2 && i + n4 < list.size(); ++i) {
                    ColorDrawable colorDrawable;
                    Map map;
                    double d18 = (double)i * d5;
                    d18 += this.getOffsetLeft(bl, n4);
                    Organism organism = (Organism)list.get(i + n4);
                    String string2 = organism.getOrganismCode();
                    if (!cluster2.isExistOrganism(string2)) continue;
                    Color color = null;
                    int n10 = (int)((double)(i + 1) * d5 + this.getOffsetLeft(bl, n4)) - (int)d18 - 1;
                    if (!(!this.clusterTbl.isOutgroup(string2) || cluster2.equalsClusterId(n8) && string.equals(string2))) {
                        map = null;
                        if (this.clusterTbl.isShowNeighboringCluster()) {
                            map = ClusterTbl.createLocusTagMap(list5, string2);
                        }
                        colorDrawable = colorFacade.getPrimaryColorDrawable(cluster, organism);
                        color = colorDrawable.drawPPMCell(graphics2D, d18 + 1.0, d3, n10, d17, cluster, organism, map);
                        n8 = cluster2.getClusterId();
                        string = string2;
                    } else if (!this.clusterTbl.isOutgroup(string2)) {
                        map = null;
                        if (this.clusterTbl.isShowNeighboringCluster()) {
                            map = ClusterTbl.createLocusTagMap(list6, string2);
                        }
                        colorDrawable = colorFacade.getPrimaryColorDrawable(cluster2, organism);
                        color = colorDrawable.drawPPMCell(graphics2D, d18 + 1.0, (double)n6 * d4, n10, d4, cluster2, organism, map);
                    }
                    if (color == null) {
                        color = graphics2D.getColor();
                    }
                    if (bl2) {
                        this.drawLabel(graphics2D, cluster2, organism, n10 - 1, d4, d17, d18 + 1.0, d16, d3, n6, n3, color);
                    }
                    d14 += d5;
                }
                d16 += d4;
                d15 += d4;
            }
            graphics2D.setColor(Color.white);
            for (n6 = 1; n6 < list.size() && n6 < n2; ++n6) {
                double d19 = (double)n6 * d5;
                graphics2D.draw(new Line2D.Double(d19 += this.getOffsetLeft(bl, n4), 0.0, d19, d15));
            }
            graphics2D.setColor(this.colorStore.borderLineColor);
            if (optionValues.isBorderLineView()) {
                d16 = 0.0;
                for (n6 = 0; n6 < list3.size() && n6 < n && n6 + n3 < list3.size(); ++n6) {
                    Cluster cluster3 = (Cluster)list3.get(n6 + n3);
                    for (n5 = 0; n5 < list.size() && n5 < n2 && n5 + n4 < list.size(); ++n5) {
                        d3 = (double)n5 * d5;
                        d3 += this.getOffsetLeft(bl, n4);
                        Organism organism = (Organism)list.get(n5 + n4);
                        String string3 = organism.getOrganismCode();
                        if (cluster3.getLocusTagList(string3) == null) {
                            graphics2D.draw(new Line2D.Double(d3, d16 + d4 - 1.0, d3 + d5, d16 + d4 - 1.0));
                            continue;
                        }
                        if (n6 + n3 != list3.size() - 1) {
                            cluster = (Cluster)list3.get(n6 + n3 + 1);
                            if (cluster3.equalsClusterId(cluster) && this.clusterTbl.isOutgroup(string3)) continue;
                            graphics2D.draw(new Line2D.Double(d3, d16 + d4 - 1.0, d3 + d5, d16 + d4 - 1.0));
                            continue;
                        }
                        graphics2D.draw(new Line2D.Double(d3, d16 + d4 - 1.0, d3 + d5, d16 + d4 - 1.0));
                    }
                    d16 += d4;
                }
            }
            if (this.mediator.isViewUpper()) {
                if (this.clusterTbl.isOutgroup()) {
                    for (n6 = 0; n6 < list.size(); ++n6) {
                        if (!this.clusterTbl.isOutgroup((Organism)list.get(n6))) continue;
                        double d20 = (double)(n6 - n4) * d5;
                        d20 = !bl ? (d20 += 45.0) : (d20 += n4 == 0 ? 45.0 : 0.0);
                        if (d20 >= 45.0 && d20 <= d - 45.0) {
                            d20 = d20 == 45.0 ? d20 : d20 - 1.0;
                            graphics2D.draw(new Line2D.Double(d20, 0.0, d20, d15));
                        }
                        break;
                    }
                } else {
                    double d21 = (double)(list.size() - n4) * d5;
                    d21 = !bl ? (d21 += 45.0) : (d21 += n4 == 0 ? 45.0 : 0.0);
                    if (d21 >= 45.0 && d21 <= d) {
                        d21 = d21 == 45.0 ? d21 : d21 - 1.0;
                        graphics2D.draw(new Line2D.Double(d21, 0.0, d21, d15));
                    }
                }
            }
            if (!bl) {
                this.updateSelectedOrganismAreaList();
                for (int i = 0; i < list.size() && i < n2 && i + n4 < list.size(); ++i) {
                    double d22 = (double)i * d5 + 45.0;
                    Organism organism = (Organism)list.get(i + n4);
                    ViewData viewData = new ViewData();
                    viewData.setObject(organism);
                    viewData.setDataRect2D(new Rectangle2D.Double(d22, 0.0, d5, d2));
                    this.organismAreaList.add(viewData);
                }
            }
        }
    }

    private Cluster createCompleteSuperCluster(Cluster cluster, List list, int n, int n2) {
        Cluster cluster2 = cluster;
        int n3 = 0;
        int n4 = cluster.getClusterId();
        SuperCluster superCluster = new SuperCluster();
        while (cluster2.getClusterId() == n4) {
            superCluster.addSubCluster(cluster2);
            if (n + n2 + --n3 < 0) break;
            cluster2 = (Cluster)list.get(n + n2 + n3);
        }
        if (n + n2 + (n3 = 1) < list.size()) {
            cluster2 = (Cluster)list.get(n + n2 + n3);
            while (cluster2.getClusterId() == n4) {
                superCluster.addSubCluster(cluster2);
                if (n + n2 + ++n3 >= list.size()) break;
                cluster2 = (Cluster)list.get(n + n2 + n3);
            }
        }
        return superCluster;
    }

    private boolean isDrawClusterLabel(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        double d = this.ppmContext.getCellHeight();
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        boolean bl = ClusterMap.isDrawLabel(d, fontMetrics.getAscent() + fontMetrics.getDescent()) && optionValues.isGeneNameView();
        return bl;
    }

    private void drawSubClusterLabel(Graphics2D graphics2D, boolean bl, int n, int n2, int n3) {
        if (bl && n3 != 0) {
            return;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n4 = 45 / fontMetrics.stringWidth("A");
        double d = this.ppmContext.getCellHeight();
        List list = this.clusterTbl.getViewClusterList();
        double d2 = 0.0;
        for (int i = 0; i < list.size() && i < n2 && i + n >= 0 && i + n < list.size(); ++i) {
            Object object;
            Cluster cluster = (Cluster)list.get(i + n);
            String string = ClusterUtil.getFunctionCategoryNo(cluster, this.clusterTbl.isOutgroup());
            graphics2D.setColor(FunctionColorUtil.getFuncCatColor(string));
            graphics2D.fill(new Rectangle2D.Double(0.0, d2, 40.0, d));
            if (cluster.isTypeMergeCluster() || cluster.isTypeSplitCluster()) {
                object = this.ppmContext.createModifiedClusterMark((float)d2);
                graphics2D.setColor(this.ppmContext.getModifiedClusterMarkColor(cluster));
                graphics2D.fill((Shape)object);
            }
            if (!StringTool.isNull((String)(object = this.clusterTbl.getSelectedPpmLabelCondition().getSubClusterLabel(cluster, this.clusterTbl.getClusterId()))) && this.isDrawClusterLabel(graphics2D)) {
                if (((String)object).length() > n4) {
                    object = ((String)object).substring(0, n4);
                }
                int n5 = (int)(d2 + d / 2.0) + fontMetrics.getAscent() / 2;
                graphics2D.setColor(this.getLabelColor(graphics2D.getColor()));
                int n6 = (int)this.getClusterLabelStartX(graphics2D, (String)object, 0.0, this.ppmContext.getClusterLabelWidth(), this.clusterTbl.getSelectedPpmLabelCondition().getSubClusterInfoTitle());
                graphics2D.drawString((String)object, n6, n5);
            }
            graphics2D.setColor(this.colorStore.borderLineColor);
            graphics2D.draw(new Line2D.Double(0.0, d2 + d - 1.0, 45.0, d2 + d - 1.0));
            d2 += d;
        }
    }

    private void drawClusterLabel(Graphics2D graphics2D, boolean bl, int n, int n2, int n3, int n4, double d) {
        if (!this.clusterTbl.isOutgroup()) {
            return;
        }
        List list = this.clusterTbl.getViewOrganismList();
        if (bl && n3 + n4 < list.size()) {
            return;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n5 = 45 / fontMetrics.stringWidth("A");
        double d2 = this.ppmContext.getCellWidth();
        double d3 = this.ppmContext.getCellHeight();
        List list2 = this.clusterTbl.getViewClusterList();
        double d4 = 0.0;
        double d5 = this.getStartClusterLabelAreaX(bl, d, n3, d2, list.size());
        for (int i = 0; i < list2.size() && i < n2 && i + n < list2.size(); ++i) {
            Cluster cluster = (Cluster)list2.get(i + n);
            Cluster cluster2 = this.createCompleteSuperCluster(cluster, list2, i, n);
            double d6 = this.getTotalCellStartY(i + n, cluster, list2, d3, d4);
            graphics2D.setColor(FunctionColorUtil.getFuncCatColor(cluster.getFunctionCategory()));
            graphics2D.fill(new Rectangle2D.Double(d5, d4, 40.0, d3));
            String string = this.clusterTbl.getSelectedPpmLabelCondition().getClusterLabel(cluster2, this.clusterTbl.getClusterId());
            if (!StringTool.isNull(string) && this.isDrawClusterLabel(graphics2D)) {
                if (string.length() > n5) {
                    string = string.substring(0, n5);
                }
                double d7 = this.getTotalCellHeight(i + n, cluster, list2, d3);
                int n6 = (int)(d6 + d7 / 2.0) + fontMetrics.getAscent() / 2;
                graphics2D.setColor(this.getLabelColor(graphics2D.getColor()));
                if (d7 - 1.0 >= (double)fontMetrics.getAscent()) {
                    double d8 = this.getClusterLabelStartX(graphics2D, string, d5, this.ppmContext.getClusterLabelWidth(), this.clusterTbl.getSelectedPpmLabelCondition().getClusterInfoTitle());
                    graphics2D.drawString(string, (int)d8, n6);
                }
            }
            graphics2D.setColor(this.colorStore.borderLineColor);
            graphics2D.draw(new Line2D.Double(d5 - 5.0, d6 - 1.0, d5 + 45.0, d6 - 1.0));
            d4 += d3;
        }
        graphics2D.setColor(this.colorStore.borderLineColor);
        graphics2D.draw(new Line2D.Double(d5 - 5.0, d4 - 1.0, d5 + 45.0, d4 - 1.0));
    }

    private double getStartClusterLabelAreaX(boolean bl, double d, int n, double d2, int n2) {
        double d3;
        if (bl) {
            d3 = n == 0 ? 45.0 : 0.0;
            d3 += (double)(n2 - n) * d2;
            d3 += 5.0;
        } else {
            d3 = d - 45.0 + 5.0;
            if (this.clusterTbl.isExistHomCluster() && this.ppmContext.isShowHomClustLabel()) {
                d3 -= 45.0;
            }
        }
        return d3;
    }

    private double getClusterLabelStartX(Graphics graphics, String string, double d, double d2, AbstractInfoTitle abstractInfoTitle) {
        FontMetrics fontMetrics;
        double d3;
        double d4 = 0.0;
        if (abstractInfoTitle != null && abstractInfoTitle.isNumeric() && (d4 = d2 - (d3 = (double)(fontMetrics = graphics.getFontMetrics()).stringWidth(string))) < 0.0) {
            d4 = 0.0;
        }
        return d4 += d;
    }

    private void drawHomClusterLabel(Graphics2D graphics2D, boolean bl, int n, int n2, int n3, int n4, double d) {
        if (!this.clusterTbl.isExistHomCluster()) {
            return;
        }
        if (!this.ppmContext.isShowHomClustLabel()) {
            return;
        }
        List list = this.clusterTbl.getViewOrganismList();
        if (bl && n3 + n4 < list.size()) {
            return;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n5 = 45 / fontMetrics.stringWidth("A");
        double d2 = this.ppmContext.getCellWidth();
        double d3 = this.ppmContext.getCellHeight();
        List list2 = this.clusterTbl.getViewClusterList();
        double d4 = 0.0;
        double d5 = this.getStartHomClusterLabelAreaX(bl, d, n3, d2, list.size());
        for (int i = 0; i < list2.size() && i < n2 && i + n < list2.size(); ++i) {
            Cluster cluster = (Cluster)list2.get(i + n);
            double d6 = this.getTotalHomClusterCellStartY(i + n, cluster, list2, d3, d4);
            graphics2D.setColor(this.ppmContext.getHomClusterLabelColor(cluster.getHomClusterId()));
            graphics2D.fill(new Rectangle2D.Double(d5, d4, 40.0, d3));
            String string = this.clusterTbl.getSelectedPpmLabelCondition().getHomClusterLabel(cluster, this.clusterTbl.getClusterId());
            if (!StringTool.isNull(string) && this.isDrawClusterLabel(graphics2D)) {
                if (string.length() > n5) {
                    string = string.substring(0, n5);
                }
                double d7 = this.getTotalHomClusterCellHeight(i + n, cluster, list2, d3);
                int n6 = (int)(d6 + d7 / 2.0) + fontMetrics.getAscent() / 2;
                graphics2D.setColor(this.getLabelColor(graphics2D.getColor()));
                if (d7 - 1.0 >= (double)fontMetrics.getAscent()) {
                    double d8 = this.getClusterLabelStartX(graphics2D, string, d5, this.ppmContext.getClusterLabelWidth(), this.clusterTbl.getSelectedPpmLabelCondition().getHomClusterInfoTitle());
                    graphics2D.drawString(string, (int)d8, n6);
                }
            }
            graphics2D.setColor(this.colorStore.borderLineColor);
            graphics2D.draw(new Line2D.Double(d5 - 5.0, d6 - 1.0, d5 + 45.0, d6 - 1.0));
            d4 += d3;
        }
        graphics2D.setColor(this.colorStore.borderLineColor);
        graphics2D.draw(new Line2D.Double(d5 - 5.0, d4 - 1.0, d5 + 45.0, d4 - 1.0));
    }

    private double getStartHomClusterLabelAreaX(boolean bl, double d, int n, double d2, int n2) {
        double d3;
        if (bl) {
            d3 = n == 0 ? 45.0 : 0.0;
            d3 += (double)(n2 - n) * d2;
            d3 += 5.0;
            if (this.clusterTbl.isOutgroup()) {
                d3 += 50.0;
            }
        } else {
            d3 = d - 45.0 + 5.0;
        }
        return d3;
    }

    private double getOffsetLeft(boolean bl, int n) {
        if (bl && n != 0) {
            return 0.0;
        }
        return this.optionTbl.getOptionValues().isIntensive() ? 0.0 : 45.0;
    }

    private void updateSelectedOrganismAreaList() {
        int n = (int)this.ppmContext.getImageHeight();
        this.ppmContext.clearSelectedOrganismAreaList();
        if (!this.ppmContext.isExistSelectedOrganism()) {
            return;
        }
        List list = this.clusterTbl.getViewOrganismList();
        double d = this.ppmContext.getCellWidth();
        ArrayList<Rectangle2D.Double> arrayList = new ArrayList<Rectangle2D.Double>();
        for (int i = 0; i < list.size() && i < this.ppmContext.getColumns() && i + this.ppmContext.getColumn() < list.size(); ++i) {
            Organism organism = (Organism)list.get(i + this.ppmContext.getColumn());
            if (!this.ppmContext.containsSelectedOrganism(organism.getOrganismCode())) continue;
            double d2 = (double)i * d + this.getOffsetLeft(false, 0);
            arrayList.add(new Rectangle2D.Double(d2, 0.0, d, n));
        }
        this.ppmContext.setSelectedOrganismAreaList(arrayList);
    }

    private void drawLabel(Graphics2D graphics2D, Cluster cluster, Organism organism, double d, double d2, double d3, double d4, double d5, double d6, int n, int n2, Color color) {
        boolean bl;
        boolean bl2;
        int n3;
        boolean bl3;
        String string = organism.getOrganismCode();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        List list = cluster.getLocusTagList(string);
        graphics2D.setColor(this.getLabelColor(graphics2D.getColor()));
        int n4 = cluster.getLocusTagList(string).size();
        boolean bl4 = d - 1.0 > (double)fontMetrics.stringWidth(String.valueOf(n4));
        boolean bl5 = bl3 = d > (double)(fontMetrics.stringWidth("A") * 7);
        if (this.clusterTbl.isOutgroup(string)) {
            n3 = (int)(d6 + d3 / 2.0) + fontMetrics.getAscent() / 2;
            bl2 = ClusterMap.isDrawLabel(d3, (fontMetrics.getAscent() + fontMetrics.getDescent()) * list.size());
            bl = ClusterMap.isDrawLabel(d3, fontMetrics.getAscent() + fontMetrics.getDescent());
        } else {
            n3 = (int)(d5 + d2 / 2.0) + fontMetrics.getAscent() / 2;
            bl2 = ClusterMap.isDrawLabel(d2, (fontMetrics.getAscent() + fontMetrics.getDescent()) * list.size());
            bl = ClusterMap.isDrawLabel(d2, fontMetrics.getAscent() + fontMetrics.getDescent());
        }
        if (bl3 && bl2) {
            ColorDrawable colorDrawable = ColorFacade.getInstance().getPrimaryColorDrawable(cluster, organism);
            colorDrawable.drawPPMLabel(graphics2D, cluster, organism, d, d2, d3, d4, d5, d6, n3, color);
        } else if (bl4 && bl) {
            String string2 = String.valueOf(n4);
            int n5 = (int)this.getDrawLabelStartX(fontMetrics, d4, d, string2);
            graphics2D.drawString(string2, n5, n3);
        }
    }

    private Color getLabelColor(Color color) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        float f = fArray[1];
        float f2 = fArray[2];
        if (f2 >= f) {
            return Color.black;
        }
        return Color.white;
    }

    private double getDrawLabelStartX(FontMetrics fontMetrics, double d, double d2, String string) {
        return d + d2 / 2.0 - (double)(fontMetrics.stringWidth(string) / 2);
    }

    private double getTotalCellStartY(int n, Cluster cluster, List list, double d, double d2) {
        Cluster cluster2;
        double d3 = d2;
        for (int i = n - 1; i >= 0 && cluster.equalsClusterId(cluster2 = (Cluster)list.get(i)); --i) {
            d3 -= d;
        }
        return d3;
    }

    private double getTotalCellHeight(int n, Cluster cluster, List list, double d) {
        Cluster cluster2;
        int n2;
        double d2 = d;
        for (n2 = n - 1; n2 >= 0 && cluster.equalsClusterId(cluster2 = (Cluster)list.get(n2)); --n2) {
            d2 += d;
        }
        for (n2 = n + 1; n2 < list.size() && cluster.equalsClusterId(cluster2 = (Cluster)list.get(n2)); ++n2) {
            d2 += d;
        }
        return d2;
    }

    private double getTotalHomClusterCellStartY(int n, Cluster cluster, List list, double d, double d2) {
        Cluster cluster2;
        double d3 = d2;
        for (int i = n - 1; i >= 0 && cluster.equalsHomClusterId(cluster2 = (Cluster)list.get(i)); --i) {
            d3 -= d;
        }
        return d3;
    }

    private double getTotalHomClusterCellHeight(int n, Cluster cluster, List list, double d) {
        Cluster cluster2;
        int n2;
        double d2 = d;
        for (n2 = n - 1; n2 >= 0 && cluster.equalsHomClusterId(cluster2 = (Cluster)list.get(n2)); --n2) {
            d2 += d;
        }
        for (n2 = n + 1; n2 < list.size() && cluster.equalsHomClusterId(cluster2 = (Cluster)list.get(n2)); ++n2) {
            d2 += d;
        }
        return d2;
    }

    public static boolean isDrawLabel(double d, double d2) {
        return d - 1.0 >= d2;
    }

    private void drawHeader(Graphics graphics, double d, int n, int n2, double d2) {
        List list = this.clusterTbl.getViewOrganismList();
        double d3 = this.ppmContext.getCellWidth();
        double d4 = 0.0;
        if (!this.optionTbl.getOptionValues().isIntensive()) {
            d4 = n2 == 0 ? 45.0 : 0.0;
        }
        HeaderMap.drawHeader((Graphics2D)graphics, list, n2, n, d3, d2, d4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLabelArea() {
        if (this.ppmImage == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this.ppmImage.getGraphics();
        try {
            graphics2D.setFont(this.createFont());
            this.drawSubClusterLabel(graphics2D, false, this.ppmContext.getStartRow(), this.ppmContext.getRows(), this.ppmContext.getColumn());
            this.drawClusterLabel(graphics2D, false, this.ppmContext.getStartRow(), this.ppmContext.getRows(), this.ppmContext.getColumn(), this.ppmContext.getColumns(), this.ppmContext.getImageWidth());
            this.drawHomClusterLabel(graphics2D, false, this.ppmContext.getStartRow(), this.ppmContext.getRows(), this.ppmContext.getColumn(), this.ppmContext.getColumns(), this.ppmContext.getImageWidth());
            this.repaint();
        }
        finally {
            graphics2D.dispose();
        }
    }

    private void showPopup(Point point) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.optionTbl.getOptionValues().isIntensive()) {
            Map map = this.getPatternOnCursor(point);
            List list = this.clusterTbl.getViewClusterList(map);
            SuperCluster superCluster = new SuperCluster(list);
            JMenu jMenu = SortMenuFactory.createSortMenuForAggregate(this, this.mediator, superCluster, this.clusterTbl.getViewOrganismCodeList());
            jPopupMenu.add(jMenu);
            jPopupMenu.addSeparator();
            if (!MapUtil.isNull(map)) {
                jPopupMenu.add(new TaxonomySelectOrganismItem(this, this.mediator, map.keySet()));
            }
            jPopupMenu.add(new AllClusterSelectPopupItem(this, this.mediator));
            jPopupMenu.addSeparator();
            jPopupMenu.add(new GeneSetRegisterItem(this, this.mediator));
            jPopupMenu.add(new ClusterSetRegisterItem(this, this.mediator));
            jPopupMenu.add(new PatternRegisterItem(this, this.mediator, PatternUtil.createPattern(map.keySet(), this.clusterTbl)));
            if (this.mediator.isLimitNoListForAggregate()) {
                jPopupMenu.addSeparator();
                jPopupMenu.add(new LimitReleaseItem(this, this.mediator));
            }
            jPopupMenu.addSeparator();
            jPopupMenu.add(new AggregateModePopupItem(this, this.mediator, "Disaggregate Mode"));
            if (this.clusterTbl.isEnableHighlightSearchResult()) {
                jPopupMenu.addSeparator();
                jPopupMenu.add(new SearchResultShowItem(this, this.mediator, this.clusterTbl.isShowSearchResult()));
            }
            jPopupMenu.show(this, point.x, point.y);
        } else {
            List list;
            List list2;
            Cluster cluster = this.getClusterOnCursor(point);
            if (cluster == null) {
                return;
            }
            Organism organism = this.getOrganismOnCursor(point);
            List list3 = this.getSelectedClusterList();
            if (organism != null) {
                JMenu jMenu = SortMenuFactory.createSortMenuForDisaggregate(this, this.mediator, this.clusterTbl, cluster, organism.getOrganismCode());
                jPopupMenu.add(jMenu);
                jPopupMenu.addSeparator();
                if (cluster != null) {
                    jPopupMenu.add(new TaxonomySelectOrganismItem(this, this.mediator, cluster.getSpSet()));
                }
                jPopupMenu.add(new AllClusterSelectPopupItem(this, this.mediator));
                jPopupMenu.addSeparator();
                jPopupMenu.add(new NeighborClustItem(this, this.mediator, true));
                jPopupMenu.add(new GeneColorPopupItem(this, this.mediator));
                jPopupMenu.addSeparator();
                jPopupMenu.add(new HistogramPopupItem(this, this.mediator, organism.getOrganismCode(), this.clusterTbl.getHistogramCondition()));
                jPopupMenu.addSeparator();
                jPopupMenu.add(new GeneSetRegisterItem(this, this.mediator));
                jPopupMenu.add(new ClusterSetRegisterItem(this, this.mediator));
                jPopupMenu.add(new PatternRegisterItem(this, this.mediator, PatternUtil.createPattern(cluster.getSpSet(), this.clusterTbl)));
            } else {
                if (this.optionTbl.getOptionValues().isShowHiddenMenu()) {
                    ClusterList.showClusterMenu(this, this.mediator, jPopupMenu, list3);
                }
                jPopupMenu.add(new PPMLabelPopupMenu(this, this.mediator, this.clusterTbl));
            }
            jPopupMenu.addSeparator();
            boolean bl = false;
            List list4 = ClusterUtil.getEnableMergeClusterList(list3);
            if (list4.size() >= 2) {
                bl = true;
                jPopupMenu.add(new ClusterMergeItem(this, this.mediator, list4));
            }
            if (!CollectionUtil.isNull(list2 = ClusterUtil.extractMergeCluster(list3))) {
                bl = true;
                jPopupMenu.add(new MergeClusterReleaseItem(this, this.mediator, list2));
            }
            if (!CollectionUtil.isNull(list = ClusterUtil.extractSplitCluster(list3))) {
                bl = true;
                jPopupMenu.add(new SplitClusterReleaseItem(this, this.mediator, list));
            }
            if (bl) {
                jPopupMenu.addSeparator();
            }
            jPopupMenu.add(new AggregateModePopupItem(this, this.mediator, "Aggregate Mode"));
            boolean bl2 = false;
            if (this.mediator.isLimitNoListForDisaggregate()) {
                if (!bl2) {
                    jPopupMenu.addSeparator();
                    bl2 = true;
                }
                jPopupMenu.add(new LimitReleaseItem(this, this.mediator));
            }
            if (this.clusterTbl.isExistNeighboringCluster()) {
                if (!bl2) {
                    jPopupMenu.addSeparator();
                    bl2 = true;
                }
                boolean bl3 = this.clusterTbl.isShowNeighboringCluster();
                jPopupMenu.add(new NeighborClustShowItem(this, this.mediator, bl3));
            }
            if (this.clusterTbl.isExistGeneColor()) {
                if (!bl2) {
                    jPopupMenu.addSeparator();
                    bl2 = true;
                }
                jPopupMenu.add(new GeneColorShowItem(this, this.mediator, this.clusterTbl.isShowGeneColor()));
            }
            if (this.clusterTbl.isExistSearchResult()) {
                if (!bl2) {
                    jPopupMenu.addSeparator();
                    bl2 = true;
                }
                jPopupMenu.add(new SearchResultShowItem(this, this.mediator, this.clusterTbl.isShowSearchResult()));
            }
            jPopupMenu.show(this, point.x, point.y);
        }
    }

    private Organism getOrganismOnCursor(Point point) {
        for (int i = 0; i < this.organismAreaList.size(); ++i) {
            ViewData viewData = (ViewData)this.organismAreaList.get(i);
            if (!viewData.getDataRect2D().contains(point.x, point.y)) continue;
            return (Organism)viewData.getObject();
        }
        return null;
    }

    private Cluster getClusterOnCursor(Point point) {
        List list = this.clusterTbl.getViewClusterList();
        int n = this.ppmContext.getRowIndex((int)point.getY());
        if (n == -1) {
            return null;
        }
        return (Cluster)list.get(n);
    }

    private Map getPatternOnCursor(Point point) {
        List list = this.clusterTbl.getViewOrderList();
        int n = this.ppmContext.getRowIndex((int)point.getY());
        if (n == -1) {
            return null;
        }
        return (Map)list.get(n);
    }

    private void drawDragArea(Graphics2D graphics2D) {
        if (this.m_y1 == this.m_y2) {
            return;
        }
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.25f));
        graphics2D.setColor(Color.blue);
        int n = 0;
        int n2 = this.m_y1 < this.m_y2 ? this.m_y1 : this.m_y2;
        int n3 = (int)this.ppmContext.getImageWidth();
        int n4 = Math.abs(this.m_y1 - this.m_y2);
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setComposite(composite);
    }

    private void drawSelectedArea(Graphics2D graphics2D) {
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.25f));
        this.drawSelectColumnArea(graphics2D);
        this.drawSelectRawArea(graphics2D);
        graphics2D.setComposite(composite);
    }

    private void drawSelectColumnArea(Graphics2D graphics2D) {
        if (!this.ppmContext.isExistSelectedOrganismArea()) {
            return;
        }
        graphics2D.setColor(PPMContext.HIGHLIGHT_COLOR);
        Iterator iterator = this.ppmContext.getSelectedOrganismAreaList().iterator();
        while (iterator.hasNext()) {
            graphics2D.fill((Rectangle2D.Double)iterator.next());
        }
    }

    private void drawSelectRawArea(Graphics2D graphics2D) {
        PPMSelectionManager pPMSelectionManager = this.getPpmSelectionManager();
        if (pPMSelectionManager == null) {
            return;
        }
        Set set = pPMSelectionManager.getSelectedRowIndexSet();
        if (CollectionUtil.isNull(set)) {
            return;
        }
        HashSet hashSet = new HashSet(set);
        hashSet.addAll(pPMSelectionManager.getSubSelectedRowIndexSet());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!this.ppmContext.containsVisibledRow(n)) continue;
            double d = this.ppmContext.getCellHeight() * (double)(n - this.ppmContext.getStartRow());
            double d2 = this.getOffsetLeft(false, this.ppmContext.getColumn());
            for (String string : this.clusterTbl.getViewOrganismCodeList()) {
                if (!this.clusterTbl.isOutgroup(string)) {
                    if (this.getPpmSelectionManager().isSelectedSubCluster(n)) {
                        graphics2D.setColor(PPMContext.HIGHLIGHT_COLOR);
                    } else {
                        graphics2D.setColor(PPMContext.HIGHLIGHT_SUB_COLOR);
                    }
                } else {
                    graphics2D.setColor(PPMContext.HIGHLIGHT_COLOR);
                }
                graphics2D.fill(new Rectangle2D.Double(d2, d, this.ppmContext.getCellWidth(), this.ppmContext.getCellHeight()));
                d2 += this.ppmContext.getCellWidth();
            }
        }
    }

    public void writePdf(String string, PageFormat pageFormat) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        if (this.mediator.getTabIndex("Tree") == 2) {
            bl = true;
        }
        if (this.mediator.getTabIndex("Info") == 1) {
            bl2 = true;
        }
        ClusterTreeMap clusterTreeMap = this.mediator.getClusterTreeMap();
        CategoryMap categoryMap = this.mediator.getCategoryMap();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (bl) {
            d = clusterTreeMap.getWidth();
        }
        if (bl2) {
            d3 = categoryMap.getWidth();
        }
        double d4 = pageFormat.getImageableWidth();
        double d5 = pageFormat.getImageableHeight();
        double d6 = pageFormat.getWidth();
        double d7 = pageFormat.getHeight();
        double d8 = pageFormat.getImageableX();
        double d9 = pageFormat.getImageableY();
        double d10 = this.mediator.getHeaderMapSize().height;
        List list = this.optionTbl.getOptionValues().isIntensive() ? this.clusterTbl.getViewOrderList() : this.clusterTbl.getViewClusterList();
        List list2 = this.clusterTbl.getViewOrganismCodeList();
        int n = (int)(d5 / (double)this.optionTbl.getOptionValues().getMinClusterH());
        int n2 = (int)(d4 / (double)this.optionTbl.getOptionValues().getMinClusterW());
        if (bl3) {
            int n3 = 1;
            n = list.size() + 1;
            n2 = list2.size();
            if (this.clusterTbl.isOutgroup()) {
                ++n3;
            }
            if (this.isShowHomClustLabel()) {
                ++n3;
            }
            d5 = (double)list.size() * this.ppmContext.getCellHeight() + d10;
            d2 = (double)list2.size() * this.ppmContext.getCellWidth() + (double)(47 * n3);
            d4 = d + d2 + d3;
        }
        d6 = d4 + d8 * 2.0;
        d7 = d5 + d9 * 2.0;
        Rectangle rectangle = new Rectangle(0.0f, 0.0f, (float)d6, (float)d7);
        Document document = new Document(rectangle, 0.0f, 0.0f, 0.0f, 0.0f);
        document.addTitle("Phylogenetic Pattern Map");
        document.addAuthor("RECOG version 1.1.30");
        PdfWriter pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(string));
        document.open();
        PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
        for (int i = 0; i < list.size(); i += i == 0 ? n - 1 : n) {
            for (int j = 0; j < list2.size(); j += n2) {
                Graphics2D graphics2D = pdfContentByte.createGraphics((float)d6, (float)d7);
                pdfContentByte.saveState();
                graphics2D.setFont(this.createFont());
                graphics2D.translate(d8, d9);
                if (j == 0 && bl) {
                    graphics2D.translate(0.0, d10);
                    clusterTreeMap.drawPdf(graphics2D);
                    graphics2D.translate(d, -d10);
                }
                if (i == 0) {
                    this.drawHeader(graphics2D, d4, n2, j, d10);
                    graphics2D.translate(0.0, d10);
                }
                this.draw(graphics2D, d4, d5, i == 0 ? n - 1 : n, n2, i, j, true);
                if (bl2) {
                    graphics2D.translate(d2, 0.0);
                    categoryMap.drawPdf(graphics2D);
                }
                pdfContentByte.restoreState();
                graphics2D.dispose();
                document.newPage();
                if (i != 0) continue;
                graphics2D.translate(0.0, -d10);
            }
        }
        document.close();
    }

    public void setShowHomClustLabel(boolean bl) {
        this.ppmContext.setShowHomClustLabel(bl);
    }

    public boolean isShowHomClustLabel() {
        return this.ppmContext.isShowHomClustLabel();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.ppmImage != null) {
            graphics.drawImage(this.ppmImage, 0, 0, null);
        }
        this.drawDragArea((Graphics2D)graphics);
        this.drawSelectedArea((Graphics2D)graphics);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.optionTbl.getOptionValues().isIntensive() || this.clusterTbl == null) {
            return null;
        }
        double d = mouseEvent.getX();
        double d2 = mouseEvent.getY();
        if (d < 45.0 || this.clusterTbl.isOutgroup() && d > this.ppmContext.getImageWidth() - 45.0) {
            return null;
        }
        int n = this.ppmContext.getRowIndex((int)d2);
        if (n == -1) {
            return null;
        }
        List list = this.clusterTbl.getViewOrganismCodeList();
        Cluster cluster = (Cluster)this.clusterTbl.getViewClusterList().get(n);
        double d3 = this.ppmContext.getCellWidth();
        for (int i = 0; i < list.size() && i < this.ppmContext.getColumns(); ++i) {
            double d4 = (double)i * d3 + 45.0;
            if (!(d >= d4) || !(d < d4 + d3)) continue;
            String string = (String)list.get(i + this.ppmContext.getColumn());
            List list2 = cluster.getLocusTagList(string);
            if (list2 == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<HTML>");
            for (int j = 0; j < list2.size(); ++j) {
                if (j > 0) {
                    if (j % 5 == 0) {
                        stringBuffer.append("<BR>");
                    } else {
                        stringBuffer.append(", ");
                    }
                }
                stringBuffer.append((String)list2.get(j));
            }
            stringBuffer.append("</HTML>");
            return stringBuffer.toString();
        }
        return null;
    }

    @Override
    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return new Point(mouseEvent.getX(), mouseEvent.getY() + 20);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mediator.grabFocusOnClusterArea();
        if (this.clusterTbl == null) {
            return;
        }
        if (!OS.isWindows() && mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent.getPoint());
            this.popupFlagForMac = true;
            return;
        }
        this.m_y1 = mouseEvent.getY();
        this.m_y2 = mouseEvent.getY();
        this.selMode = 2;
        this.dragFlag = false;
        this.repaint();
    }

    private Organism getOrganism(Point point) {
        Organism organism = null;
        for (int i = 0; i < this.organismAreaList.size(); ++i) {
            ViewData viewData = (ViewData)this.organismAreaList.get(i);
            if (!viewData.getDataRect2D().contains(point.getX(), point.getY())) continue;
            organism = (Organism)viewData.getObject();
            break;
        }
        if (organism == null) {
            List list = this.clusterTbl.getViewOrganismList();
            if (this.ppmContext.isLeftGeneNameArea(point.x)) {
                organism = (Organism)list.get(0);
            } else if (this.ppmContext.isRightGeneNameArea(point.x) || this.ppmContext.isHomClusterArea(point.x)) {
                organism = (Organism)list.get(list.size() - 1);
            }
        }
        return organism;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.clusterTbl == null) {
            return;
        }
        if (OS.isWindows() && mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent.getPoint());
            return;
        }
        if (!OS.isWindows() && this.popupFlagForMac) {
            this.popupFlagForMac = false;
            return;
        }
        this.selMode = 1;
        if (!this.dragFlag) {
            List list;
            boolean bl = KeyBindUtil.isClickForMutliSelect(mouseEvent);
            boolean bl2 = KeyBindUtil.isClickForExtendSelect(mouseEvent);
            int n = this.ppmContext.getRowIndex(mouseEvent.getY());
            Organism organism = this.getOrganism(mouseEvent.getPoint());
            if (n != -1) {
                if (bl && bl2) {
                    if (this.anchorRow > 0) {
                        list = this.getSelectedClusters(mouseEvent, organism, this.anchorRow, this.leadRow);
                        this.mediator.updateSelectedCluster(organism.getOrganismCode(), list, bl);
                    }
                    if (this.anchorRow < 0) {
                        this.anchorRow = n;
                    }
                    this.leadRow = n;
                    list = this.getSelectedClusters(mouseEvent, organism, this.anchorRow, this.leadRow);
                    this.mediator.updateSelectedCluster(organism.getOrganismCode(), list, bl);
                } else if (bl && !bl2) {
                    this.anchorRow = n;
                    this.leadRow = n;
                    list = this.getSelectedClusters(mouseEvent, organism, this.anchorRow, this.leadRow);
                    this.mediator.updateSelectedCluster(organism.getOrganismCode(), list, bl);
                } else if (!bl && bl2) {
                    if (this.anchorRow < 0) {
                        this.anchorRow = n;
                    }
                    this.leadRow = n;
                    list = this.getSelectedClusters(mouseEvent, organism, this.anchorRow, this.leadRow);
                    this.mediator.updateSelectedCluster(organism.getOrganismCode(), list, bl);
                } else {
                    this.anchorRow = n;
                    this.leadRow = n;
                    list = this.getSelectedClusters(mouseEvent, organism, this.anchorRow, this.leadRow);
                    this.mediator.updateSelectedCluster(organism.getOrganismCode(), list, bl);
                }
            }
            if (this.getPpmSelectionManager().isExistSelectedCluster()) {
                list = this.getSelectedClusterList();
                this.mediator.setHighlightClusterOnGenomeMap(list);
                this.mediator.selectOrthologGroupOnCoreGenome(list);
                this.mediator.selectOrthologGroupOnGlobalAlign(list);
            }
        } else {
            this.dragFlag = false;
            if (MessageManager.showConfirmMessage((Component)this.getTopLevelAncestor(), "Limit display range?")) {
                double d = this.m_y1 < this.m_y2 ? (double)this.m_y1 : (double)this.m_y2;
                double d2 = this.m_y1 < this.m_y2 ? (double)this.m_y2 : (double)this.m_y1;
                int n = this.ppmContext.getRowIndex((int)d);
                int n2 = this.ppmContext.getRowIndex((int)d2);
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int i = n; i <= n2; ++i) {
                    arrayList.add(new Integer(i));
                }
                this.m_y1 = 0;
                this.m_y2 = 0;
                this.mediator.setLimitNoList(arrayList);
            } else {
                this.m_y1 = 0;
                this.m_y2 = 0;
                this.repaint();
            }
        }
    }

    public List getSelectedClusters(MouseEvent mouseEvent, Organism organism, int n, int n2) {
        List<Cluster> list = new ArrayList();
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        n3 = n3 < 0 ? n4 : n3;
        n4 = n4 < 0 ? n3 : n4;
        for (int i = n3; i <= n4; ++i) {
            ArrayList<Object> arrayList;
            if (OptionTbl.getInstance().getOptionValues().isIntensive()) {
                arrayList = this.clusterTbl.getClusterListForIntensiveBySamePattern(i);
            } else if (this.ppmContext.isHomClusterArea(mouseEvent.getX())) {
                arrayList = this.clusterTbl.getClusterListForExtensiveBySameHomClusterID(i);
            } else if (this.ppmContext.isRightGeneNameArea(mouseEvent.getX())) {
                list = this.clusterTbl.getClusterListForExtensiveBySameClusterID(i);
                arrayList = list;
            } else {
                Cluster cluster = this.clusterTbl.getViewCluster(i);
                arrayList = new ArrayList<Object>();
                if (this.clusterTbl.isOutgroup(organism)) {
                    arrayList.addAll(this.clusterTbl.getClusterListForExtensiveBySameClusterID(cluster));
                } else {
                    arrayList.add(cluster);
                }
            }
            for (Cluster cluster : arrayList) {
                if (list.contains(cluster)) continue;
                list.add(cluster);
            }
        }
        return list;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.selMode != 2) {
            return;
        }
        this.m_y2 = mouseEvent.getY();
        this.m_y2 = (int)(this.m_y2 < 0 ? 0.0 : ((double)this.m_y2 >= this.ppmContext.getImageHeight() ? this.ppmContext.getImageHeight() - 1.0 : (double)this.m_y2));
        if (!this.dragFlag && Math.abs(this.m_y2 - this.m_y1) < 5) {
            return;
        }
        this.dragFlag = true;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ((CommandImpl)actionEvent.getSource()).execute();
    }

    private void updateScaleCenter() {
        if (this.getPpmSelectionManager().getSelectedRowIndexSet().size() <= 0) {
            this.ppmContext.updateCenterRow();
        } else {
            int n = this.getPpmSelectionManager().getBaseRowIndex();
            if (n >= 0) {
                this.ppmContext.updateCenterRow(n);
            } else {
                this.ppmContext.updateCenterRow();
            }
        }
        List list = this.clusterTbl.getViewOrganismList();
        if (!this.getPpmSelectionManager().isExistSelectedOrganism()) {
            this.ppmContext.updateCenterColumn();
        }
        Set set = this.getPpmSelectionManager().getSelectedOrganismSet();
        for (int i = 0; i < list.size(); ++i) {
            Organism organism = (Organism)list.get(i);
            if (organism == null || !set.contains(organism.getOrganismCode())) continue;
            this.ppmContext.updateCenterColumn(i);
        }
    }

    private class ColorStore {
        protected Color borderLineColor;
        protected Color ingroupColor;
        protected Color outgroupColor;
        protected Color outergroupColor;
        protected Color searchResultColor;

        public ColorStore() {
            this.init();
        }

        private void init() {
            OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
            this.borderLineColor = ColorUtil.str2Color(optionValues.getBorderLineColorString());
            this.ingroupColor = ColorUtil.str2Color(optionValues.getIngroupColorString());
            this.outgroupColor = ColorUtil.str2Color(optionValues.getOutgroupColorString());
            this.searchResultColor = ColorUtil.str2Color(optionValues.getSearchResultColorString());
        }

        public Color getBackgroundCellColor(Organism organism) {
            return ClusterMap.this.clusterTbl.isOutgroup(organism.getOrganismCode()) ? this.outgroupColor : this.ingroupColor;
        }
    }
}

