/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.bean;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.controltree.ControlTree;
import cgdp.recog.controltree.SetTree;
import cgdp.recog.spgroup.SpGroupTree;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TreeOptionPanel
extends JPanel {
    static final int MODE_SELECT = 1;
    static final int MODE_CONTROL = 2;
    static final int MODE_SPGROUP = 3;
    private Frame parent;
    private MediatorImpl mediator;
    private JScrollPane scrollPaneForSetTree;
    private JScrollPane scrollPaneForControlTree;
    private JScrollPane scrollPaneForSpGroupTree;

    public TreeOptionPanel(Frame frame, MediatorImpl mediatorImpl) throws Exception {
        this.parent = frame;
        this.mediator = mediatorImpl;
        this.mediator.register(this);
        this.init();
    }

    private void init() throws Exception {
        SetTree setTree = new SetTree(this.parent, this.mediator);
        this.scrollPaneForSetTree = new JScrollPane(setTree);
        this.scrollPaneForSetTree.setBorder(null);
        ControlTree controlTree = new ControlTree(this.parent, this.mediator);
        this.scrollPaneForControlTree = new JScrollPane(controlTree);
        this.scrollPaneForControlTree.setBorder(null);
        SpGroupTree spGroupTree = new SpGroupTree(this.mediator);
        this.scrollPaneForSpGroupTree = new JScrollPane(spGroupTree);
        this.scrollPaneForSpGroupTree.setBorder(null);
        this.setLayout(new GridBagLayout());
    }

    public void showControlTree() {
        this.updateComponents(2);
    }

    public void showSpGroupTree() {
        this.updateComponents(3);
    }

    public void updateComponents(int n) {
        this.removeAll();
        if (TreeOptionPanel.isControlMode(n)) {
            this.add((Component)this.scrollPaneForControlTree, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else if (TreeOptionPanel.isSpGroupMode(n)) {
            this.add((Component)this.scrollPaneForSpGroupTree, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.add((Component)this.scrollPaneForSetTree, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.revalidate();
        this.repaint();
    }

    public static boolean isSelectMode(int n) {
        return n == 1;
    }

    public static boolean isControlMode(int n) {
        return n == 2;
    }

    public static boolean isSpGroupMode(int n) {
        return n == 3;
    }
}

