/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.color;

import cgdp.recog.align.GlobalAlignViewModel;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.color.BlankColorDrawable;
import cgdp.recog.color.ColorDrawable;
import cgdp.recog.color.ColorDrawableManager;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.organism.Organism;
import cgdp.recog.set.SetCondition;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ColorFacade {
    private static ColorFacade COLOR_FACADE;
    private ColorDrawableManager colorDrawableManager;
    private GlobalAlignViewModel globalAlignViewModel;

    private ColorFacade(MediatorImpl mediatorImpl) {
        this.colorDrawableManager = new ColorDrawableManager(mediatorImpl);
    }

    public static void createInstance(MediatorImpl mediatorImpl) {
        COLOR_FACADE = new ColorFacade(mediatorImpl);
    }

    public static ColorFacade getInstance() {
        return COLOR_FACADE;
    }

    public static void setClusterTbl(ClusterTbl clusterTbl) {
        if (ColorFacade.getInstance() == null) {
            return;
        }
        ColorFacade.getInstance().getColorDrawableManager().setClusterTbl(clusterTbl);
    }

    public List getColorOrderList() {
        return this.colorDrawableManager.getColorOrderList();
    }

    public ColorDrawableManager getColorDrawableManager() {
        return this.colorDrawableManager;
    }

    public Map getColorDrawableMap() {
        return this.colorDrawableManager.getColorDrawableMap();
    }

    public ColorDrawable getPrimaryColorDrawable(Cluster cluster, Organism organism) {
        return this.colorDrawableManager.getPrimaryColorDrawable(cluster, organism);
    }

    public Color getPrimaryColor(Cluster cluster, Organism organism, String string) {
        ColorDrawable colorDrawable = ColorFacade.getInstance().getPrimaryColorDrawable(cluster, organism);
        return colorDrawable.getColor(cluster, organism.getOrganismCode(), string);
    }

    public Color getBackgroundColor() {
        return BlankColorDrawable.getBackgroundColor();
    }

    public ColorDrawable getNextColorDrawable(ColorDrawable colorDrawable) {
        return this.colorDrawableManager.getNextColorDrawable(colorDrawable);
    }

    public ColorDrawable getNeighboringClusterColorDrawable() {
        return this.colorDrawableManager.getNeighboringClusterColorDrawable();
    }

    public void addNeighboringColorDrawable() {
        this.colorDrawableManager.addNeighboringColorDrawable();
    }

    public void addSearchColorDrawable() {
        this.colorDrawableManager.addSearchColorDrawable();
    }

    public void removeSearchColorDrawable() {
        this.colorDrawableManager.removeSearchColorDrawable();
    }

    public void addGeneInfoColorDrawable() {
        this.colorDrawableManager.addGeneInfoColorDrawable();
    }

    public void removeGeneInfoColorDrawable() {
        this.colorDrawableManager.removeGeneInfoColorDrawable();
    }

    public void addSetColorDrawable(SetCondition setCondition) {
        this.colorDrawableManager.addSetColorDrawable(setCondition);
    }

    public void addSetColorDrawable(Collection collection) {
        this.colorDrawableManager.addSetColorDrawable(collection);
    }

    public void removeSetColorDrawable(SetCondition setCondition) {
        this.colorDrawableManager.removeSetColorDrawable(setCondition);
    }

    public void removeSetColorDrawable(Collection collection) {
        this.colorDrawableManager.removeSetColorDrawable(collection);
    }

    public void setAlignmentViewModel(GlobalAlignViewModel globalAlignViewModel) {
        this.globalAlignViewModel = globalAlignViewModel;
    }

    public void updateOrder(int n, List list) {
        this.colorDrawableManager.updateOrder(n, list);
        this.updateOrder();
    }

    public void updateOrder() {
        if (this.globalAlignViewModel != null) {
            this.globalAlignViewModel.updateViewGlobalAlignGroupListOrder();
        }
    }

    public Color getBlankColor(String string) {
        return this.colorDrawableManager.getBlankColor(string);
    }

    public void saveColor() throws Exception {
        this.colorDrawableManager.saveColor();
    }

    public boolean containsSetCondition(SetCondition setCondition) {
        return this.colorDrawableManager.containsSetCondition(setCondition);
    }

    public static void clearCondition() {
        if (ColorFacade.getInstance() == null) {
            return;
        }
        ColorFacade.getInstance().getColorDrawableManager().clearCondition();
    }
}

