/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.color;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.color.AbstractColorDrawable;
import cgdp.recog.color.ColorFacade;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.SuperCluster;
import cgdp.recog.organism.Organism;
import cgdp.recog.set.SetCondition;
import cgdp.recog.set.cluster.ClusterSetCondition;
import cgdp.recog.set.gene.GeneSetCondition;
import cgdp.recog.util.GeneUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Map;

class SetColorDrawable
extends AbstractColorDrawable {
    private SetCondition setCondition;

    SetColorDrawable(MediatorImpl mediatorImpl, int n, SetCondition setCondition) {
        super(mediatorImpl, n);
        this.setCondition = setCondition;
    }

    public SetCondition getSetCondition() {
        return this.setCondition;
    }

    @Override
    public String getNodeLabel() {
        return this.setCondition.getDisplayName();
    }

    @Override
    public void setColorActive(boolean bl) {
        this.setCondition.setColorActive(bl);
    }

    @Override
    public boolean isColorActive() {
        return this.setCondition.isColorActive();
    }

    @Override
    public boolean isEnableDraw(Cluster cluster, Organism organism) {
        if (cluster == null) {
            return false;
        }
        if (!this.setCondition.isColorActive()) {
            return false;
        }
        Cluster cluster2 = cluster;
        if (cluster instanceof SuperCluster) {
            cluster2 = (Cluster)((SuperCluster)cluster).getSubClusterList().get(0);
        }
        return this.setCondition.containsByColorCondition(cluster2, organism.getOrganismCode());
    }

    @Override
    public Color drawPPMCell(Graphics2D graphics2D, double d, double d2, double d3, double d4, Cluster cluster, Organism organism, Map map) {
        Color color = Color.black;
        String string = organism.getOrganismCode();
        Cluster cluster2 = cluster;
        if (cluster instanceof SuperCluster) {
            cluster2 = (Cluster)((SuperCluster)cluster).getSubClusterList().get(0);
        }
        if (this.setCondition.isClusterSet()) {
            ClusterSetCondition clusterSetCondition = (ClusterSetCondition)this.setCondition;
            if (!clusterSetCondition.isMatch(cluster2)) {
                color = ColorFacade.getInstance().getBlankColor(string);
                graphics2D.setColor(color);
                graphics2D.fill(new Rectangle2D.Double(d, d2, d3, d4));
                return color;
            }
            color = clusterSetCondition.getColor(cluster2, string);
            graphics2D.setColor(color);
            graphics2D.fill(new Rectangle2D.Double(d, d2, d3, d4));
        } else if (this.setCondition.isGeneSet()) {
            GeneSetCondition geneSetCondition = (GeneSetCondition)this.setCondition;
            if (!geneSetCondition.containsByColorCondition(cluster2, string)) {
                color = ColorFacade.getInstance().getBlankColor(string);
                graphics2D.setColor(color);
                graphics2D.fill(new Rectangle2D.Double(d, d2, d3, d4));
                return color;
            }
            Map map2 = geneSetCondition.getColorLocusTagMap(string, cluster.getLocusTagList(string));
            if (!map2.isEmpty()) {
                if (map2.size() == 1 && ((List)map2.values().iterator().next()).size() == cluster.getGeneInformationList(string).size()) {
                    color = (Color)map2.keySet().iterator().next();
                    graphics2D.setColor(color);
                    graphics2D.fill(new Rectangle2D.Double(d, d2, d3, d4));
                } else {
                    List list = cluster.getGeneInformationList(string);
                    double d5 = d4 / (double)list.size();
                    double d6 = d2;
                    boolean bl = true;
                    for (Color color2 : map2.keySet()) {
                        if (bl) {
                            color = color2;
                            bl = false;
                        }
                        List list2 = (List)map2.get(color2);
                        double d7 = d5 * (double)list2.size();
                        graphics2D.setColor(color2);
                        graphics2D.fill(new Rectangle2D.Double(d, d6, d3, d7));
                        d6 += d7;
                    }
                }
            }
        }
        return color;
    }

    @Override
    public Color getColor(Cluster cluster, String string, String string2) {
        Color color;
        if (this.setCondition.isClusterSet()) {
            ClusterSetCondition clusterSetCondition = (ClusterSetCondition)this.setCondition;
            color = clusterSetCondition.getColor(cluster, string);
        } else {
            GeneSetCondition geneSetCondition = (GeneSetCondition)this.setCondition;
            color = geneSetCondition.isMatchColor(string, GeneUtil.removeDomainNo(string2));
        }
        if (color == null) {
            color = ColorFacade.getInstance().getBlankColor(string);
        }
        return color;
    }

    @Override
    public void drawPPMLabel(Graphics2D graphics2D, Cluster cluster, Organism organism, double d, double d2, double d3, double d4, double d5, double d6, int n, Color color) {
        String string = organism.getOrganismCode();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        List list = cluster.getLocusTagList(string);
        if (this.clusterTbl.isEnableSetColor() && this.setCondition.isGeneSet()) {
            GeneSetCondition geneSetCondition = (GeneSetCondition)this.setCondition;
            Map map = geneSetCondition.getColorLocusTagMap(string, cluster.getLocusTagList(string));
            if (map.size() == 1) {
                this.drawLocusTag(graphics2D, d4, n -= (list.size() - 1) * fontMetrics.getAscent() / 2, d, list, color);
            } else {
                List list2 = cluster.getGeneInformationList(string);
                double d7 = this.clusterTbl.isOutgroup(string) ? d3 : d2;
                double d8 = d7 / (double)list2.size();
                double d9 = this.clusterTbl.isOutgroup(string) ? d6 : d5;
                for (Color color2 : map.keySet()) {
                    List list3 = (List)map.get(color2);
                    double d10 = d8 * (double)list3.size();
                    int n2 = (int)(d9 + d10 / 2.0 - (double)((list3.size() - 1) * fontMetrics.getAscent()) / 2.0 + (double)fontMetrics.getDescent());
                    this.drawLocusTag(graphics2D, d4, n2, d, list3, color);
                    d9 += d10;
                }
            }
        } else {
            this.drawLocusTag(graphics2D, d4, n -= (list.size() - 1) * fontMetrics.getAscent() / 2, d, list, color);
        }
    }

    @Override
    public boolean isSyncEnable() {
        return this.setCondition.isSyncEnable();
    }
}

