/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.controltree;

public class ControlTitleType {
    public static final int NO_SELECT = -1;
    public static final int FILTER = 10;
    public static final int FILTER_TAXONOMY = 11;
    public static final int FILTER_COUNT = 12;
    public static final int FILTER_SEARCH = 13;
    public static final int FILTER_GENE_SET = 14;
    public static final int FILTER_CLUSTER_SET = 15;
    public static final int FILTER_TAXMAP = 16;
    public static final int FILTER_FUNCCAT = 17;
    public static final int ORGANISM_COLUMN = 80;
    public static final int ORGANISM_SET = 82;
    public static final int SORT = 20;
    public static final int COLOR = 30;
    public static final int COLOR_GENE_COUNT = 31;
    public static final int COLOR_GENE_INFO = 32;
    public static final int COLOR_SEARCH = 34;
    public static final int COLOR_NEIGHBOR = 35;
    public static final int COLOR_GENE_SET = 36;
    public static final int COLOR_CLUSTER_SET = 37;
    public static final int COLOR_FUNCCAT = 38;
    public static final int COLOR_HOMCLUST = 39;
    public static final int COLOR_DEFAULT = 930;
    public static final int COLOR_BLANK = 931;
    public static final int GENE_SET = 50;
    public static final int CLUSTER_SET = 60;
    public static final int GENE_SET_COMBINATION = 70;
    public static final int CLUSTER_SET_COMBINATION = 80;
    public static final int PATTERN = 100;
    public static final String NAME_FILTER = "Filter";
    public static final String NAME_FILTER_TAXONOMY = "Taxonomy Filter";
    public static final String NAME_FILTER_COUNT = "Gene/Organism Count Filter";
    public static final String NAME_FILTER_SEARCH = "Keyword Search";
    public static final String NAME_FILTER_GENE_SET = "Gene Set Filter";
    public static final String NAME_FILTER_CLUSTER_SET = "Cluster Set Filter";
    public static final String NAME_FILTER_TAXMAP = "Taxonomy Mapping Filter";
    public static final String NAME_FILTER_FUNCCAT = "Function Category Filter";
    public static final String NAME_ORGANISM_COLUMN = "Organism Column";
    public static final String NAME_SORT = "Sort";
    public static final String NAME_COLOR = "Color";
    public static final String NAME_COLOR_GENE_COUNT = "Gene Count";
    public static final String NAME_COLOR_GENE_SET = "Gene Set";
    public static final String NAME_COLOR_CLUSTER_SET = "Cluster Set";
    public static final String NAME_GENE_SET = "Gene Set";
    public static final String NAME_GENE_SET_COMBINATION = "Gene Set Combination";
    public static final String NAME_CLUSTER_SET = "Cluster Set";
    public static final String NAME_CLUSTER_SET_COMBINATION = "Cluster Set Combination";
    public static final String NAME_ORGANISM_SET = "Organism Set";
    public static final String NAME_PATTERN = "Phylogenetic Pattern";

    private ControlTitleType() {
    }

    public static boolean isNoSelect(int n) {
        return n == -1;
    }

    public static boolean isFilter(int n) {
        return n == 10;
    }

    public static boolean isFilterTaxonomy(int n) {
        return n == 11;
    }

    public static boolean isFilterCount(int n) {
        return n == 12;
    }

    public static boolean isFilterSearch(int n) {
        return n == 13;
    }

    public static boolean isFilterGeneSet(int n) {
        return n == 14;
    }

    public static boolean isFilterClusterSet(int n) {
        return n == 15;
    }

    public static boolean isFilterTaxMap(int n) {
        return n == 16;
    }

    public static boolean isFilterFuncCat(int n) {
        return n == 17;
    }

    public static boolean isOrganismColumn(int n) {
        return n == 80;
    }

    public static boolean isOrganismSet(int n) {
        return n == 82;
    }

    public static boolean isPattern(int n) {
        return n == 100;
    }

    public static boolean isSort(int n) {
        return n == 20;
    }

    public static boolean isColor(int n) {
        return n == 30;
    }

    public static boolean isColorAll(int n) {
        return ControlTitleType.isColor(n) || ControlTitleType.isColorClusterSet(n) || ControlTitleType.isColorGeneSet(n) || ControlTitleType.isColorGeneCount(n) || ControlTitleType.isColorGeneInfo(n) || ControlTitleType.isColorNeighbor(n) || ControlTitleType.isColorSearch(n) || ControlTitleType.isColorDefault(n);
    }

    public static boolean isColorGeneCount(int n) {
        return n == 31;
    }

    public static boolean isColorGeneInfo(int n) {
        return n == 32;
    }

    public static boolean isColorSearch(int n) {
        return n == 34;
    }

    public static boolean isColorNeighbor(int n) {
        return n == 35;
    }

    public static boolean isColorGeneSet(int n) {
        return n == 36;
    }

    public static boolean isColorClusterSet(int n) {
        return n == 37;
    }

    public static boolean isColorDefault(int n) {
        return n == 930;
    }

    public static boolean isGeneSet(int n) {
        return n == 50;
    }

    public static boolean isClusterSet(int n) {
        return n == 60;
    }

    public static boolean isGeneSetCombination(int n) {
        return n == 70;
    }

    public static boolean isClusterSetCombination(int n) {
        return n == 80;
    }
}

