/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.controltree;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.color.ColorFacade;
import cgdp.recog.controltree.ControlTitleNode;
import cgdp.recog.controltree.ControlTitleType;
import cgdp.recog.controltree.ControlTree;
import cgdp.recog.ppm.OrganismTreeNode;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.StringTool;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

class ControlTreeTransferHandler
extends TransferHandler {
    private static final ApplicationLogger logger = new ApplicationLogger(ControlTreeTransferHandler.class);
    private static final String TAG_COLOR = "<<COLOR>>";
    private static final String DELIMITER = ":";
    private static final String TAG_ORGANISM_COLUMN = "<<ORGANISM_COLUMN>>";
    private MediatorImpl mediator;

    ControlTreeTransferHandler(MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!DataFlavor.stringFlavor.equals(dataFlavorArray[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        JTree jTree = (JTree)jComponent;
        TreePath[] treePathArray = jTree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return null;
        }
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < treePathArray.length; ++i) {
            if (treePathArray[i].getPathCount() != 3) continue;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            arrayList.add(defaultMutableTreeNode);
        }
        if (CollectionUtil.isNull(arrayList)) {
            return null;
        }
        if (this.isEnableColorMove(treePathArray)) {
            return new StringSelection(this.createColorTransferable(treePathArray));
        }
        if (this.isEnableOrganismColumnMove(treePathArray)) {
            return new StringSelection(this.createOrganismColumnTransferable(treePathArray));
        }
        return null;
    }

    private boolean isEnableColorMove(TreePath[] treePathArray) {
        for (int i = 0; i < treePathArray.length; ++i) {
            if (treePathArray[i].getPathCount() != 3) {
                return false;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getPathComponent(1);
            if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
                return false;
            }
            ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
            if (ControlTitleType.isColor(controlTitleNode.getControlTitleType())) continue;
            return false;
        }
        return true;
    }

    private String createColorTransferable(TreePath[] treePathArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TAG_COLOR);
        for (int i = 0; i < treePathArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            if (!(defaultMutableTreeNode instanceof ControlTitleNode)) continue;
            ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
            stringBuffer.append(controlTitleNode.getControlTitleType());
            if (i == treePathArray.length - 1) continue;
            stringBuffer.append(DELIMITER);
        }
        stringBuffer.append(TAG_COLOR);
        return stringBuffer.toString();
    }

    private boolean isEnableOrganismColumnMove(TreePath[] treePathArray) {
        for (int i = 0; i < treePathArray.length; ++i) {
            if (treePathArray[i].getPathCount() != 3) {
                return false;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getPathComponent(1);
            if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
                return false;
            }
            ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
            if (ControlTitleType.isOrganismColumn(controlTitleNode.getControlTitleType())) continue;
            return false;
        }
        return true;
    }

    private String createOrganismColumnTransferable(TreePath[] treePathArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TAG_ORGANISM_COLUMN);
        for (int i = 0; i < treePathArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            if (!(defaultMutableTreeNode instanceof OrganismTreeNode)) continue;
            OrganismTreeNode organismTreeNode = (OrganismTreeNode)defaultMutableTreeNode;
            stringBuffer.append(organismTreeNode.getDisplayOrganism().getOrganismCode());
            if (i == treePathArray.length - 1) continue;
            stringBuffer.append(DELIMITER);
        }
        stringBuffer.append(TAG_ORGANISM_COLUMN);
        return stringBuffer.toString();
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 2;
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        try {
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            if (string.indexOf(TAG_COLOR) != -1) {
                ControlTree controlTree = (ControlTree)jComponent;
                return this.importDataForColor(controlTree, string);
            }
            if (string.indexOf(TAG_ORGANISM_COLUMN) != -1) {
                ControlTree controlTree = (ControlTree)jComponent;
                return this.importDataForOrganismColumn(controlTree, string);
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean importDataForColor(ControlTree controlTree, String string) {
        Object object2;
        if (StringTool.isNull(string = string.replaceAll(TAG_COLOR, ""))) {
            return false;
        }
        Vector vector = StringTool.splitString(string, DELIMITER);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Object object2 : vector) {
            try {
                int n = Integer.parseInt((String)object2);
                arrayList.add(new Integer(n));
            }
            catch (NumberFormatException numberFormatException) {
                logger.warn("Fail to drag & drap a color node. " + (String)object2);
            }
        }
        List list = controlTree.getControlTitleNodeList(arrayList);
        if (CollectionUtil.isNull(list)) {
            return false;
        }
        object2 = controlTree.getSelectionPath();
        if (object2 == null) {
            return false;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((TreePath)object2).getLastPathComponent();
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
        if (!ControlTitleType.isColorAll(controlTitleNode.getControlTitleType())) {
            return false;
        }
        ColorFacade colorFacade = ColorFacade.getInstance();
        colorFacade.updateOrder(controlTitleNode.getControlTitleType(), arrayList);
        this.mediator.updateColorTree();
        this.mediator.resizeClusterMap();
        return true;
    }

    private boolean importDataForOrganismColumn(ControlTree controlTree, String string) {
        Object object2;
        if (StringTool.isNull(string = string.replaceAll(TAG_ORGANISM_COLUMN, ""))) {
            return false;
        }
        Vector vector = StringTool.splitString(string, DELIMITER);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object2 : vector) {
            arrayList.add((String)object2);
        }
        if (CollectionUtil.isNull(arrayList)) {
            return false;
        }
        TreePath treePath = controlTree.getSelectionPath();
        if (treePath == null) {
            return false;
        }
        object2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (!(object2 instanceof ControlTitleNode) && !(object2 instanceof OrganismTreeNode)) {
            return false;
        }
        List list = controlTree.getOrganismCodeList();
        String string2 = null;
        if (object2 instanceof OrganismTreeNode) {
            string2 = ((OrganismTreeNode)object2).getDisplayOrganism().getOrganismCode();
        }
        if (arrayList.contains(string2)) {
            return false;
        }
        list.removeAll(arrayList);
        int n = 0;
        if (string2 != null) {
            n = list.indexOf(string2) + 1;
        }
        list.addAll(n, arrayList);
        this.mediator.chnageOrderOrganismColumn(list);
        return true;
    }
}

