/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.coregenome.CoreGenomeGeneInfo;
import cgdp.recog.coregenome.GenomeAlign;
import cgdp.recog.coregenome.OrthologGroup;
import cgdp.recog.coregenome.OrthologSpNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClusterSorter {
    private static final double CLUSTER_DIRECTION_CUTOFF_POSITION_LENGTH = 10.0;
    private GenomeAlign genomeAlign;
    private String referenceOrganismCode;

    ClusterSorter(GenomeAlign genomeAlign, String string) {
        this.genomeAlign = genomeAlign;
        this.referenceOrganismCode = string;
    }

    void sortCluster() {
        ClusterPosition clusterPosition;
        Object object2;
        HashMap<Integer, ClusterPosition> hashMap = new HashMap<Integer, ClusterPosition>();
        for (Object object2 : this.genomeAlign.getOrthologGroupList()) {
            OrthologSpNode orthologSpNode;
            int n = ((OrthologGroup)object2).getClusterNo();
            clusterPosition = (ClusterPosition)hashMap.get(new Integer(n));
            if (clusterPosition == null) {
                clusterPosition = new ClusterPosition(n);
                hashMap.put(new Integer(n), clusterPosition);
            }
            if ((orthologSpNode = ((OrthologGroup)object2).getOrthologSpNode(this.referenceOrganismCode)) == null) continue;
            CoreGenomeGeneInfo coreGenomeGeneInfo = (CoreGenomeGeneInfo)orthologSpNode.getGeneInfoList().get(0);
            clusterPosition.addPosition(coreGenomeGeneInfo.getPosition());
        }
        ArrayList arrayList = new ArrayList(hashMap.values());
        this.calcClusterPosition(arrayList);
        Collections.sort(arrayList, new ClusterPositionComparator());
        object2 = new ArrayList();
        Object object3 = arrayList.iterator();
        while (object3.hasNext()) {
            clusterPosition = (ClusterPosition)object3.next();
            object2.add(new Integer(clusterPosition.getClusterNo()));
        }
        object3 = this.sortOrthologGroup(arrayList);
        this.genomeAlign.updateOrthologGroupList((List)object3);
    }

    private List sortOrthologGroup(List list) {
        Map map = this.genomeAlign.createClusterOrthologGroupMap();
        int n = 0;
        ArrayList arrayList = new ArrayList();
        for (ClusterPosition clusterPosition : list) {
            List list2 = (List)map.get(new Integer(clusterPosition.getClusterNo()));
            this.setClusterPosition(list2, n);
            this.updateOrthologGroupDirection(list2);
            arrayList.addAll(list2);
            ++n;
        }
        return arrayList;
    }

    private void setClusterPosition(List list, int n) {
        for (OrthologGroup orthologGroup : list) {
            orthologGroup.setClusterPosition(n);
        }
    }

    private void updateOrthologGroupDirection(List list) {
        int n = this.calcClusterDirection(list);
        if (n < 0) {
            Collections.reverse(list);
            for (OrthologGroup orthologGroup : list) {
                orthologGroup.setDirection(orthologGroup.getDirection() * -1);
            }
        }
    }

    private int calcClusterDirection(List list) {
        double d = 0.0;
        boolean bl = true;
        int n = 0;
        for (OrthologGroup orthologGroup : list) {
            OrthologSpNode orthologSpNode = orthologGroup.getOrthologSpNode(this.referenceOrganismCode);
            if (orthologSpNode == null) continue;
            CoreGenomeGeneInfo coreGenomeGeneInfo = (CoreGenomeGeneInfo)orthologSpNode.getGeneInfoList().get(0);
            double d2 = coreGenomeGeneInfo.getPosition();
            if (bl) {
                d = d2;
                bl = false;
                continue;
            }
            double d3 = d2 - d;
            if (Math.abs(d3) >= 10.0) {
                d = d2;
                continue;
            }
            n = d3 > 0.0 ? ++n : --n;
            d = d2;
        }
        if (n > 0) {
            return 1;
        }
        return -1;
    }

    private void calcClusterPosition(List list) {
        for (ClusterPosition clusterPosition : list) {
            clusterPosition.calcClusterPosition();
        }
    }

    private class ClusterPositionComparator
    implements Comparator {
        private ClusterPositionComparator() {
        }

        public int compare(Object object, Object object2) {
            ClusterPosition clusterPosition = (ClusterPosition)object;
            ClusterPosition clusterPosition2 = (ClusterPosition)object2;
            double d = clusterPosition.getClusterPosition() - clusterPosition2.getClusterPosition();
            if (d > 0.0) {
                return 1;
            }
            if (d < 0.0) {
                return -1;
            }
            return 0;
        }
    }

    private class ClusterPosition {
        private int clusterNo;
        private double sumPositive = 0.0;
        private double sumNegative = 0.0;
        private int positiveCount = 0;
        private int negativeCount = 0;
        private double clusterPosition = 0.0;

        public ClusterPosition(int n) {
            this.clusterNo = n;
        }

        public void addPosition(double d) {
            if (d > 0.0) {
                this.sumPositive += d;
                ++this.positiveCount;
            } else {
                this.sumNegative += d;
                ++this.negativeCount;
            }
        }

        public double getClusterPosition() {
            return this.clusterPosition;
        }

        private void calcClusterPosition() {
            this.clusterPosition = 0.0;
            if (this.negativeCount >= this.positiveCount && this.negativeCount >= 1) {
                this.clusterPosition = this.sumNegative / (double)this.negativeCount;
            } else if (this.negativeCount < this.positiveCount && this.positiveCount >= 1) {
                this.clusterPosition = this.sumPositive / (double)this.positiveCount;
            }
        }

        public int getClusterNo() {
            return this.clusterNo;
        }
    }
}

