/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.coregenome.CoreCommonParamDTO;
import cgdp.recog.data.SpGroupTbl;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismViewModel;
import cgdp.recog.spgroup.SpGroups;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CoreGenomeAlignmentCondition {
    private static final double DEFAULT_ORTHOLOG_RATIO = 0.5;
    private static final double DEFAULT_CONNECTION_RATIO = 0.5;
    private static final int DEFAULT_NEIGHBOR_WINDOW_ALIGN_SIZE = 20;
    private static final int DEFAULT_NEIGHBOR_WINDOW_SIZE = 20;
    private static final int DEFAULT_ORGANISM_NAME_TYPE = 2;
    private static final boolean DEFAULT_ADD_STRAIN_TO_NAME = true;
    private static final double DEFAULT_MIN_SP_COV = 0.5;
    private static final double DEFAULT_SP_COV_REG_CUT = 20.0;
    private static final double DEFAULT_SP_COV_SP_RATIO = 0.5;
    private static final int DEFAULT_MIN_CLUST_SIZ = 10;
    private String domClustId;
    private String clusterViewId;
    private String domClustName;
    private Organism referenceOrganism;
    private List organismList;
    private List viewOrganismList;
    private double orthologRate = 0.5;
    private double connectionRate = 0.5;
    private boolean useSpGroup = true;
    private double minSpCov = 0.5;
    private double spCovRegCut = 20.0;
    private double spCovSpRatio = 0.5;
    private int minClustSiz = 10;
    private String otherOptions = "";
    private int neighborWindowSize = 20;
    private int neighborWindowAlignSize = 20;
    private int viewOrthologGroupStartIndexOnMain;
    private int organismNameType = 2;
    private int orthologGroupLabelType = 3;
    private boolean addStrainToName = true;
    private boolean updateParameterFlag = true;
    private boolean forViewFlag = false;

    public String getDomClustName() {
        return this.domClustName;
    }

    public void setDomClustName(String string) {
        this.domClustName = string;
    }

    public String getDomClustId() {
        return this.domClustId;
    }

    public void setDomClustId(String string) {
        this.domClustId = string;
    }

    public String getClusterViewId() {
        return this.clusterViewId;
    }

    public void setClusterViewId(String string) {
        this.clusterViewId = string;
    }

    public Organism getReferenceOrganism() {
        return this.referenceOrganism;
    }

    public void setReferenceOrganism(Organism organism) {
        this.referenceOrganism = organism;
    }

    public void setReferenceOrganismCode(String string) {
        for (Organism organism : this.organismList) {
            if (!organism.equalsOrganismCode(string)) continue;
            this.setReferenceOrganism(organism);
            break;
        }
    }

    public List getOrganismList() {
        return this.organismList;
    }

    public void setOrganismList(List list) {
        this.organismList = list;
    }

    private Map createOrganismMap() {
        HashMap<String, Organism> hashMap = new HashMap<String, Organism>();
        for (Organism organism : this.organismList) {
            hashMap.put(organism.getOrganismCode(), organism);
        }
        return hashMap;
    }

    public List getViewOrganismList() {
        return this.viewOrganismList;
    }

    public List getViewOrganismCodeList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Organism organism : this.viewOrganismList) {
            arrayList.add(organism.getOrganismCode());
        }
        return arrayList;
    }

    public void setViewOrganismList(List list) {
        this.viewOrganismList = list;
    }

    public void setViewOrganismCodeList(List list) {
        Map map = this.createOrganismMap();
        this.viewOrganismList = new ArrayList();
        for (String string : list) {
            Organism organism = (Organism)map.get(string);
            this.viewOrganismList.add(organism);
        }
    }

    public double getOrthologRate() {
        return this.orthologRate;
    }

    public void setOrthologRate(double d) {
        this.orthologRate = d;
    }

    public double getConnectionRate() {
        return this.connectionRate;
    }

    public void setConnectionRate(double d) {
        this.connectionRate = d;
    }

    public double getMinSpCov() {
        return this.minSpCov;
    }

    public void setMinSpCov(double d) {
        this.minSpCov = d;
    }

    public double getSpCovRegCut() {
        return this.spCovRegCut;
    }

    public void setSpCovRegCut(double d) {
        this.spCovRegCut = d;
    }

    public double getSpCovSpRatio() {
        return this.spCovSpRatio;
    }

    public void setSpCovSpRatio(double d) {
        this.spCovSpRatio = d;
    }

    public int getMinClustSiz() {
        return this.minClustSiz;
    }

    public void setMinClustSiz(int n) {
        this.minClustSiz = n;
    }

    public String getOtherOptions() {
        return this.otherOptions;
    }

    public void setOtherOptions(String string) {
        this.otherOptions = string;
    }

    public boolean isUseSpGroup() {
        return this.useSpGroup;
    }

    public void setUseSpGroup(boolean bl) {
        this.useSpGroup = bl;
    }

    public int getWindowSize() {
        return this.getNeighborWindowSize();
    }

    public void setWindowSize(int n) {
        this.setNeighborWindowSize(n);
        this.setNeighborWindowAlignSize(n);
    }

    int getNeighborWindowAlignSize() {
        return this.neighborWindowAlignSize;
    }

    private void setNeighborWindowAlignSize(int n) {
        this.neighborWindowAlignSize = n;
    }

    int getNeighborWindowSize() {
        return this.neighborWindowSize;
    }

    private void setNeighborWindowSize(int n) {
        this.neighborWindowSize = n;
    }

    public String getReferenceOrganismCode() {
        return this.referenceOrganism.getOrganismCode();
    }

    public int getViewOrthologGroupStartIndexOnMain() {
        return this.viewOrthologGroupStartIndexOnMain;
    }

    public void setViewOrthologGroupStartIndexOnMain(int n) {
        this.viewOrthologGroupStartIndexOnMain = n;
    }

    public int getOrganismNameType() {
        return this.organismNameType;
    }

    public void setOrganismNameType(int n) {
        this.organismNameType = n;
    }

    public int getOrthologGroupLabelType() {
        return this.orthologGroupLabelType;
    }

    public void setOrthologGroupLabelType(int n) {
        this.orthologGroupLabelType = n;
    }

    public boolean isAddStrainToName() {
        return this.addStrainToName;
    }

    public void setAddStrainToName(boolean bl) {
        this.addStrainToName = bl;
    }

    public boolean isUpdateParameterFlag() {
        return this.updateParameterFlag;
    }

    public void setUpdateParameterFlag(boolean bl) {
        this.updateParameterFlag = bl;
    }

    public Set getOutgroupSpSet() {
        return CoreGenomeAlignmentCondition.createOutgroupSpSet(this.organismList);
    }

    private static Set createOutgroupSpSet(List list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Organism organism : list) {
            if (!organism.isOutgroup()) continue;
            hashSet.add(organism.getOrganismCode());
        }
        return hashSet;
    }

    public boolean isExistSpGroup() {
        SpGroupTbl spGroupTbl = SpGroupTbl.getInstance();
        return spGroupTbl.getSpGroups().isExistSpGroup();
    }

    public SpGroups getSpGroups() {
        SpGroupTbl spGroupTbl = SpGroupTbl.getInstance();
        return spGroupTbl.getSpGroups();
    }

    public boolean isForViewFlag() {
        return this.forViewFlag;
    }

    public void setForViewFlag(boolean bl) {
        this.forViewFlag = bl;
    }

    private OrganismViewModel createOrganismViewModel() {
        OrganismViewModel organismViewModel = new OrganismViewModel();
        organismViewModel.setAddStrainToName(this.isAddStrainToName());
        organismViewModel.setOrganismNameType(this.getOrganismNameType());
        organismViewModel.setViewOrganismList(new ArrayList(this.getViewOrganismList()));
        return organismViewModel;
    }

    public CoreCommonParamDTO createCoreCommonParamDTO() {
        CoreCommonParamDTO coreCommonParamDTO = new CoreCommonParamDTO();
        coreCommonParamDTO.setReferenceOrganism(this.getReferenceOrganism());
        coreCommonParamDTO.setOrganismViewModel(this.createOrganismViewModel());
        return coreCommonParamDTO;
    }

    boolean updateByCoreCommonParamDTO(CoreCommonParamDTO coreCommonParamDTO) {
        if (coreCommonParamDTO == null) {
            return false;
        }
        if (!coreCommonParamDTO.isUpdate(this.getReferenceOrganism(), this.getViewOrganismList(), this.isAddStrainToName(), this.getOrganismNameType())) {
            return false;
        }
        coreCommonParamDTO.setFinish(true);
        this.setReferenceOrganism(coreCommonParamDTO.getReferenceOrganism());
        this.setViewOrganismList(coreCommonParamDTO.getViewOrganismList());
        this.setAddStrainToName(coreCommonParamDTO.isAddStrainToName());
        this.setOrganismNameType(coreCommonParamDTO.getOrganismNameType());
        return true;
    }
}

