/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.coregenome.GenomeAlign;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;

public class CoreGenomeContext {
    protected static final String FONT_NAME = "Times New Roman";
    protected static final int FONT_STYLE = 3;
    private static final double DEFAULT_CANVAS_WIDTH = 500.0;
    private static final double DEFAULT_CANVAS_HEIGHT = 500.0;
    private static final double DEFAULT_MARGIN_TOP = 10.0;
    private static final double DEFAULT_MARGIN_BOTTOM = 10.0;
    private static final double DEFAULT_MARGIN_LEFT = 10.0;
    private static final double DEFAULT_MARGIN_RIGHT = 10.0;
    private static final double DEFAULT_ORGANISM_NAME_INTERVAL_X = 6.0;
    private static final float DEFAULT_GENE_NAME_ANGLE = 0.7853982f;
    private static final double DEFAULT_GENE_NAME_INTERVAL_Y = 6.0;
    private static final double DEFAULT_DIRECTION_HEIGHT = 12.0;
    private static final double DEFAULT_DIRECTION_INTERVAL_Y = 6.0;
    private static final float DEFAULT_DIRECTION_LINE_WIDTH = 1.0f;
    private static final double DEFAULT_GENE_NODE_SIZE = 12.0;
    private static final double DEFAULT_GENE_NODE_INTERVAL_Y = 10.0;
    private static final double DEFAULT_ORTHOLOGGROUP_INTERVAL_X = 10.0;
    private static final double SCALE_CONNECTION_THICK = 0.3;
    private static final double SCALE_CONNECTION_POLY_THICK = 0.1;
    private static final double DEFAULT_SCALE_X = 1.0;
    private static final double DEFAULT_SCALE_Y = 1.0;
    private static final boolean DEFAULT_RESIZE_FLAG = false;
    private static final int DEFAULT_CLUSTER_BLANK_COUNT = 1;
    private static final int DEFAULT_ORTHOLOGGROUP_START_INDEX = 0;
    private static final boolean DEFAULT_DRAW_DIRECTION_BORDER_FLAG = true;
    private static final double DEFAULT_CONNECTION_DEPTH_PAR_ONE = 1.0;
    private static final double DEFAULT_CONNECTION_MARGIN_Y = 2.0;
    private static final double MIN_CLUSTER_BLANK_WIDTH = 5.0;
    private static final double MIN_GENE_NODE_SIZE = 3.0;
    private double canvasWidth = 500.0;
    private double canvasHeight = 500.0;
    private double marginTop = 10.0;
    private double marginBottom = 10.0;
    private double marginLeft = 10.0;
    private double marginRight = 10.0;
    private double baseMarginTop = 10.0;
    private double baseMarginBottom = 10.0;
    private double baseMarginLeft = 10.0;
    private double baseMarginRight = 10.0;
    private double organismNameIntervalX = 6.0;
    private float geneNameAngle = 0.7853982f;
    private double geneNameIntervalY = 6.0;
    private double directionHeight = 12.0;
    private double directionIntervalY = 6.0;
    private float directionLineWidth = 1.0f;
    private double geneNodeSize = 12.0;
    private double geneNodeIntervalY = 10.0;
    private double orthologGroupIntervalX = 10.0;
    private double scaleX = 1.0;
    private double scaleY = 1.0;
    private double organismNameWidth;
    private double geneNameHeight;
    private double connectionDepth = 1.0;
    private double connectionMarginY = 2.0;
    private boolean resizeFlag = false;
    private int orthologGroupStartIndex = 0;
    private boolean drawDerectionBorderFlag = true;
    private double clusterBlankWidth = -1.0;
    private double verticalPositionOfMain = 0.0;

    public double getCanvasWidth() {
        return this.canvasWidth;
    }

    public void setCanvasWidth(double d) {
        this.canvasWidth = d;
    }

    public double getCanvasHeight() {
        return this.canvasHeight;
    }

    public void setCanvasHeight(double d) {
        this.canvasHeight = d;
    }

    public double getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(double d) {
        this.marginTop = d;
    }

    public double getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(double d) {
        this.marginBottom = d;
    }

    public double getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(double d) {
        this.marginLeft = d;
    }

    public double getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(double d) {
        this.marginRight = d;
    }

    public double getBaseMarginTop() {
        return this.baseMarginTop;
    }

    public void setBaseMarginTop(double d) {
        this.baseMarginTop = d;
        this.setMarginTop(d);
    }

    public double getBaseMarginBottom() {
        return this.baseMarginBottom;
    }

    public void setBaseMarginBottom(double d) {
        this.baseMarginBottom = d;
        this.setMarginBottom(d);
    }

    public double getBaseMarginLeft() {
        return this.baseMarginLeft;
    }

    public void setBaseMarginLeft(double d) {
        this.baseMarginLeft = d;
        this.setMarginLeft(d);
    }

    public double getBaseMarginRight() {
        return this.baseMarginRight;
    }

    public void setBaseMarginRight(double d) {
        this.baseMarginRight = d;
        this.setMarginRight(d);
    }

    protected float getFontSize() {
        return (float)this.getGeneNodeSize();
    }

    public double calcVirtualGeneNameWidth(String string) {
        return (double)string.length() * (double)this.getFontSize();
    }

    public Font createFont() {
        return new Font(FONT_NAME, 3, (int)this.getFontSize());
    }

    public double getGeneNameHeight(int n) {
        return (double)this.getFontSize() * 0.8 * (double)n / 1.5;
    }

    public float getGeneNameAngle() {
        return this.geneNameAngle;
    }

    public void setGeneNameAngle(float f) {
        this.geneNameAngle = f;
    }

    public double getDirectionHeight() {
        return this.directionHeight;
    }

    public void setDirectionHeight(double d) {
        this.directionHeight = d;
    }

    public double getDirectionWidth() {
        return this.getGeneNodeSize() + this.getOrthologGroupIntervalX();
    }

    public float getDirectionLineWidth() {
        return this.directionLineWidth;
    }

    public void setDirectionLineWidth(float f) {
        this.directionLineWidth = f;
    }

    public double getGeneNodeSize() {
        return this.geneNodeSize;
    }

    public void setGeneNodeSize(double d) {
        this.geneNodeSize = d;
    }

    public double getGeneNameIntervalY() {
        return this.geneNameIntervalY;
    }

    public void setGeneNameIntervalY(double d) {
        this.geneNameIntervalY = d;
    }

    public double getDirectionIntervalY() {
        return this.directionIntervalY;
    }

    public void setDirectionIntervalY(double d) {
        this.directionIntervalY = d;
    }

    public double getGeneNodeIntervalY() {
        return this.geneNodeIntervalY;
    }

    public void setGeneNodeIntervalY(double d) {
        this.geneNodeIntervalY = d;
    }

    public double getOrthologGroupIntervalX() {
        return this.orthologGroupIntervalX;
    }

    public void setOrthologGroupIntervalX(double d) {
        this.orthologGroupIntervalX = d;
    }

    public float getConnectionThick() {
        return (float)(this.getGeneNodeSize() * 0.3);
    }

    public float getConnectionPolyThick() {
        return (float)(this.getGeneNodeSize() * 0.1);
    }

    public int getConnectionMaxViewCount() {
        return (int)(this.getConnectionMaxDrawHeight() / 2.0);
    }

    public double getConnectionMaxDrawHeight() {
        return this.getGeneNodeIntervalY() + this.getGeneNodeSize() * 0.3;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(double d) {
        this.scaleX = d;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(double d) {
        this.scaleY = d;
    }

    public double calcScaleX(int n, int n2) {
        this.clusterBlankWidth = this.getDirectionWidth();
        double d = (this.getGeneNodeSize() + this.getOrthologGroupIntervalX()) * (double)n + this.clusterBlankWidth * (double)n2;
        double d2 = (this.getCanvasWidth() - (this.getMarginLeft() + this.getMarginRight())) / (d + this.getOrganismNameWidth());
        if (this.clusterBlankWidth < 5.0 / d2) {
            this.clusterBlankWidth = 5.0 / d2;
            d = (this.getGeneNodeSize() + this.getOrthologGroupIntervalX()) * (double)n + this.clusterBlankWidth * (double)n2;
            d2 = (this.getCanvasWidth() - (this.getMarginLeft() + this.getMarginRight())) / (d + this.getOrganismNameWidth());
        }
        return d2;
    }

    public double calcScaleY(int n, double d) {
        double d2 = (this.getGeneNodeSize() + this.getGeneNodeIntervalY()) * (double)n + d + this.getGeneNameIntervalY() + this.getDirectionHeight();
        double d3 = (this.getCanvasHeight() - (this.getMarginTop() + this.getMarginBottom())) / d2;
        return d3;
    }

    public double getOrganismNameWidth() {
        return this.organismNameWidth;
    }

    public void setOrganismNameWidth(double d) {
        this.organismNameWidth = d;
    }

    public double getGeneNameHeight() {
        return this.geneNameHeight;
    }

    public void setGeneNameHeight(double d) {
        this.geneNameHeight = d;
    }

    public double getConnectionDepth() {
        return this.connectionDepth;
    }

    public void setConnectionDepth(double d) {
        this.connectionDepth = d;
    }

    public double getConnectionMarginY() {
        return this.connectionMarginY;
    }

    public void setConnectionMarginY(double d) {
        this.connectionMarginY = d;
    }

    public double getVerticalPositionOfMain() {
        return this.verticalPositionOfMain;
    }

    public void setVerticalPositionOfMain(double d) {
        this.verticalPositionOfMain = d;
    }

    public double getClusterBlankWidth() {
        if (this.clusterBlankWidth == -1.0) {
            return this.getDirectionWidth();
        }
        return this.clusterBlankWidth;
    }

    public boolean isResizeFlag() {
        return this.resizeFlag;
    }

    public void setResizeFlag(boolean bl) {
        this.resizeFlag = bl;
    }

    public boolean isDrawDerectionBorderFlag() {
        return this.drawDerectionBorderFlag;
    }

    public void setDrawDerectionBorderFlag(boolean bl) {
        this.drawDerectionBorderFlag = bl;
    }

    public int getOrthologGroupStartIndex() {
        return this.orthologGroupStartIndex;
    }

    public void setOrthologGroupStartIndex(int n) {
        this.orthologGroupStartIndex = n;
    }

    public double getOrganismStartX() {
        return this.getMarginLeft() / this.getScaleX();
    }

    public double getOrganismStartY() {
        double d = this.getMarginTop() / this.getScaleY() + this.getGeneNameHeight() + this.getDirectionHeight() + this.getDirectionIntervalY() + this.getGeneNodeSize();
        return d;
    }

    public double getGeneNameStartX() {
        double d = this.getOrganismStartX() + this.getOrganismNameWidth() + this.getOrthologGroupIntervalX() + this.getGeneNameStartXAgainstOneOrhotlogGroup();
        return d;
    }

    public double getGeneNameStartXAgainstOneOrhotlogGroup() {
        return this.getDirectionWidth() / 2.0;
    }

    public double getGeneNameStartY() {
        double d = this.getMarginTop() / this.getScaleY() + this.getGeneNameHeight();
        return d;
    }

    public double getDirectionStartX() {
        double d = this.getOrganismStartX() + this.getOrganismNameWidth() + this.getOrthologGroupIntervalX();
        return d;
    }

    public double getDirectionStartY() {
        double d = this.getGeneNameStartY() + this.getGeneNameIntervalY();
        return d;
    }

    public double getMatrixStartX() {
        double d = this.getOrganismStartX() + this.getOrganismNameWidth() + this.getOrthologGroupIntervalX() + this.getMatrixStartXAgainstOrthologGroup();
        return d;
    }

    public double getMatrixStartXAgainstOrthologGroup() {
        return this.getOrthologGroupIntervalX() / 2.0;
    }

    public double getMatrixStartY() {
        double d = this.getDirectionStartY() + this.getDirectionHeight() + this.getDirectionIntervalY();
        return d;
    }

    public double getOrthologGroupWidth() {
        return this.getGeneNodeSize() + this.getOrthologGroupIntervalX();
    }

    public int getViewOrthologGroupCount() {
        double d = (this.getCanvasWidth() - (this.getMarginLeft() + this.getMarginRight())) / this.getScaleX();
        double d2 = d - this.getOrganismNameWidth();
        return (int)Math.round(d2 / this.getOrthologGroupWidth());
    }

    public double calcHeight(int n) {
        return this.getMarginTop() + this.getGeneNameHeight() + this.getGeneNameIntervalY() + (this.getGeneNodeSize() + this.getGeneNodeIntervalY()) * (double)n + this.getMarginBottom();
    }

    public double calcMatrixWidth(int n, int n2) {
        return this.getOrthologGroupWidth() * (double)n + this.getClusterBlankWidth() * (double)(n2 - 1);
    }

    int getOrhologGroupIndex(int n, GenomeAlign genomeAlign) {
        return this.getOrhologGroupIndex(n, genomeAlign, true);
    }

    public int getOrhologGroupIndex(int n, GenomeAlign genomeAlign, boolean bl) {
        double d = (double)n / this.getScaleX() - this.getDirectionStartX();
        double d2 = (double)genomeAlign.getOrthologGroupSize() * this.getOrthologGroupWidth() + (double)(genomeAlign.getClusterCount() - 1) * this.getClusterBlankWidth();
        if (!bl && (d < 0.0 || d >= d2)) {
            return -1;
        }
        if (d < 0.0) {
            return this.getOrthologGroupStartIndex();
        }
        if (d >= d2) {
            return genomeAlign.getOrthologGroupSize() + this.getOrthologGroupStartIndex() - 1;
        }
        int n2 = this.getOrthologGroupStartIndex();
        int n3 = genomeAlign.indexOfClusterBorderIndex(this.getOrthologGroupStartIndex());
        int n4 = genomeAlign.containsClusterBorderindex(n3) ? 0 : 1;
        for (int i = 0; i < genomeAlign.getClusterBorderIndexList().size() + n4; ++i) {
            int n5;
            int n6;
            int n7 = genomeAlign.getClusterBorderOrthologGroupIndex(i + n3 + 1);
            if (n7 < (n6 = genomeAlign.getClusterBorderOrthologGroupIndex(i + n3))) {
                n6 -= genomeAlign.getOrthologGroupSize();
            }
            if (i == 0) {
                n5 = n7 - this.getOrthologGroupStartIndex();
                if (n5 < 0) {
                    n5 += genomeAlign.getOrthologGroupSize();
                }
            } else {
                n5 = i == genomeAlign.getClusterBorderIndexList().size() ? this.getOrthologGroupStartIndex() : n7 - n6;
            }
            n2 += n5;
            if ((d -= (double)n5 * this.getOrthologGroupWidth()) <= 0.0) break;
            if (!((d -= this.getClusterBlankWidth()) <= 0.0)) continue;
            n2 = n7;
            d = 0.0;
            break;
        }
        for (n2 = (int)((double)n2 + d / this.getOrthologGroupWidth()); n2 < 0; n2 += genomeAlign.getOrthologGroupSize()) {
        }
        while (n2 >= genomeAlign.getOrthologGroupSize()) {
            n2 -= genomeAlign.getOrthologGroupSize();
        }
        return n2;
    }

    public double calcX(int n, int n2) {
        double d = this.getDirectionStartX() + this.getOrthologGroupWidth() * (double)n + (double)(n2 - 1) * this.getClusterBlankWidth();
        return d * this.getScaleX();
    }

    public Rectangle getOrthologGroupRect(int n, GenomeAlign genomeAlign) {
        int n2 = genomeAlign.getClusterCount(this.getOrthologGroupStartIndex());
        int n3 = genomeAlign.getOrthologGroupSize();
        int n4 = genomeAlign.getClusterCount(n);
        int n5 = genomeAlign.getClusterCount();
        double d = this.calcX(this.getOrthologGroupStartIndex(), n2);
        double d2 = this.calcX(n, n4) - d;
        if (d2 < 0.0) {
            d2 += (this.getOrthologGroupWidth() * (double)n3 + this.getClusterBlankWidth() * (double)n5) * this.getScaleX();
        }
        d2 += this.getDirectionStartX() * this.getScaleX();
        int n6 = (int)(this.getOrthologGroupWidth() * this.getScaleX());
        if (n6 == 0) {
            n6 = 1;
        }
        Rectangle rectangle = new Rectangle((int)d2, 0, n6, (int)this.getCanvasHeight());
        return rectangle;
    }

    public void zoom(double d) {
        this.setMarginTop(this.getBaseMarginTop() * d);
        this.setMarginBottom(this.getBaseMarginBottom() * d);
        this.setMarginLeft(this.getBaseMarginLeft() * d);
        this.setMarginRight(this.getBaseMarginRight() * d);
        this.setOrthologGroupIntervalX(6.0 * d);
        this.setGeneNameIntervalY(6.0 * d);
        this.setDirectionHeight(12.0 * d);
        this.setDirectionLineWidth((float)(1.0 * d));
        this.setDirectionIntervalY(6.0 * d);
        this.setGeneNodeSize(12.0 * d);
        this.setGeneNodeIntervalY(10.0 * d);
        this.setConnectionDepth(1.0 * d);
        this.setConnectionMarginY(2.0 * d);
    }

    public int convertOrthologGroupStartIndex(int n, int n2) {
        int n3;
        for (n3 = n + this.getOrthologGroupStartIndex(); n3 < 0; n3 += n2) {
        }
        while (n3 >= n2) {
            n3 -= n2;
        }
        return n3;
    }

    private double getMinmumGeneNodeSize() {
        return 3.0;
    }

    double getMinmumZoomScale() {
        return this.getMinmumGeneNodeSize() / this.getGeneNodeSize();
    }

    boolean isOrganismTitleX(Point point) {
        return this.getMarginLeft() <= point.getX() && this.getMatrixStartX() >= (double)point.x;
    }
}

