/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.coregenome.CoreGenomeAnalysis;
import cgdp.recog.coregenome.CoreGenomeDeleteRequester;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CoreGenomeDeleteRequestExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(CoreGenomeDeleteRequestExecuter.class);
    private Component parent;
    private Collection coreGenomeAnalysisC = new HashSet();
    private Set unableDeleteAnalysisSet = new HashSet();

    public CoreGenomeDeleteRequestExecuter(Component component, CoreGenomeAnalysis coreGenomeAnalysis) {
        this.parent = component;
        HashSet<CoreGenomeAnalysis> hashSet = new HashSet<CoreGenomeAnalysis>();
        hashSet.add(coreGenomeAnalysis);
        this.coreGenomeAnalysisC = hashSet;
    }

    public CoreGenomeDeleteRequestExecuter(Component component, Collection collection) {
        this.parent = component;
        this.coreGenomeAnalysisC = collection;
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        progressImpl.setTotal(this.coreGenomeAnalysisC.size());
        Iterator iterator = this.coreGenomeAnalysisC.iterator();
        while (iterator.hasNext()) {
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            progressImpl.increment();
            CoreGenomeAnalysis coreGenomeAnalysis = (CoreGenomeAnalysis)iterator.next();
            try {
                CoreGenomeDeleteRequester coreGenomeDeleteRequester = new CoreGenomeDeleteRequester(coreGenomeAnalysis.getProject(), coreGenomeAnalysis.getDomClustId(), coreGenomeAnalysis.getCoreGenomeId(), coreGenomeAnalysis.getName());
                coreGenomeDeleteRequester.execute();
                if (!coreGenomeDeleteRequester.isError()) continue;
                logger.warn(coreGenomeDeleteRequester.getMessage());
                this.unableDeleteAnalysisSet.add(coreGenomeAnalysis);
            }
            catch (Exception exception) {
                String string = "Fail to delte core genome result on server. " + coreGenomeAnalysis.getName();
                logger.warn(string, exception);
                this.unableDeleteAnalysisSet.add(coreGenomeAnalysis);
            }
        }
    }

    @Override
    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
            return;
        }
        Runnable runnable = this.getAfterRunnable();
        if (runnable != null) {
            runnable.run();
        }
    }
}

