/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.coregenome.CoreGenomeParameterUtil;
import cgdp.recog.coregenome.CoreGenomeViewModel;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.ServerStatus;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class CoreGenomeExporter {
    private static final ApplicationLogger logger = new ApplicationLogger(CoreGenomeExporter.class);
    private static final String LINE_SEPARETOR = System.getProperty("line.separator");
    private File baseFile;
    private File file;
    private CoreGenomeViewModel coreGenomeViewModel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            String string;
            fileInputStream = new FileInputStream(this.baseFile);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            outputStreamWriter = new FileWriter(this.file);
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                if (this.setBaseParameters(bufferedWriter, string)) continue;
                if (!bl) {
                    this.setViewParameter(bufferedWriter);
                    bl = true;
                }
                bufferedWriter.write(string);
                bufferedWriter.write(LINE_SEPARETOR);
            }
            bufferedWriter.flush();
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
            if (outputStreamWriter != null) {
                outputStreamWriter.close();
            }
        }
    }

    private boolean setBaseParameters(BufferedWriter bufferedWriter, String string) throws IOException {
        if (CoreGenomeParameterUtil.isRatioConservedGenes(string) || CoreGenomeParameterUtil.isRatioConservedConnections(string) || CoreGenomeParameterUtil.isWindowSize(string) || CoreGenomeParameterUtil.isReferenceGenome(string) || CoreGenomeParameterUtil.isViewSp(string) || CoreGenomeParameterUtil.isViewOrthologGroupStartIndex(string)) {
            return true;
        }
        if (ServerStatus.isParameter(string)) {
            bufferedWriter.write(string);
            bufferedWriter.write(LINE_SEPARETOR);
            return true;
        }
        return false;
    }

    private void setViewParameter(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(CoreGenomeParameterUtil.createWindowSizeMessage(this.coreGenomeViewModel.getWindowSize()));
        bufferedWriter.write(LINE_SEPARETOR);
        bufferedWriter.write(CoreGenomeParameterUtil.createViewSpMessage(this.coreGenomeViewModel.getViewOrganismCodeList()));
        bufferedWriter.write(LINE_SEPARETOR);
        bufferedWriter.write(CoreGenomeParameterUtil.createReferenceGenomeMessage(this.coreGenomeViewModel.getReferenceOrganism().getOrganismCode()));
        bufferedWriter.write(LINE_SEPARETOR);
        bufferedWriter.write(CoreGenomeParameterUtil.createViewOrthologGroupStartIndexMessage(this.coreGenomeViewModel.getViewOrthologGroupStartIndexOnMain()));
        bufferedWriter.write(LINE_SEPARETOR);
        bufferedWriter.write(CoreGenomeParameterUtil.createOrganismNameTypeMessage(this.coreGenomeViewModel.getOrganismNameType()));
        bufferedWriter.write(LINE_SEPARETOR);
        bufferedWriter.write(CoreGenomeParameterUtil.createAddStrainToNameMessage(this.coreGenomeViewModel.isAddStrainToName()));
        bufferedWriter.write(LINE_SEPARETOR);
        bufferedWriter.write(CoreGenomeParameterUtil.createForViewMessage());
        bufferedWriter.write(LINE_SEPARETOR);
    }

    public void setBaseFile(File file) {
        this.baseFile = file;
    }

    public void setFile(File file) {
        String string = FileUtil.addExtension(file.getAbsolutePath(), ".coaln");
        this.file = new File(string);
    }

    public void setCoreGenomeViewModel(CoreGenomeViewModel coreGenomeViewModel) {
        this.coreGenomeViewModel = coreGenomeViewModel;
    }
}

