/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.access.AbstractImporter;
import cgdp.recog.coregenome.CoreGenomeAlignmentCondition;
import cgdp.recog.coregenome.CoreGenomeParameterUtil;
import cgdp.recog.coregenome.GenomeAlign;
import cgdp.recog.coregenome.OrthologGroup;
import cgdp.recog.coregenome.OrthologSpNode;
import cgdp.recog.data.Cluster;
import cgdp.recog.util.ServerStatus;
import cgdp.recog.util.StringTool;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;

public class CoreGenomeImporter
extends AbstractImporter {
    private String filepath;
    private Map clusterMap;
    private GenomeAlign genomeAlign;
    private CoreGenomeAlignmentCondition condition;
    private boolean parameterOnly = false;
    private String referenceOrganismCode;
    private String queryString;

    public CoreGenomeImporter(String string) {
        this.filepath = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws IOException {
        this.genomeAlign = new GenomeAlign();
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String string;
            fileInputStream = new FileInputStream(this.filepath);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = Integer.MIN_VALUE;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(new Integer(0));
            while ((string = bufferedReader.readLine()) != null) {
                if (this.setParameterToGenomeAlign(string, this.genomeAlign)) continue;
                if (this.parameterOnly) {
                    return;
                }
                OrthologGroup orthologGroup = this.parseOrthologGroupString(string);
                orthologGroup.setRealOrderIndex(n2);
                this.genomeAlign.addOrthologGroup(orthologGroup);
                ++n2;
                if (n4 != Integer.MIN_VALUE && n4 != orthologGroup.getClusterNo()) {
                    arrayList.add(new Integer(orthologGroup.getRealOrderIndex() - 1));
                    ++n3;
                }
                n4 = orthologGroup.getClusterNo();
                orthologGroup.setClusterPosition(n3);
                ++n;
            }
            this.genomeAlign.setClusterBorderIndexList(arrayList);
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private boolean setParameterToGenomeAlign(String string, GenomeAlign genomeAlign) {
        if (!CoreGenomeParameterUtil.isParameter(string)) {
            return false;
        }
        if (CoreGenomeParameterUtil.isClusterId(string)) {
            genomeAlign.setDomClustId(CoreGenomeParameterUtil.getClusterId(string));
            return true;
        }
        if (CoreGenomeParameterUtil.isCoreGenomeId(string)) {
            genomeAlign.setCoreGenomeId(CoreGenomeParameterUtil.getCoreGenomeId(string));
            return true;
        }
        if (CoreGenomeParameterUtil.isSpecies(string)) {
            genomeAlign.setOrganismCodeList(CoreGenomeParameterUtil.getSpeciesList(string));
            return true;
        }
        if (CoreGenomeParameterUtil.isClusterViewId(string)) {
            genomeAlign.setClusterViewId(CoreGenomeParameterUtil.getClusterViewId(string));
            return true;
        }
        if (CoreGenomeParameterUtil.isReferenceGenome(string)) {
            this.setReferenceOrganismCode(CoreGenomeParameterUtil.getReferenceGenome(string));
        } else if (CoreGenomeParameterUtil.isQuery(string)) {
            this.setQueryString(CoreGenomeParameterUtil.getQuery(string));
        } else if (ServerStatus.isExecServer(string)) {
            this.execServer = ServerStatus.getExecServer(string);
        } else if (ServerStatus.isExecPort(string)) {
            this.execPort = ServerStatus.getExecPort(string);
        } else if (ServerStatus.isOrigExecServer(string)) {
            this.origExecServer = ServerStatus.getOrigExecServer(string);
        } else if (ServerStatus.isOrigExecPort(string)) {
            this.origExecPort = ServerStatus.getOrigExecPort(string);
        }
        if (this.condition != null && this.condition.isUpdateParameterFlag()) {
            if (CoreGenomeParameterUtil.isWindowSize(string)) {
                this.condition.setWindowSize(CoreGenomeParameterUtil.getWindowSize(string));
                return true;
            }
            if (CoreGenomeParameterUtil.isViewSp(string)) {
                this.condition.setViewOrganismCodeList(CoreGenomeParameterUtil.getViewSpList(string));
                return true;
            }
            if (CoreGenomeParameterUtil.isReferenceGenome(string)) {
                this.condition.setReferenceOrganismCode(CoreGenomeParameterUtil.getReferenceGenome(string));
                return true;
            }
            if (CoreGenomeParameterUtil.isViewOrthologGroupStartIndex(string)) {
                this.condition.setViewOrthologGroupStartIndexOnMain(CoreGenomeParameterUtil.getViewOrthologGroupStartIndex(string));
                return true;
            }
            if (CoreGenomeParameterUtil.isOrganismNameType(string)) {
                this.condition.setOrganismNameType(CoreGenomeParameterUtil.getOrganismNameType(string));
                return true;
            }
            if (CoreGenomeParameterUtil.isAddStrainToName(string)) {
                this.condition.setAddStrainToName(CoreGenomeParameterUtil.getAddStrainToName(string));
                return true;
            }
            if (CoreGenomeParameterUtil.isForView(string)) {
                this.condition.setForViewFlag(true);
                return true;
            }
        }
        return true;
    }

    private OrthologGroup parseOrthologGroupString(String string) {
        Vector vector = StringTool.splitString(string, "\t");
        String string2 = (String)vector.get(0);
        String string3 = (String)vector.get(1);
        int n = Integer.parseInt((String)vector.get(2));
        int n2 = Integer.parseInt((String)vector.get(3));
        OrthologGroup orthologGroup = new OrthologGroup();
        orthologGroup.setOrthologGroupId(string2);
        OrthologGroupIDAnalyzer orthologGroupIDAnalyzer = new OrthologGroupIDAnalyzer();
        orthologGroupIDAnalyzer.separeteOrthologGroupId(string2);
        orthologGroup.setDivideNo(orthologGroupIDAnalyzer.getDivideNo());
        orthologGroup.setDisplayGeneName(string3);
        orthologGroup.setDirection(n);
        orthologGroup.setClusterNo(n2);
        Cluster cluster = (Cluster)this.clusterMap.get(orthologGroupIDAnalyzer.getConbineClusterId());
        orthologGroup.setCluster(cluster);
        for (int i = 4; i < vector.size(); ++i) {
            String string4 = (String)vector.get(i);
            if (StringTool.isNull(string4)) continue;
            String string5 = this.genomeAlign.getOrganismCode(i - 4);
            OrthologSpNode orthologSpNode = new OrthologSpNode();
            orthologSpNode.setOrganism(string5);
            CoreGenomeImporter.addLocusTags(string4, orthologSpNode);
            orthologGroup.addOrthologSpNode(orthologSpNode);
        }
        return orthologGroup;
    }

    private static void addLocusTags(String string, OrthologSpNode orthologSpNode) {
        Vector vector = StringTool.splitString(string, " ");
        for (String string2 : vector) {
            orthologSpNode.addLocusTag(string2);
        }
    }

    public String getFilepath() {
        return this.filepath;
    }

    public void setFilepath(String string) {
        this.filepath = string;
    }

    public void setClusterMap(Map map) {
        this.clusterMap = map;
    }

    public GenomeAlign getGenomeAlign() {
        return this.genomeAlign;
    }

    public String getReferenceOrganismCode() {
        return this.referenceOrganismCode;
    }

    private void setReferenceOrganismCode(String string) {
        this.referenceOrganismCode = string;
    }

    private void setQueryString(String string) {
        this.queryString = string;
    }

    public String getCoreAlignerConditionString() {
        return this.queryString;
    }

    public void setCondition(CoreGenomeAlignmentCondition coreGenomeAlignmentCondition) {
        this.condition = coreGenomeAlignmentCondition;
    }

    public void setParameterOnly(boolean bl) {
        this.parameterOnly = bl;
    }

    private class OrthologGroupIDAnalyzer {
        private int clusterId;
        private int subClusterId;
        private String divideNo;

        private OrthologGroupIDAnalyzer() {
        }

        void separeteOrthologGroupId(String string) {
            int n = string.indexOf("_");
            this.clusterId = Integer.parseInt(string.substring(0, n));
            String string2 = string.substring(n + 1, string.length());
            if ((n = string2.indexOf("_")) != -1) {
                this.divideNo = string2.substring(n + 1, String.valueOf(this.subClusterId).length());
                this.subClusterId = Integer.parseInt(string2.substring(0, n));
            } else {
                this.subClusterId = Integer.parseInt(string2);
            }
        }

        public String getConbineClusterId() {
            return Cluster.conbineClusterId(this.clusterId, this.subClusterId);
        }

        public String getDivideNo() {
            return this.divideNo;
        }
    }
}

