/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.util.ServerStatus;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.List;

public class CoreGenomeParameterUtil
extends ServerStatus {
    private static final String RATIO_CONSERVED_GENES_KEY = "#RATIO_CONSERVED_GENES";
    private static final String RATIO_CONSERVED_CONNECTIONS_KEY = "#RATIO_CONSERVED_CONNECTIONS";
    private static final String WINDOW_SIZE_KEY = "#WINDOW_SIZE";
    private static final String VIEW_SP_KEY = "#VIEW_SP";
    private static final String REFERENCE_GENOME_KEY = "#REFERENCE_GENOME";
    private static final String QUERY_KEY = "#QUERY";
    private static final String VIEW_ORTHOLOGGROUP_START_INDEX_KEY = "#VIEW_ORTHOLOGGROUP_START_INDEX";
    private static final String ORGANISM_NAME_TYPE_KEY = "#ORGANISM_NAME_TYPE";
    private static final String ADD_STRAIN_TO_NAME_KEY = "#ADD_STRAIN_TO_NAME";

    public static boolean isRatioConservedGenes(String string) {
        return CoreGenomeParameterUtil.isIncludeString(string, "#RATIO_CONSERVED_GENES=");
    }

    public static boolean isRatioConservedConnections(String string) {
        return CoreGenomeParameterUtil.isIncludeString(string, "#RATIO_CONSERVED_CONNECTIONS=");
    }

    public static boolean isWindowSize(String string) {
        return CoreGenomeParameterUtil.isIncludeString(string, "#WINDOW_SIZE=");
    }

    public static boolean isViewSp(String string) {
        return CoreGenomeParameterUtil.isIncludeString(string, "#VIEW_SP=");
    }

    public static boolean isReferenceGenome(String string) {
        return CoreGenomeParameterUtil.isIncludeString(string, "#REFERENCE_GENOME=");
    }

    public static boolean isQuery(String string) {
        return CoreGenomeParameterUtil.isIncludeString(string, "#QUERY=");
    }

    public static boolean isViewOrthologGroupStartIndex(String string) {
        return CoreGenomeParameterUtil.isIncludeString(string, "#VIEW_ORTHOLOGGROUP_START_INDEX=");
    }

    public static boolean isOrganismNameType(String string) {
        return CoreGenomeParameterUtil.isIncludeString(string, "#ORGANISM_NAME_TYPE=");
    }

    public static boolean isAddStrainToName(String string) {
        return CoreGenomeParameterUtil.isIncludeString(string, "#ADD_STRAIN_TO_NAME=");
    }

    public static double getRatioConservedGenes(String string) {
        return Double.parseDouble(CoreGenomeParameterUtil.extractValue(RATIO_CONSERVED_GENES_KEY, string));
    }

    public static double getRatioConservedConnections(String string) {
        return Double.parseDouble(CoreGenomeParameterUtil.extractValue(RATIO_CONSERVED_CONNECTIONS_KEY, string));
    }

    public static int getWindowSize(String string) {
        return Integer.parseInt(CoreGenomeParameterUtil.extractValue(WINDOW_SIZE_KEY, string));
    }

    public static List getViewSpList(String string) {
        String string2 = CoreGenomeParameterUtil.extractValue(VIEW_SP_KEY, string);
        return new ArrayList(StringTool.splitString(string2));
    }

    public static String getReferenceGenome(String string) {
        return CoreGenomeParameterUtil.extractValue(REFERENCE_GENOME_KEY, string);
    }

    public static String getQuery(String string) {
        return CoreGenomeParameterUtil.extractValue(QUERY_KEY, string);
    }

    public static int getViewOrthologGroupStartIndex(String string) {
        return Integer.parseInt(CoreGenomeParameterUtil.extractValue(VIEW_ORTHOLOGGROUP_START_INDEX_KEY, string));
    }

    public static int getOrganismNameType(String string) {
        return Integer.parseInt(CoreGenomeParameterUtil.extractValue(ORGANISM_NAME_TYPE_KEY, string));
    }

    public static boolean getAddStrainToName(String string) {
        return new Boolean(CoreGenomeParameterUtil.extractValue(ADD_STRAIN_TO_NAME_KEY, string));
    }

    public static String createRatioConservedGenesMessage(double d) {
        return CoreGenomeParameterUtil.createParameterMessage(RATIO_CONSERVED_GENES_KEY, String.valueOf(d));
    }

    public static String createRatioConservedConnectionsMessage(double d) {
        return CoreGenomeParameterUtil.createParameterMessage(RATIO_CONSERVED_CONNECTIONS_KEY, String.valueOf(d));
    }

    public static String createWindowSizeMessage(int n) {
        return CoreGenomeParameterUtil.createParameterMessage(WINDOW_SIZE_KEY, String.valueOf(n));
    }

    public static String createViewSpMessage(List list) {
        String string = StringTool.conbineStrArray(list.toArray(new String[0]));
        return CoreGenomeParameterUtil.createParameterMessage(VIEW_SP_KEY, string);
    }

    public static String createReferenceGenomeMessage(String string) {
        return CoreGenomeParameterUtil.createParameterMessage(REFERENCE_GENOME_KEY, string);
    }

    public static String createViewOrthologGroupStartIndexMessage(int n) {
        return CoreGenomeParameterUtil.createParameterMessage(VIEW_ORTHOLOGGROUP_START_INDEX_KEY, String.valueOf(n));
    }

    public static String createOrganismNameTypeMessage(int n) {
        return CoreGenomeParameterUtil.createParameterMessage(ORGANISM_NAME_TYPE_KEY, String.valueOf(n));
    }

    public static String createAddStrainToNameMessage(boolean bl) {
        return CoreGenomeParameterUtil.createParameterMessage(ADD_STRAIN_TO_NAME_KEY, String.valueOf(bl));
    }
}

