/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.coregenome.CoreGenomeContext;
import cgdp.recog.coregenome.CoreGenomePrintDriver;
import cgdp.recog.coregenome.CoreGenomeViewModel;
import cgdp.recog.coregenome.FoldCoreGenomeContext;
import cgdp.recog.coregenome.FoldCoreGenomeRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import javax.swing.JPanel;

class CoreGenomePreviewPanel
extends JPanel {
    private static final double BASE_PANEL_SIZE = 500.0;
    private MediatorImpl mediator;
    private CoreGenomeViewModel coreGenomeViewModel;
    private FoldCoreGenomeRenderer foldCoreGenomeRenderer;

    CoreGenomePreviewPanel(MediatorImpl mediatorImpl, CoreGenomeViewModel coreGenomeViewModel) {
        this.mediator = mediatorImpl;
        this.coreGenomeViewModel = coreGenomeViewModel;
        this.init();
    }

    private void init() {
        this.updateFoldCoreGenomeRenderer();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        PageFormat pageFormat = this.mediator.getPageFormat();
        CoreGenomeContext coreGenomeContext = this.foldCoreGenomeRenderer.getCoreGenomeContext();
        ((Graphics2D)graphics).scale(coreGenomeContext.getScaleX(), coreGenomeContext.getScaleY());
        ((Graphics2D)graphics).translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        ((Graphics2D)graphics).scale(1.0 / coreGenomeContext.getScaleX(), 1.0 / coreGenomeContext.getScaleY());
        this.foldCoreGenomeRenderer.draw((Graphics2D)graphics);
    }

    private Dimension getPanelSize() {
        PageFormat pageFormat = this.mediator.getPageFormat();
        double d = this.calcZoomScale();
        double d2 = pageFormat.getWidth() * d;
        double d3 = pageFormat.getHeight() * d;
        return new Dimension((int)d2, (int)d3);
    }

    private double calcZoomScale() {
        PageFormat pageFormat = this.mediator.getPageFormat();
        double d = pageFormat.getWidth();
        double d2 = pageFormat.getHeight();
        double d3 = 1.0;
        d3 = d >= d2 ? 500.0 / d : 500.0 / d2;
        return d3;
    }

    void prev() {
        if (this.foldCoreGenomeRenderer.getFoldCoreGenomeContext().isFirstPage()) {
            return;
        }
        FoldCoreGenomeContext foldCoreGenomeContext = this.foldCoreGenomeRenderer.getFoldCoreGenomeContext();
        int n = foldCoreGenomeContext.getPageIndex();
        foldCoreGenomeContext.setPageIndex(n - 1);
        this.repaint();
    }

    void next() {
        if (this.foldCoreGenomeRenderer.getFoldCoreGenomeContext().isLastPage()) {
            return;
        }
        FoldCoreGenomeContext foldCoreGenomeContext = this.foldCoreGenomeRenderer.getFoldCoreGenomeContext();
        int n = foldCoreGenomeContext.getPageIndex();
        foldCoreGenomeContext.setPageIndex(n + 1);
        this.repaint();
    }

    boolean isFirstPage() {
        return this.foldCoreGenomeRenderer.getFoldCoreGenomeContext().isFirstPage();
    }

    boolean isLastPage() {
        return this.foldCoreGenomeRenderer.getFoldCoreGenomeContext().isLastPage();
    }

    int getTotalPageCount() {
        return this.foldCoreGenomeRenderer.getFoldCoreGenomeContext().getPageCount();
    }

    int getPageIndex() {
        return this.foldCoreGenomeRenderer.getFoldCoreGenomeContext().getPageIndex();
    }

    void updateFoldCoreGenomeRenderer() {
        PageFormat pageFormat = this.mediator.getPageFormat();
        CoreGenomePrintDriver coreGenomePrintDriver = new CoreGenomePrintDriver(pageFormat, this.coreGenomeViewModel);
        int n = 0;
        n = this.coreGenomeViewModel.isOnePagePrintFlag() ? coreGenomePrintDriver.calcRowCountForOnePage() : this.coreGenomeViewModel.getRowCountParPage();
        this.foldCoreGenomeRenderer = coreGenomePrintDriver.createCoreGenomeRenderer(n);
        FoldCoreGenomeContext foldCoreGenomeContext = this.foldCoreGenomeRenderer.getFoldCoreGenomeContext();
        double d = this.calcZoomScale();
        foldCoreGenomeContext.setPanelZoomScaleX(d);
        foldCoreGenomeContext.setPanelZoomScaleY(d);
        foldCoreGenomeContext.setScaleX(foldCoreGenomeContext.getScaleX() * d);
        foldCoreGenomeContext.setScaleY(foldCoreGenomeContext.getScaleY() * d);
        this.setPreferredSize(this.getPanelSize());
        this.repaint();
    }
}

