/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.coregenome.ConnectionDepthCalculator;
import cgdp.recog.coregenome.CoreGenomeContext;
import cgdp.recog.coregenome.CoreGenomeSearch;
import cgdp.recog.coregenome.CoreGenomeSearchResult;
import cgdp.recog.coregenome.CoreGenomeUtil;
import cgdp.recog.coregenome.CoreGenomeViewModel;
import cgdp.recog.coregenome.GenomeAlign;
import cgdp.recog.coregenome.OrthologGroup;
import cgdp.recog.coregenome.OrthologSpNode;
import cgdp.recog.coregenome.OrthologSpNodeConnection;
import cgdp.recog.data.Cluster;
import cgdp.recog.funccat.FunctionColorUtil;
import cgdp.recog.organism.Organism;
import cgdp.recog.util.ApplicationLogger;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.List;
import javax.swing.JPanel;

public class CoreGenomeRenderer {
    private static final ApplicationLogger logger = new ApplicationLogger(CoreGenomeRenderer.class);
    protected static final int DEFAULT_MIN_GENE_GAP = 1;
    protected static final float[] SAME_GENE_DASHES = new float[]{2.0f, 1.0f};
    protected CoreGenomeViewModel coreGenomeViewModel;
    protected CoreGenomeContext coreGenomeContext;
    private boolean resizeFlag = false;

    public void drawHeader(Graphics2D graphics2D) {
        this.updateConnectionDepthMap();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setFont(this.coreGenomeContext.createFont());
        this.coreGenomeContext.setOrganismNameWidth(this.calcOrganismNameSize(graphics2D));
        this.coreGenomeContext.setGeneNameHeight(this.calcGeneNameHeight());
        if (this.coreGenomeContext.isResizeFlag()) {
            double d = this.coreGenomeContext.calcScaleX(this.getGenomeAlign().getOrthologGroupSize(), this.getGenomeAlign().getClusterCount());
            double d2 = this.coreGenomeContext.calcScaleY(this.coreGenomeViewModel.getViewOrganismSize(), this.coreGenomeContext.getGeneNameHeight());
            graphics2D.scale(d, d2);
            this.coreGenomeContext.setScaleX(d);
            this.coreGenomeContext.setScaleY(d2);
        }
        this.drawGeneName(graphics2D);
        this.drawDirection(graphics2D);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    public void drawMatrixAll(Graphics2D graphics2D) {
        double d;
        this.updateConnectionDepthMap();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setFont(this.coreGenomeContext.createFont());
        this.coreGenomeContext.setOrganismNameWidth(this.calcOrganismNameSize(graphics2D));
        this.coreGenomeContext.setGeneNameHeight(this.calcGeneNameHeight());
        if (this.coreGenomeContext.isResizeFlag()) {
            d = this.coreGenomeContext.calcScaleX(this.getGenomeAlign().getOrthologGroupSize(), this.getGenomeAlign().getClusterCount());
            double d2 = this.coreGenomeContext.calcScaleY(this.coreGenomeViewModel.getViewOrganismSize(), this.coreGenomeContext.getGeneNameHeight());
            graphics2D.scale(d, d2);
            this.coreGenomeContext.setScaleX(d);
            this.coreGenomeContext.setScaleY(d2);
        }
        d = this.calcOffsetTopForMatrix();
        graphics2D.translate(0.0, -d);
        this.drawOrganismName(graphics2D);
        this.drawMatrix(graphics2D);
        graphics2D.translate(0.0, d);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    private double calcOffsetTopForMatrix() {
        return this.calcHeaderHeight() - this.coreGenomeContext.getConnectionMaxDrawHeight() * 1.2;
    }

    public void draw(Graphics2D graphics2D) {
        this.updateConnectionDepthMap();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setFont(this.coreGenomeContext.createFont());
        this.coreGenomeContext.setOrganismNameWidth(this.calcOrganismNameSize(graphics2D));
        this.coreGenomeContext.setGeneNameHeight(this.calcGeneNameHeight());
        if (this.coreGenomeContext.isResizeFlag()) {
            double d = this.coreGenomeContext.calcScaleX(this.getGenomeAlign().getOrthologGroupSize(), this.getGenomeAlign().getClusterCount());
            double d2 = this.coreGenomeContext.calcScaleY(this.coreGenomeViewModel.getViewOrganismSize(), this.coreGenomeContext.getGeneNameHeight());
            graphics2D.scale(d, d2);
            this.coreGenomeContext.setScaleX(d);
            this.coreGenomeContext.setScaleY(d2);
        }
        Shape shape = graphics2D.getClip();
        graphics2D.clipRect(0, (int)(this.coreGenomeContext.getVerticalPositionOfMain() + this.coreGenomeContext.getDirectionStartY() + this.coreGenomeContext.getDirectionHeight()), (int)(this.coreGenomeContext.getCanvasWidth() / this.coreGenomeContext.getScaleX()), (int)(this.coreGenomeContext.getCanvasHeight() / this.coreGenomeContext.getScaleY()));
        this.drawOrganismName(graphics2D);
        this.drawMatrix(graphics2D);
        graphics2D.setClip(shape);
        this.drawGeneName(graphics2D);
        this.drawDirection(graphics2D);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    int calcOrganismNameSize(Graphics2D graphics2D) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = 0;
        for (String string : this.coreGenomeViewModel.getViewOrganismNameList()) {
            int n2 = fontMetrics.stringWidth(string);
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }

    int calcVirtualOrganismNameSize() {
        JPanel jPanel = new JPanel();
        FontMetrics fontMetrics = jPanel.getFontMetrics(this.coreGenomeContext.createFont());
        double d = 0.0;
        for (String string : this.coreGenomeViewModel.getViewOrganismNameList()) {
            double d2 = fontMetrics.stringWidth(string);
            if (!(d < d2)) continue;
            d = d2;
        }
        return (int)d + 10;
    }

    protected int calcGeneNameHeight() {
        List list = this.coreGenomeViewModel.getOrhotlogGroupLabelList();
        int n = 0;
        for (String string : list) {
            n = Math.max(string.length(), n);
        }
        return (int)this.coreGenomeContext.getGeneNameHeight(n);
    }

    protected void drawOrganismName(Graphics2D graphics2D) {
        Font font = graphics2D.getFont();
        int n = font.getSize();
        int n2 = this.calcOrganismNameSize(graphics2D);
        while ((double)n2 > this.coreGenomeContext.getOrganismNameWidth()) {
            Font font2 = font.deriveFont((float)(--n));
            graphics2D.setFont(font2);
            n2 = this.calcOrganismNameSize(graphics2D);
        }
        float f = (float)this.coreGenomeContext.getOrganismStartY();
        for (Organism organism : this.coreGenomeViewModel.getViewOrganismList()) {
            if (this.coreGenomeViewModel.isReferenceOrganism(organism.getOrganismCode())) {
                graphics2D.setColor(Color.red);
            } else {
                graphics2D.setColor(Color.black);
            }
            String string = this.coreGenomeViewModel.getDisplayOrganisnName(organism);
            graphics2D.drawString(string, (float)this.coreGenomeContext.getOrganismStartX(), f);
            f += (float)(this.coreGenomeContext.getGeneNodeIntervalY() + this.coreGenomeContext.getGeneNodeSize());
        }
        graphics2D.setFont(font);
    }

    protected void drawGeneName(Graphics2D graphics2D) {
        float f = (float)this.coreGenomeContext.getGeneNameStartX();
        float f2 = (float)this.coreGenomeContext.getGeneNameStartY() + (float)this.coreGenomeContext.getVerticalPositionOfMain();
        graphics2D.setColor(Color.black);
        int n = Integer.MIN_VALUE;
        List list = this.coreGenomeViewModel.getOrhotlogGroupLabelList();
        for (int i = 0; i < this.getGenomeAlign().getOrthologGroupSize(); ++i) {
            int n2 = this.coreGenomeContext.convertOrthologGroupStartIndex(i, this.getGenomeAlign().getOrthologGroupSize());
            int n3 = this.getGenomeAlign().getOrthologGroup(n2).getClusterNo();
            if (this.isChangeCluster(n3, n)) {
                f = (float)((double)f + this.coreGenomeContext.getClusterBlankWidth());
            }
            n = n3;
            String string = (String)list.get(n2);
            this.drawGeneName(graphics2D, string, f, f2);
            f = (float)((double)f + this.coreGenomeContext.getDirectionWidth());
            if (this.isDrawEndGeneName(f)) break;
        }
    }

    protected void drawGeneName(Graphics2D graphics2D, String string, float f, float f2) {
        try {
            graphics2D.rotate(-this.coreGenomeContext.getGeneNameAngle(), f, f2);
            graphics2D.drawString(string, f, f2);
            graphics2D.rotate(this.coreGenomeContext.getGeneNameAngle(), f, f2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.warn("Fail to draw gene name. X:" + f + " Y:" + f2 + " genename:" + string, arrayIndexOutOfBoundsException);
        }
    }

    protected boolean isDrawEndGeneName(double d) {
        return d * this.coreGenomeContext.getScaleX() > this.coreGenomeContext.getCanvasWidth();
    }

    private void drawDirection(Graphics2D graphics2D) {
        double d = this.coreGenomeContext.getDirectionStartX();
        double d2 = this.coreGenomeContext.getDirectionStartY() + (double)((float)this.coreGenomeContext.getVerticalPositionOfMain());
        int n = Integer.MIN_VALUE;
        graphics2D.translate(d, d2);
        for (int i = 0; i < this.getGenomeAlign().getOrthologGroupSize(); ++i) {
            int n2 = this.coreGenomeContext.convertOrthologGroupStartIndex(i, this.getGenomeAlign().getOrthologGroupSize());
            OrthologGroup orthologGroup = (OrthologGroup)this.getGenomeAlign().getOrthologGroupList().get(n2);
            int n3 = orthologGroup.getClusterNo();
            if (this.isChangeCluster(n3, n)) {
                graphics2D.translate(this.coreGenomeContext.getClusterBlankWidth(), 0.0);
                d += this.coreGenomeContext.getClusterBlankWidth();
            }
            n = n3;
            this.drawDirection(graphics2D, orthologGroup.getDirection(), orthologGroup.getCluster());
            if (d * this.coreGenomeContext.getScaleX() > this.coreGenomeContext.getCanvasWidth()) break;
            graphics2D.translate(this.coreGenomeContext.getDirectionWidth(), 0.0);
            d += this.coreGenomeContext.getDirectionWidth();
        }
        graphics2D.translate(-d, -d2);
    }

    protected void drawDirection(Graphics2D graphics2D, int n, Cluster cluster) {
        Shape shape = this.createDirectionShape(n);
        Color color = FunctionColorUtil.getFuncCatColor(cluster.getFunctionCategory());
        graphics2D.setColor(color);
        graphics2D.fill(shape);
        if (this.coreGenomeContext.isDrawDerectionBorderFlag()) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(this.coreGenomeContext.getDirectionLineWidth()));
            graphics2D.setColor(Color.black);
            graphics2D.draw(shape);
            graphics2D.setStroke(stroke);
        }
    }

    private synchronized void drawMatrix(Graphics2D graphics2D) {
        Shape shape = graphics2D.getClip();
        graphics2D.clip(this.createMatrixClip());
        double d = this.coreGenomeContext.getMatrixStartX();
        double d2 = this.coreGenomeContext.getMatrixStartY();
        double d3 = 0.0;
        int n = Integer.MIN_VALUE;
        int n2 = this.coreGenomeViewModel.getWindowSize();
        graphics2D.translate(d, d2);
        double d4 = this.coreGenomeContext.getGeneNodeSize() + this.coreGenomeContext.getGeneNodeIntervalY();
        int n3 = 0;
        for (String string : this.coreGenomeViewModel.getViewOrganismCodeList()) {
            OrthologSpNode orthologSpNode;
            int n4;
            OrthologGroup orthologGroup;
            int n5;
            int n6;
            for (n6 = 0; n6 < this.getGenomeAlign().getOrthologGroupSize() + this.coreGenomeViewModel.getWindowSize(); ++n6) {
                if (this.isOnlyConnectionDraw(d, n6)) {
                    if (n2 < 0) break;
                    --n2;
                }
                n5 = this.coreGenomeContext.convertOrthologGroupStartIndex(n6, this.getGenomeAlign().getOrthologGroupSize());
                orthologGroup = this.getGenomeAlign().getOrthologGroup(n5);
                n4 = orthologGroup.getClusterNo();
                if (this.isChangeCluster(n4, n)) {
                    graphics2D.translate(this.coreGenomeContext.getClusterBlankWidth(), 0.0);
                    d += this.coreGenomeContext.getClusterBlankWidth();
                }
                n = n4;
                orthologSpNode = orthologGroup.getOrthologSpNode(string);
                if (orthologSpNode != null && !this.drawConnection(graphics2D, d, orthologSpNode)) {
                    return;
                }
                graphics2D.translate(this.coreGenomeContext.getDirectionWidth(), 0.0);
                d += this.coreGenomeContext.getDirectionWidth();
            }
            graphics2D.translate(-(d - this.coreGenomeContext.getMatrixStartX()), 0.0);
            d = this.coreGenomeContext.getMatrixStartX();
            n = Integer.MIN_VALUE;
            for (n6 = 0; n6 < this.getGenomeAlign().getOrthologGroupSize(); ++n6) {
                n5 = this.coreGenomeContext.convertOrthologGroupStartIndex(n6, this.getGenomeAlign().getOrthologGroupSize());
                orthologGroup = this.getGenomeAlign().getOrthologGroup(n5);
                n4 = orthologGroup.getClusterNo();
                if (this.isChangeCluster(n4, n)) {
                    graphics2D.translate(this.coreGenomeContext.getClusterBlankWidth(), 0.0);
                    d += this.coreGenomeContext.getClusterBlankWidth();
                }
                n = n4;
                orthologSpNode = orthologGroup.getOrthologSpNode(string);
                if (orthologSpNode != null && !this.isOnlyConnectionDraw(d, n6)) {
                    this.drawGeneNode(graphics2D, orthologSpNode.getLocusTagCount());
                }
                graphics2D.translate(this.coreGenomeContext.getDirectionWidth(), 0.0);
                d += this.coreGenomeContext.getDirectionWidth();
            }
            graphics2D.translate(-(d - this.coreGenomeContext.getMatrixStartX()), d4);
            d3 += d4;
            d = this.coreGenomeContext.getMatrixStartX();
            n = Integer.MIN_VALUE;
            ++n3;
        }
        graphics2D.translate(-d, -(d3 + d2));
        graphics2D.setClip(shape);
    }

    protected boolean drawConnection(Graphics2D graphics2D, double d, OrthologSpNode orthologSpNode) {
        List list = this.getGenomeAlign().getConnectionList(orthologSpNode);
        for (OrthologSpNodeConnection orthologSpNodeConnection : list) {
            float f = this.calcConnectionSx();
            float f2 = this.calcConnectionSy();
            float f3 = this.calcConnectionEx(orthologSpNodeConnection);
            float f4 = f2;
            if (!this.isDrawConnection(d, f3)) continue;
            Double d2 = (Double)this.coreGenomeViewModel.getConnectionDepthMap().get(orthologSpNodeConnection);
            if (d2 == null) {
                return false;
            }
            double d3 = d2 * this.coreGenomeContext.getConnectionDepth();
            this.drawConnection(graphics2D, orthologSpNodeConnection, f, f2, f3, f4, d3);
        }
        return true;
    }

    private float calcConnectionSx() {
        return (float)this.coreGenomeContext.getGeneNodeSize() * 0.4f;
    }

    private float calcConnectionSy() {
        return (float)this.coreGenomeContext.getGeneNodeSize() * 0.5f;
    }

    private float calcConnectionEx(OrthologSpNodeConnection orthologSpNodeConnection) {
        int n = this.getGenomeAlign().getOrthologGroupDiff(orthologSpNodeConnection);
        int n2 = this.getGenomeAlign().getClusterDiff(orthologSpNodeConnection);
        return (float)this.coreGenomeContext.getGeneNodeSize() * ((float)n + 0.6f) + (float)this.coreGenomeContext.getOrthologGroupIntervalX() * (float)n + (float)n2 * (float)this.coreGenomeContext.getClusterBlankWidth();
    }

    private boolean isDrawConnection(double d, double d2) {
        double d3 = d * this.coreGenomeContext.getScaleX();
        return !(d3 > this.coreGenomeContext.getCanvasWidth() && d2 + d3 > this.coreGenomeContext.getCanvasWidth()) && (!(d3 < 0.0) || !(d2 + d3 < 0.0));
    }

    private void drawConnection(Graphics2D graphics2D, OrthologSpNodeConnection orthologSpNodeConnection, float f, float f2, float f3, float f4, double d) {
        int n = orthologSpNodeConnection.getFromOrthologGroup().getRealOrderIndex();
        int n2 = orthologSpNodeConnection.getToOrthologGroup().getRealOrderIndex();
        boolean bl = this.isExistLocusTag(orthologSpNodeConnection.getFromOrthologSpNode().getOrganism(), n, n2);
        boolean bl2 = orthologSpNodeConnection.getOrthologGroupDiff() == -1;
        boolean bl3 = bl2 || !bl && d == 0.0;
        Stroke stroke = this.getConnectionStroke(bl3, orthologSpNodeConnection.getGeneDiff());
        Shape shape = this.createConnectionShape(bl3, f, f2, f3, f4, d);
        graphics2D.setColor(this.getConnectionColor(orthologSpNodeConnection));
        Stroke stroke2 = graphics2D.getStroke();
        graphics2D.setStroke(stroke);
        graphics2D.draw(shape);
        graphics2D.setStroke(stroke2);
    }

    protected void drawGeneNode(Graphics2D graphics2D, int n) {
        Shape shape = this.createGeneNodeShape(n);
        graphics2D.setColor(Color.black);
        graphics2D.fill(shape);
    }

    protected boolean isChangeCluster(int n, int n2) {
        return n2 != Integer.MIN_VALUE && n2 != n;
    }

    protected boolean isOnlyConnectionDraw(double d, int n) {
        return d >= this.coreGenomeContext.getCanvasWidth() / this.coreGenomeContext.getScaleX() || n >= this.coreGenomeViewModel.getGenomeAlign().getOrthologGroupSize();
    }

    protected Color getConnectionColor(OrthologSpNodeConnection orthologSpNodeConnection) {
        Color color = orthologSpNodeConnection.isDirectionInterval() ? Color.red : (orthologSpNodeConnection.getGeneDiff() > 1 ? Color.green : Color.black);
        return color;
    }

    protected Stroke getConnectionStroke(boolean bl, int n) {
        Stroke stroke = null;
        float f = bl ? this.coreGenomeContext.getConnectionThick() : this.coreGenomeContext.getConnectionPolyThick();
        stroke = n == 0 ? this.createDashLineStroke(f) : new BasicStroke(f);
        return stroke;
    }

    private Stroke createDashLineStroke(float f) {
        return new BasicStroke(f, 0, 0, 1.0f, SAME_GENE_DASHES, 0.0f);
    }

    protected Shape createConnectionShape(boolean bl, float f, float f2, float f3, float f4, double d) {
        Shape shape;
        if (bl) {
            shape = new Line2D.Float(f, f2, f3, f4);
        } else {
            float f5 = f2 - (float)(d * 2.0 + this.coreGenomeContext.getGeneNodeSize() * 0.5 + this.coreGenomeContext.getConnectionMarginY());
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(f, f2);
            generalPath.lineTo(f, f5);
            generalPath.lineTo(f3, f5);
            generalPath.lineTo(f3, f4);
            shape = generalPath;
        }
        return shape;
    }

    private Shape createMatrixClip() {
        double d = this.coreGenomeContext.getCanvasWidth() / this.coreGenomeContext.getScaleX() - this.coreGenomeContext.getDirectionStartX() - this.coreGenomeContext.getMarginRight() / this.coreGenomeContext.getScaleX();
        double d2 = this.coreGenomeContext.calcMatrixWidth(this.getGenomeAlign().getOrthologGroupSize(), this.getGenomeAlign().getClusterCount());
        double d3 = Math.min(d, d2) - 1.0 / this.coreGenomeContext.getScaleX();
        double d4 = (this.coreGenomeContext.getMarginTop() + this.coreGenomeContext.getMarginBottom()) / this.coreGenomeContext.getScaleY() + (this.calcHeight() - (this.coreGenomeContext.getMarginTop() + this.coreGenomeContext.getMarginBottom()));
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.coreGenomeContext.getDirectionStartX(), 0.0, d3, d4);
        return double_;
    }

    protected boolean isExistLocusTag(String string, int n, int n2) {
        boolean bl = false;
        int n3 = n;
        int n4 = n2;
        if (n < n2) {
            n3 = n2;
            n4 = n;
        }
        for (int i = n3 - 1; i > n4; --i) {
            int n5 = this.getGenomeAlign().adjustOrthologGroupIndexForChromCirular(i);
            OrthologGroup orthologGroup = this.getGenomeAlign().getOrthologGroup(n5);
            boolean bl2 = bl = orthologGroup.getLocusTagCount(string) != 0;
            if (bl) break;
        }
        return bl;
    }

    protected Shape createDirectionShape(int n) {
        float f = (float)this.coreGenomeContext.getDirectionWidth();
        float f2 = (float)this.coreGenomeContext.getDirectionHeight();
        return CoreGenomeUtil.createDirectionShape(f, f2, n);
    }

    protected Shape createGeneNodeShape(int n) {
        float f = (float)this.coreGenomeContext.getGeneNodeSize();
        RectangularShape rectangularShape = null;
        if (n == 1) {
            rectangularShape = new Ellipse2D.Double(0.0, 0.0, f, f);
        } else if (n > 1) {
            rectangularShape = new Rectangle2D.Double(0.0, 0.0, f, f);
        }
        return rectangularShape;
    }

    public final void setModel(CoreGenomeViewModel coreGenomeViewModel, CoreGenomeContext coreGenomeContext) {
        this.setCoreGenomeViewModel(coreGenomeViewModel);
        this.setCoreGenomeContext(coreGenomeContext);
        this.updateConnectionDepthMap();
    }

    public CoreGenomeViewModel getCoreGenomeViewModel() {
        return this.coreGenomeViewModel;
    }

    protected void setCoreGenomeViewModel(CoreGenomeViewModel coreGenomeViewModel) {
        this.coreGenomeViewModel = coreGenomeViewModel;
    }

    public GenomeAlign getGenomeAlign() {
        return this.coreGenomeViewModel.getGenomeAlign();
    }

    public CoreGenomeContext getCoreGenomeContext() {
        return this.coreGenomeContext;
    }

    private void setCoreGenomeContext(CoreGenomeContext coreGenomeContext) {
        this.coreGenomeContext = coreGenomeContext;
    }

    public boolean isResizeFlag() {
        return this.resizeFlag;
    }

    public void setResizeFlag(boolean bl) {
        this.resizeFlag = bl;
    }

    public double calcHeight() {
        this.coreGenomeContext.setGeneNameHeight(this.calcGeneNameHeight());
        return this.coreGenomeContext.calcHeight(this.coreGenomeViewModel.getViewOrganismSize());
    }

    public double calcMatrixHeight() {
        return this.calcHeight() - this.calcHeaderHeight() + this.coreGenomeContext.getConnectionMaxDrawHeight();
    }

    public double calcHeaderHeight() {
        return this.coreGenomeContext.getDirectionStartY() + this.coreGenomeContext.getDirectionHeight() + this.coreGenomeContext.getDirectionIntervalY();
    }

    protected synchronized void updateConnectionDepthMap() {
        if (this.coreGenomeViewModel.isDurtyConnectionDepthMap()) {
            ConnectionDepthCalculator connectionDepthCalculator = new ConnectionDepthCalculator(this.coreGenomeViewModel, this.coreGenomeContext, this.getGenomeAlign().getOrthologGroupSize(), this.coreGenomeContext.getConnectionMaxViewCount());
            this.coreGenomeViewModel.setConnectionDepthMap(connectionDepthCalculator.calcConnectionDepth());
            this.coreGenomeViewModel.setUpdateConnectionDepth(false);
        }
    }

    public synchronized void clearCache() {
        this.coreGenomeViewModel.clearConnectionDepthMap();
    }

    public void drawFocusOrthologGroup(Graphics2D graphics2D) {
        int n = this.coreGenomeViewModel.getCoreGenomeSearch().getOrthologGroupIndex();
        if (n == -1) {
            return;
        }
        Rectangle rectangle = this.coreGenomeContext.getOrthologGroupRect(n, this.getGenomeAlign());
        Composite composite = graphics2D.getComposite();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.5f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.setColor(Color.red);
        graphics2D.fill(rectangle);
        graphics2D.setComposite(composite);
    }

    public void drawHitOrthologGroup(Graphics2D graphics2D) {
        CoreGenomeSearch coreGenomeSearch = this.coreGenomeViewModel.getCoreGenomeSearch();
        if (!coreGenomeSearch.isExistSearchResult()) {
            return;
        }
        Composite composite = graphics2D.getComposite();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.5f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.setColor(Color.red);
        for (CoreGenomeSearchResult coreGenomeSearchResult : coreGenomeSearch.getCoreGenomeSearchResultList()) {
            int n = coreGenomeSearchResult.getOrthologGroupIndex();
            Rectangle rectangle = this.coreGenomeContext.getOrthologGroupRect(n, this.getGenomeAlign());
            graphics2D.fill(rectangle);
        }
        graphics2D.setComposite(composite);
    }

    void drawSelectedOrthologGroup(Graphics2D graphics2D) {
        if (!this.coreGenomeViewModel.isExistSelectedOrthologGroup()) {
            return;
        }
        Composite composite = graphics2D.getComposite();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.5f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.setColor(Color.blue);
        for (OrthologGroup orthologGroup : this.coreGenomeViewModel.getSelectedOrthologGroupList()) {
            int n = this.getGenomeAlign().indexOfOrthologGroup(orthologGroup);
            if (n == -1) continue;
            Rectangle rectangle = this.coreGenomeContext.getOrthologGroupRect(n, this.getGenomeAlign());
            graphics2D.fill(rectangle);
        }
        graphics2D.setComposite(composite);
    }

    public int getViewOrthologGroupCount() {
        return this.coreGenomeContext.getViewOrthologGroupCount();
    }

    public Organism getOrganism(int n) {
        float f = (float)this.calcOffsetTopForMatrix();
        float f2 = (float)(this.coreGenomeContext.getOrganismStartY() - this.coreGenomeContext.getGeneNodeSize() - (double)f);
        if ((float)n < f2) {
            return null;
        }
        float f3 = f2;
        float f4 = (float)(this.coreGenomeContext.getGeneNodeIntervalY() + this.coreGenomeContext.getGeneNodeSize());
        Organism organism = null;
        for (Organism organism2 : this.coreGenomeViewModel.getViewOrganismList()) {
            if (f3 <= (float)n && f3 + f4 > (float)n) {
                organism = organism2;
                break;
            }
            f3 += f4;
        }
        return organism;
    }

    boolean isOrganismTitleX(Point point) {
        return this.coreGenomeContext.isOrganismTitleX(point);
    }
}

