/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.coregenome.CoreGenomeSearchResult;
import cgdp.recog.coregenome.CoreGenomeViewModel;
import cgdp.recog.coregenome.GenomeAlign;
import java.util.ArrayList;
import java.util.List;

class CoreGenomeSearch {
    static final int TYPE_GENE_NAME = 1;
    static final int TYPE_LOCUS_TAG = 2;
    static final int TYPE_BOTH = 3;
    private String keyword = "";
    private String preKeyword = "";
    private int searchType = 1;
    private int preSearchType = 1;
    private List coreGenomeSearchResultList = new ArrayList();
    private int searchResultFocusIndex = -1;
    private CoreGenomeViewModel coreGenomeViewModel;

    CoreGenomeSearch(CoreGenomeViewModel coreGenomeViewModel) {
        this.coreGenomeViewModel = coreGenomeViewModel;
    }

    void execute() {
        GenomeAlign genomeAlign = this.coreGenomeViewModel.getGenomeAlign();
        if (!this.isChangeCondition()) {
            if (!this.isExistSearchResult()) {
                this.searchResultFocusIndex = -1;
                return;
            }
            ++this.searchResultFocusIndex;
            if (this.searchResultFocusIndex >= this.coreGenomeSearchResultList.size()) {
                this.searchResultFocusIndex = 0;
            }
        } else if (this.keyword.equals("")) {
            this.coreGenomeSearchResultList.clear();
            this.searchResultFocusIndex = -1;
            this.preKeyword = this.keyword;
            this.preSearchType = this.searchType;
        } else {
            this.coreGenomeSearchResultList = genomeAlign.searchOrthologGroupList(this.keyword, this.searchType);
            this.searchResultFocusIndex = this.isExistSearchResult() ? 0 : -1;
            this.preKeyword = this.keyword;
            this.preSearchType = this.searchType;
        }
    }

    private boolean isChangeCondition() {
        return !this.preKeyword.equals(this.keyword) || this.preSearchType != this.searchType;
    }

    void setKeyword(String string) {
        if (string == null) {
            string = "";
        }
        this.keyword = string;
    }

    void setSearchType(int n) {
        this.searchType = n;
    }

    int getOrthologGroupIndex() {
        if (!this.isExistFocusResult() || !this.isExistSearchResult()) {
            return -1;
        }
        CoreGenomeSearchResult coreGenomeSearchResult = (CoreGenomeSearchResult)this.coreGenomeSearchResultList.get(this.searchResultFocusIndex);
        return coreGenomeSearchResult.getOrthologGroupIndex();
    }

    List getCoreGenomeSearchResultList() {
        return this.coreGenomeSearchResultList;
    }

    boolean isExistFocusResult() {
        return this.searchResultFocusIndex != -1;
    }

    boolean isExistSearchResult() {
        return !this.coreGenomeSearchResultList.isEmpty();
    }

    static boolean isTypeGeneName(int n) {
        return n == 1 || n == 3;
    }

    static boolean isTypeLocusTag(int n) {
        return n == 2 || n == 3;
    }
}

