/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.coregenome.CoreGenomeAnalysis;
import cgdp.recog.coregenome.CoreGenomeUploader;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;

public class CoreGenomeUploadExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(CoreGenomeUploadExecuter.class);
    private Component parent;
    private CoreGenomeAnalysis analysis;
    private boolean overwrite = false;

    public CoreGenomeUploadExecuter(Component component, CoreGenomeAnalysis coreGenomeAnalysis, boolean bl) {
        this.parent = component;
        this.analysis = coreGenomeAnalysis;
        this.overwrite = bl;
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        progressImpl.setTotal(1);
        try {
            CoreGenomeUploader coreGenomeUploader = new CoreGenomeUploader(this.analysis, this.overwrite);
            coreGenomeUploader.execute();
            progressImpl.increment();
            if (coreGenomeUploader.isError()) {
                this.setError(true);
                this.setErrorMessage(coreGenomeUploader.getMessage());
                return;
            }
        }
        catch (Exception exception) {
            String string = "Fail to upload domclust results.";
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    @Override
    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
            return;
        }
        Runnable runnable = this.getAfterRunnable();
        if (runnable != null) {
            runnable.run();
        }
    }
}

