/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.organism.Organism;
import cgdp.recog.util.AbstractListSelectTableModel;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.ServerStatus;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.List;
import javax.swing.JTable;

public class CoreGenomeUtil {
    private static final ApplicationLogger logger = new ApplicationLogger(CoreGenomeUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSameDomClustId(String string, String string2) {
        if (new File(string).isDirectory()) {
            return true;
        }
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            fileInputStream = new FileInputStream(string);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string3 = bufferedReader.readLine();
            if (ServerStatus.isClusterId(string3)) {
                String string4 = ServerStatus.getClusterId(string3);
                boolean bl = string4.equals(string2);
                return bl;
            }
        }
        catch (IOException iOException) {
            logger.warn("Fail to load file:" + string, iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    logger.warn("Fail to load file:" + string, iOException);
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    logger.warn("Fail to load file:" + string, iOException);
                }
            }
        }
        return false;
    }

    public static void setInOutgroupForOrganims(List list, Collection collection, Collection collection2) {
        for (Organism organism : list) {
            if (collection.contains(organism.getOrganismCode())) {
                organism.setIngroup();
                continue;
            }
            if (!collection2.contains(organism.getOrganismCode())) continue;
            organism.setOutgroup();
        }
    }

    static Shape createDirectionShape(float f, float f2, int n) {
        GeneralPath generalPath = new GeneralPath();
        if (n == -1) {
            generalPath.moveTo(0.0f, f2 / 2.0f);
            generalPath.lineTo(f, 0.0f);
            generalPath.lineTo(f, f2);
            generalPath.lineTo(0.0f, f2 / 2.0f);
        } else {
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(f, f2 / 2.0f);
            generalPath.lineTo(0.0f, f2);
            generalPath.lineTo(0.0f, 0.0f);
        }
        return generalPath;
    }

    static String getToolTipString(MouseEvent mouseEvent, AbstractListSelectTableModel abstractListSelectTableModel) {
        JTable jTable = (JTable)mouseEvent.getSource();
        int n = jTable.rowAtPoint(mouseEvent.getPoint());
        int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
        if (n2 != 1) {
            return null;
        }
        List list = abstractListSelectTableModel.getDataList();
        Organism organism = (Organism)list.get(n);
        return "<html>" + organism.getName() + " " + organism.getStrain() + "</html>";
    }
}

