/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.coregenome.CoreCommonParamDTO;
import cgdp.recog.coregenome.CoreGenomeAlignmentCondition;
import cgdp.recog.coregenome.CoreGenomeChangeStartIndexEvent;
import cgdp.recog.coregenome.CoreGenomeContext;
import cgdp.recog.coregenome.CoreGenomeRenderer;
import cgdp.recog.coregenome.CoreGenomeSearch;
import cgdp.recog.coregenome.GenomeAlign;
import cgdp.recog.coregenome.OrthologGroup;
import cgdp.recog.observer.ApplicationObservable;
import cgdp.recog.observer.ApplicationObserver;
import cgdp.recog.observer.ApplicationObserverEvent;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismViewModel;
import cgdp.recog.ppm.PPMLabelCondition;
import cgdp.recog.ppm.PPMLabelType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CoreGenomeViewModel {
    private static final int MAX_VIEW_ORGANISM_COUNT = Integer.MAX_VALUE;
    private static final double[] ZOOM_SCALES = new double[]{0.5, 0.75, 1.0, 1.5, 2.0};
    private static final boolean DEFAULT_PRINT_SHOW_LEGEND = true;
    private static final int DEFAULT_PRINT_ROW_COUNT = 6;
    private static final boolean DEFAULT_ONE_PAGE_PRINT_FLAG = true;
    private static final boolean DEFAULT_ALL_ROW_SHOW_ORGANISM_NAME = true;
    private ApplicationObservable observable;
    private GenomeAlign genomeAlign;
    private CoreGenomeContext overviewCoreGenomeContext;
    private int viewOrthologGroupCountOnMain;
    private int viewOrthologGroupStartIndexOnMain;
    private int maxViewOrganismCount = Integer.MAX_VALUE;
    private int orthologGroupLabelType = 2;
    private Organism referenceOrganism;
    private int windowSize;
    private CoreGenomeSearch coreGenomeSearch = new CoreGenomeSearch(this);
    private double zoomScale = 1.0;
    private CoreGenomeRenderer printCoreGenomeRenderer;
    private Map connectionDepthMap = new HashMap();
    private boolean updateConnectionDepth = true;
    private OrganismViewModel organismViewModel;
    private boolean showLegend = true;
    private int rowCountParPage = 6;
    private boolean onePagePrintFlag = true;
    private boolean allRowShowOrganismName = true;
    private boolean showPageNumber;
    private List selectedOrthologGroupList = new ArrayList();
    private CoreCommonParamDTO coreCommonParamDTO;

    public CoreGenomeViewModel() {
        this.organismViewModel = new OrganismViewModel();
    }

    public void setObservable(ApplicationObservable applicationObservable) {
        this.observable = applicationObservable;
    }

    public GenomeAlign getGenomeAlign() {
        return this.genomeAlign;
    }

    public void setGenomeAlign(GenomeAlign genomeAlign) {
        this.genomeAlign = genomeAlign;
    }

    public CoreGenomeContext getOverviewCoreGenomeContext() {
        return this.overviewCoreGenomeContext;
    }

    public void setOverviewCoreGenomeContext(CoreGenomeContext coreGenomeContext) {
        this.overviewCoreGenomeContext = coreGenomeContext;
    }

    public CoreGenomeSearch getCoreGenomeSearch() {
        return this.coreGenomeSearch;
    }

    public int getViewOrthologGroupCountOnMain() {
        return this.viewOrthologGroupCountOnMain;
    }

    public void setViewOrthologGroupCountOnMain(int n) {
        this.viewOrthologGroupCountOnMain = n;
    }

    public int getViewOrthologGroupEndIndexOnMain() {
        int n;
        int n2 = this.viewOrthologGroupStartIndexOnMain + this.viewOrthologGroupCountOnMain;
        int n3 = this.getGenomeAlign().getClusterCount(this.viewOrthologGroupStartIndexOnMain);
        int n4 = this.getGenomeAlign().getClusterCount(n2);
        if (n4 > (n = this.getGenomeAlign().getClusterCount(n2 -= n4 - n3))) {
            ++n2;
        }
        if (n2 >= this.genomeAlign.getOrthologGroupSize()) {
            n2 -= this.genomeAlign.getOrthologGroupSize();
        }
        return n2;
    }

    public int getViewOrthologGroupStartIndexOnMain() {
        return this.viewOrthologGroupStartIndexOnMain;
    }

    public void setViewOrthologGroupStartIndexOnMain(int n) {
        this.viewOrthologGroupStartIndexOnMain = n;
    }

    public void addOrthologGroupStartIndex(int n, int n2) {
        int n3 = this.getViewOrthologGroupStartIndexOnMain() + n;
        if (n3 < 0) {
            while (n3 < 0) {
                n3 += n2;
            }
        } else if (n3 >= n2 - this.getViewOrthologGroupCountOnMain()) {
            while (n3 >= n2) {
                n3 -= n2;
            }
        }
        this.setViewOrthologGroupStartIndexOnMain(n3);
    }

    public Organism getReferenceOrganism() {
        return this.referenceOrganism;
    }

    public void setReferenceOrganism(Organism organism) {
        this.referenceOrganism = organism;
    }

    public List getOrganismList() {
        return this.getGenomeAlign().getOrganismList();
    }

    public List getOrganismCodeList() {
        return this.getGenomeAlign().getOrganismCodeList();
    }

    public List getViewOrganismList() {
        return this.organismViewModel.getViewOrganismList();
    }

    public int getViewOrganismSize() {
        return this.organismViewModel.getViewOrganismCount();
    }

    public void setViewOrganismList(List list) {
        ArrayList arrayList = list.size() > this.getMaxViewOrganismCount() ? new ArrayList(list.subList(0, this.getMaxViewOrganismCount())) : new ArrayList(list);
        this.organismViewModel.setViewOrganismList(arrayList);
    }

    public List getViewOrganismNameList() {
        return this.organismViewModel.getViewOrganismNameList();
    }

    public List getViewOrganismCodeList() {
        return this.organismViewModel.getViewOrganismCodeList();
    }

    public int getMaxViewOrganismCount() {
        return this.maxViewOrganismCount;
    }

    public void setMaxViewOrganismCount(int n) {
        this.maxViewOrganismCount = n;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int n) {
        this.windowSize = n;
    }

    public int getOrganismNameType() {
        return this.organismViewModel.getOrganismNameType();
    }

    public boolean isOrganismNameTypeNormal() {
        return this.organismViewModel.isOrganismNameTypeNormal();
    }

    public boolean isOrganismNameTypeAbbrev() {
        return this.organismViewModel.isOrganismNameTypeAbbrev();
    }

    public void setOrganismNameType(int n) {
        this.organismViewModel.setOrganismNameType(n);
    }

    public boolean isAddStrainToName() {
        return this.organismViewModel.isAddStrainToName();
    }

    public void setAddStrainToName(boolean bl) {
        this.organismViewModel.setAddStrainToName(bl);
    }

    public boolean isShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(boolean bl) {
        this.showLegend = bl;
    }

    public int getRowCountParPage() {
        return this.rowCountParPage;
    }

    public void setRowCountParPage(int n) {
        this.rowCountParPage = n;
    }

    public boolean isOnePagePrintFlag() {
        return this.onePagePrintFlag;
    }

    public void setOnePagePrintFlag(boolean bl) {
        this.onePagePrintFlag = bl;
    }

    public boolean isAllRowShowOrganismName() {
        return this.allRowShowOrganismName;
    }

    public void setAllRowShowOrganismName(boolean bl) {
        this.allRowShowOrganismName = bl;
    }

    public boolean isShowPageNumber() {
        return this.showPageNumber;
    }

    public void setShowPageNumber(boolean bl) {
        this.showPageNumber = bl;
    }

    public double getZoomScale() {
        return this.zoomScale;
    }

    public List getZoomScaleList() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < ZOOM_SCALES.length; ++i) {
            arrayList.add(new Double(ZOOM_SCALES[i]));
        }
        return arrayList;
    }

    public void setZoomScale(double d) {
        this.zoomScale = d;
    }

    private int getZoomScaleIndex(double d) {
        int n = -1;
        for (int i = 0; i < ZOOM_SCALES.length; ++i) {
            double d2 = ZOOM_SCALES[i];
            if (d2 != d) continue;
            n = i;
            break;
        }
        return n;
    }

    public double getZoominScale() {
        double d = this.getZoomScale();
        int n = this.getZoomScaleIndex(this.getZoomScale());
        if (CoreGenomeViewModel.canZoomin(n)) {
            d = ZOOM_SCALES[n + 1];
        }
        return d;
    }

    public double getZoomoutScale() {
        double d = this.getZoomScale();
        int n = this.getZoomScaleIndex(this.getZoomScale());
        if (CoreGenomeViewModel.canZoomout(n)) {
            d = ZOOM_SCALES[n - 1];
        }
        return d;
    }

    public boolean canZoomin() {
        int n = this.getZoomScaleIndex(this.getZoomScale());
        return CoreGenomeViewModel.canZoomin(n);
    }

    private static boolean canZoomin(int n) {
        return n < ZOOM_SCALES.length - 1;
    }

    public boolean canZoomout() {
        int n = this.getZoomScaleIndex(this.getZoomScale());
        return CoreGenomeViewModel.canZoomout(n);
    }

    public static boolean canZoomout(int n) {
        return n > 0;
    }

    public CoreGenomeAlignmentCondition createCoreGenomeAlignmentCondition() {
        CoreGenomeAlignmentCondition coreGenomeAlignmentCondition = new CoreGenomeAlignmentCondition();
        coreGenomeAlignmentCondition.setDomClustId(this.getGenomeAlign().getDomClustId());
        coreGenomeAlignmentCondition.setClusterViewId(this.getGenomeAlign().getClusterViewId());
        coreGenomeAlignmentCondition.setOrganismList(this.getGenomeAlign().getOrganismList());
        coreGenomeAlignmentCondition.setReferenceOrganism(this.getReferenceOrganism());
        coreGenomeAlignmentCondition.setViewOrganismList(this.getViewOrganismList());
        coreGenomeAlignmentCondition.setOrganismNameType(this.getOrganismNameType());
        coreGenomeAlignmentCondition.setAddStrainToName(this.isAddStrainToName());
        coreGenomeAlignmentCondition.setWindowSize(this.getWindowSize());
        coreGenomeAlignmentCondition.setViewOrthologGroupStartIndexOnMain(this.getViewOrthologGroupStartIndexOnMain());
        return coreGenomeAlignmentCondition;
    }

    public boolean equalsReferenceOrganism(Organism organism) {
        if (organism == null && this.referenceOrganism == null) {
            return true;
        }
        if (organism == null && this.referenceOrganism != null) {
            return false;
        }
        if (organism != null && this.referenceOrganism == null) {
            return false;
        }
        return organism.equalsOrganism(this.referenceOrganism);
    }

    boolean isReferenceOrganism(String string) {
        if (this.getReferenceOrganism() == null) {
            return false;
        }
        return this.getReferenceOrganism().getOrganismCode().equals(string);
    }

    public boolean equalsViewOrganismList(List list) {
        if (list == null) {
            return false;
        }
        if (list.size() != this.getViewOrganismSize()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            Organism organism;
            Organism organism2 = (Organism)list.get(i);
            if (organism2.equalsOrganism(organism = (Organism)this.getViewOrganismList().get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsViewOrganismSet(Set set) {
        if (set == null) {
            return false;
        }
        if (set.size() != this.getViewOrganismSize()) {
            return false;
        }
        return set.containsAll(this.getViewOrganismList());
    }

    public boolean equalsWindowSize(int n) {
        return this.windowSize == n;
    }

    public void addObserver(ApplicationObserver applicationObserver) {
        this.observable.addObserver(applicationObserver);
    }

    public void deleteObserver(ApplicationObserver applicationObserver) {
        this.observable.deleteObserver(applicationObserver);
    }

    public void deleteObservers() {
        this.observable.deleteObservers();
    }

    public void nodifyObservers(ApplicationObserverEvent applicationObserverEvent) {
        this.observable.notifyObservers(applicationObserverEvent);
    }

    void copy(CoreGenomeViewModel coreGenomeViewModel) {
        this.setGenomeAlign(coreGenomeViewModel.getGenomeAlign());
        this.setViewOrthologGroupCountOnMain(coreGenomeViewModel.getViewOrthologGroupCountOnMain());
        this.setReferenceOrganism(coreGenomeViewModel.getReferenceOrganism());
        this.setViewOrganismList(coreGenomeViewModel.getViewOrganismList());
        this.setWindowSize(coreGenomeViewModel.getWindowSize());
        this.setOrganismNameType(coreGenomeViewModel.getOrganismNameType());
        this.setAddStrainToName(coreGenomeViewModel.isAddStrainToName());
        this.setViewOrthologGroupStartIndexOnMain(coreGenomeViewModel.getViewOrthologGroupStartIndexOnMain());
        this.setOrthologGroupLabelType(coreGenomeViewModel.getOrthologGroupLabelType());
    }

    public void setCondition(CoreGenomeAlignmentCondition coreGenomeAlignmentCondition) {
        this.setReferenceOrganism(coreGenomeAlignmentCondition.getReferenceOrganism());
        this.setViewOrganismList(coreGenomeAlignmentCondition.getViewOrganismList());
        this.setWindowSize(coreGenomeAlignmentCondition.getWindowSize());
        this.setOrganismNameType(coreGenomeAlignmentCondition.getOrganismNameType());
        this.setAddStrainToName(coreGenomeAlignmentCondition.isAddStrainToName());
        this.setOrthologGroupLabelType(coreGenomeAlignmentCondition.getOrthologGroupLabelType());
    }

    public void moveViewOrthologGroupStartIndexForCenter(int n) {
        if (n < 0) {
            return;
        }
        int n2 = n - this.getViewOrthologGroupCountOnMain() / 2;
        if (n2 < 0) {
            n2 += this.getGenomeAlign().getOrthologGroupSize();
        }
        this.viewOrthologGroupStartIndexOnMain = n2;
    }

    void moveLeft() {
        int n = this.getGenomeAlign().getOrthologGroupSize();
        this.addOrthologGroupStartIndex(-(this.getViewOrthologGroupCountOnMain() / 2), n);
        CoreGenomeChangeStartIndexEvent coreGenomeChangeStartIndexEvent = new CoreGenomeChangeStartIndexEvent(this, this.getViewOrthologGroupStartIndexOnMain());
        this.nodifyObservers(coreGenomeChangeStartIndexEvent);
    }

    void moveRight() {
        int n = this.getGenomeAlign().getOrthologGroupSize();
        this.addOrthologGroupStartIndex(this.getViewOrthologGroupCountOnMain() / 2, n);
        CoreGenomeChangeStartIndexEvent coreGenomeChangeStartIndexEvent = new CoreGenomeChangeStartIndexEvent(this, this.getViewOrthologGroupStartIndexOnMain());
        this.nodifyObservers(coreGenomeChangeStartIndexEvent);
    }

    public int getClusterCountForOverview(int n) {
        return this.getGenomeAlign().getClusterCount(this.getOverviewCoreGenomeContext().getOrthologGroupStartIndex(), n + this.getOverviewCoreGenomeContext().getOrthologGroupStartIndex());
    }

    public double calcXForOverview(int n) {
        int n2 = this.getClusterCountForOverview(n);
        return this.getOverviewCoreGenomeContext().calcX(n, n2);
    }

    public int calcStartOrthologGroupIndexByCenterIndex(int n) {
        int n2;
        for (n2 = n - this.getGenomeAlign().getOrthologGroupSize() / 2; n2 < 0; n2 += this.getGenomeAlign().getOrthologGroupSize()) {
        }
        while (n2 >= this.getGenomeAlign().getOrthologGroupSize()) {
            n2 -= this.getGenomeAlign().getOrthologGroupSize();
        }
        return n2;
    }

    public synchronized Map getConnectionDepthMap() {
        return this.connectionDepthMap;
    }

    public synchronized void setConnectionDepthMap(Map map) {
        this.connectionDepthMap = map;
    }

    public synchronized void clearConnectionDepthMap() {
        if (this.isDurtyConnectionDepthMap()) {
            if (this.connectionDepthMap != null) {
                this.connectionDepthMap.clear();
            }
            this.connectionDepthMap = null;
        }
    }

    private boolean isUpdateConnectionDepth() {
        return this.updateConnectionDepth;
    }

    public void setUpdateConnectionDepth(boolean bl) {
        this.updateConnectionDepth = bl;
    }

    public boolean isDurtyConnectionDepthMap() {
        return this.connectionDepthMap == null || this.connectionDepthMap.isEmpty() || this.isUpdateConnectionDepth();
    }

    public CoreGenomeRenderer getPrintCoreGenomeRenderer() {
        return this.printCoreGenomeRenderer;
    }

    void setPrintCoreGenomeRenderer(CoreGenomeRenderer coreGenomeRenderer) {
        this.printCoreGenomeRenderer = coreGenomeRenderer;
    }

    List getSelectedOrthologGroupList() {
        return this.selectedOrthologGroupList;
    }

    void clearSelectedOrthologGroupList() {
        this.selectedOrthologGroupList.clear();
    }

    boolean isExistSelectedOrthologGroup() {
        return !this.selectedOrthologGroupList.isEmpty();
    }

    void setSelectOrthologGroup(OrthologGroup orthologGroup) {
        this.clearSelectedOrthologGroupList();
        this.selectedOrthologGroupList.add(orthologGroup);
    }

    void setSelectOrthologGroupSet(Set set) {
        this.clearSelectedOrthologGroupList();
        this.selectedOrthologGroupList.addAll(set);
    }

    OrganismViewModel getOrganismViewModel() {
        return this.organismViewModel;
    }

    String getDisplayOrganisnName(Organism organism) {
        return this.organismViewModel.getDisplayOrganisnName(organism);
    }

    void setCoreCommonParamDTO(CoreCommonParamDTO coreCommonParamDTO) {
        this.coreCommonParamDTO = coreCommonParamDTO;
    }

    CoreCommonParamDTO getCoreCommonParamDTO() {
        return this.coreCommonParamDTO;
    }

    void clearCoreCommonParamDTO() {
        this.coreCommonParamDTO = null;
    }

    Set getOrthologGroupSetByClusterId(Set set) {
        Set set2 = this.getGenomeAlign().getOrthologGroupSetByClusterId(set);
        return set2;
    }

    int getOrthologGroupLabelType() {
        return this.orthologGroupLabelType;
    }

    boolean isOrthologGroupLabelClusterID() {
        return PPMLabelType.isClusterId(this.getOrthologGroupLabelType());
    }

    public boolean equalsOrthologGroupLabelType(int n) {
        return this.getOrthologGroupLabelType() == n;
    }

    boolean isOrthologGroupLabelClusterGeneName() {
        return PPMLabelType.isClusterGeneName(this.getOrthologGroupLabelType());
    }

    boolean isOrthologGroupLabelRefGene() {
        return PPMLabelType.isRefGeneName(this.getOrthologGroupLabelType());
    }

    void setOrthologGroupLabelType(int n) {
        this.orthologGroupLabelType = n;
    }

    List getOrhotlogGroupLabelList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (OrthologGroup orthologGroup : this.getGenomeAlign().getOrthologGroupList()) {
            String string = PPMLabelCondition.getOrthologGroupLabel(orthologGroup, this.getOrthologGroupLabelType());
            if (string == null) {
                string = "";
            }
            arrayList.add(string);
        }
        return arrayList;
    }
}

