/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.coregenome.CoreGenomeContext;
import cgdp.recog.coregenome.GenomeAlign;
import cgdp.recog.coregenome.LegendContext;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;

class FoldCoreGenomeContext
extends CoreGenomeContext {
    private static final double DEFAULT_PANEL_ZOOM_SCALE_X = 1.0;
    private static final double DEFAULT_PANEL_ZOOM_SCALE_Y = 1.0;
    private double imageableWidth;
    private double imageableHeight;
    private List foldPointList = new ArrayList();
    private int pageIndex = 0;
    private int rowCountParPage;
    private int totalRowCount;
    private int firstColumnCount;
    private int otherColumnCount;
    private int lastColumnCount;
    private double matrixStartX;
    private double panelZoomScaleX = 1.0;
    private double panelZoomScaleY = 1.0;
    private LegendContext legendContext = new LegendContext();

    FoldCoreGenomeContext() {
    }

    public double getImageableWidth() {
        return this.imageableWidth;
    }

    public void setImageableWidth(double d) {
        this.imageableWidth = d;
    }

    public double getImageableHeight() {
        return this.imageableHeight;
    }

    public void setImageableHeight(double d) {
        this.imageableHeight = d;
    }

    public boolean isFoldPoint(int n) {
        return this.containsFoldPoint(n);
    }

    private boolean containsFoldPoint(int n) {
        return this.foldPointList.contains(new Integer(n));
    }

    public void setFoldPointList(List list) {
        this.foldPointList = list;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public boolean isFirstPage() {
        return this.getPageIndex() == 0;
    }

    public boolean isLastPage() {
        return this.getPageIndex() == this.getPageCount() - 1;
    }

    public boolean isLastOnePage() {
        return this.getPageIndex() == this.getPageCount() - 2;
    }

    public void setPageIndex(int n) {
        this.pageIndex = n;
    }

    public int getRowCountParPage() {
        return this.rowCountParPage;
    }

    public void setRowCountParPage(int n) {
        this.rowCountParPage = n;
    }

    public int getRowCountOfLastPage() {
        if (this.legendContext.isShowNextPageLegend()) {
            return 0;
        }
        int n = this.getTotalRowCount() % this.getRowCountParPage();
        if (n == 0) {
            n = this.getRowCountParPage();
        }
        return n;
    }

    public int getTotalRowCount() {
        return this.totalRowCount;
    }

    public void setTotalRowCount(int n) {
        this.totalRowCount = n;
    }

    public int getFirstColumnCount() {
        return this.firstColumnCount;
    }

    public void setFirstColumnCount(int n) {
        this.firstColumnCount = n;
    }

    public int getOtherColumnCount() {
        return this.otherColumnCount;
    }

    public void setOtherColumnCount(int n) {
        this.otherColumnCount = n;
    }

    public int getLastColumnCount() {
        return this.lastColumnCount;
    }

    public void setLastColumnCount(int n) {
        this.lastColumnCount = n;
    }

    public int getPageCount() {
        int n = 0;
        if (this.getTotalRowCount() % this.getRowCountParPage() != 0) {
            n = 1;
        }
        int n2 = this.getTotalRowCount() / this.getRowCountParPage() + n;
        if (this.legendContext.isShowNextPageLegend()) {
            ++n2;
        }
        return n2;
    }

    public int getStartOrthologGroupIndexFromPageIndex(GenomeAlign genomeAlign) {
        if (this.foldPointList == null || this.foldPointList.isEmpty()) {
            return 0;
        }
        int n = (Integer)this.foldPointList.get(this.getPageIndex() * this.getRowCountParPage());
        return n;
    }

    public int getColumnCountParPage(GenomeAlign genomeAlign) {
        if (this.foldPointList == null || this.foldPointList.isEmpty()) {
            return 0;
        }
        int n = (Integer)this.foldPointList.get(this.getPageIndex() * this.getRowCountParPage());
        int n2 = 0;
        n2 = this.isLastPage() || this.isLastOnePage() && this.legendContext.isShowNextPageLegend() ? ((Integer)this.foldPointList.get(0)).intValue() : ((Integer)this.foldPointList.get((this.getPageIndex() + 1) * this.getRowCountParPage())).intValue();
        int n3 = n2 - n;
        if (n3 <= 0) {
            n3 += genomeAlign.getOrthologGroupSize();
        }
        return n3;
    }

    public int getColumnCountParRow(int n) {
        if (n == 0 && this.isFirstPage()) {
            return this.getFirstColumnCount();
        }
        if (n == this.getRowCountParPage() - 1 && this.isLastPage()) {
            return this.getLastColumnCount();
        }
        return this.getOtherColumnCount();
    }

    double getGeneNameStartXForFold(boolean bl) {
        if (this.isFirstPage() || bl) {
            return this.calcMatrixStartX() + this.getGeneNameStartXAgainstOneOrhotlogGroup();
        }
        return this.getGeneNameStartXAgainstOneOrhotlogGroup() + this.getOrthologGroupIntervalX();
    }

    double getDirectionStartXForFold(boolean bl) {
        if (this.isFirstPage() || bl) {
            return this.calcMatrixStartX();
        }
        return this.getOrthologGroupIntervalX();
    }

    double getMatrixStartXForFold(boolean bl) {
        if (this.isFirstPage() || bl) {
            return this.calcMatrixStartX() + this.getMatrixStartXAgainstOrthologGroup();
        }
        return this.getMatrixStartXAgainstOrthologGroup() + this.getOrthologGroupIntervalX();
    }

    private double calcMatrixStartX() {
        return this.getMatrixStartX();
    }

    @Override
    public double getMatrixStartX() {
        return this.matrixStartX;
    }

    public void setMatrixStartX(double d) {
        this.matrixStartX = d;
    }

    private int getRowCount(int n) {
        return n + this.getPageIndex() * this.getRowCountParPage();
    }

    double getMatrixWidth(int n) {
        int n2 = this.getRowCount(n);
        if (n2 == 0) {
            return this.getFirstRowMatrixWidth();
        }
        if (n2 == this.getTotalRowCount() - 1) {
            return this.getLastRowMatrixWidth();
        }
        return this.getOtherRowMatrixWidth();
    }

    private double getFirstRowMatrixWidth() {
        return this.getOrthologGroupWidth() * (double)this.getFirstRowOrthologGroupCount() + this.getOrthologGroupIntervalX();
    }

    private double getOtherRowMatrixWidth() {
        return this.getOrthologGroupWidth() * (double)this.getOtherRowOrthologGroupCount() + this.getOrthologGroupIntervalX();
    }

    private double getLastRowMatrixWidth() {
        return this.getOrthologGroupWidth() * (double)this.getLastRowOrthologGroupCount() + this.getOrthologGroupIntervalX();
    }

    private int getFirstRowOrthologGroupCount() {
        return this.getFirstColumnCount();
    }

    private int getOtherRowOrthologGroupCount() {
        return this.getOtherColumnCount();
    }

    private int getLastRowOrthologGroupCount() {
        return this.getLastColumnCount();
    }

    public int convertOrthologGroupStartIndex(int n, int n2, GenomeAlign genomeAlign) {
        int n3;
        for (n3 = n + this.getStartOrthologGroupIndexFromPageIndex(genomeAlign); n3 < 0; n3 += n2) {
        }
        while (n3 >= n2) {
            n3 -= n2;
        }
        return n3;
    }

    public boolean isDrawMatrix(int n) {
        int n2 = Math.min(this.getTotalRowCount(), this.getRowCountParPage());
        if (this.isLastPage()) {
            n2 = this.getRowCountOfLastPage();
        }
        return n < n2;
    }

    public double getPanelZoomScaleX() {
        return this.panelZoomScaleX;
    }

    public void setPanelZoomScaleX(double d) {
        this.panelZoomScaleX = d;
    }

    public double getPanelZoomScaleY() {
        return this.panelZoomScaleY;
    }

    public void setPanelZoomScaleY(double d) {
        this.panelZoomScaleY = d;
    }

    @Override
    public void zoom(double d) {
        super.zoom(d);
        this.legendContext.zoom(d);
    }

    public LegendContext getLegendContext() {
        return this.legendContext;
    }

    public boolean isOneRow() {
        return this.getTotalRowCount() == 1;
    }

    public boolean isLastPageOnlyLegend() {
        return this.isLastPage() && this.getLegendContext().isShowNextPageLegend();
    }

    @Override
    protected float getFontSize() {
        return (float)this.getGeneNodeSize() * 1.2f;
    }

    protected float getOrganismFontSize() {
        return (float)(this.getGeneNodeSize() + this.getGeneNodeIntervalY());
    }

    public Font createOrganismFont() {
        return new Font("Times New Roman", 3, (int)this.getOrganismFontSize());
    }
}

